/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.actionmanager.views;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;
import org.netxms.api.client.SessionListener;
import org.netxms.api.client.SessionNotification;
import org.netxms.client.NXCSession;
import org.netxms.client.ServerAction;
import org.netxms.ui.eclipse.actionmanager.Activator;
import org.netxms.ui.eclipse.actionmanager.Messages;
import org.netxms.ui.eclipse.actionmanager.dialogs.EditActionDlg;
import org.netxms.ui.eclipse.actionmanager.views.helpers.ActionComparator;
import org.netxms.ui.eclipse.actionmanager.views.helpers.ActionLabelProvider;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.shared.SharedIcons;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class ActionManager
extends ViewPart
implements SessionListener {
    public static final String ID = "org.netxms.ui.eclipse.actionmanager.views.ActionManager";
    private static final String TABLE_CONFIG_PREFIX = "ActionList";
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_TYPE = 1;
    public static final int COLUMN_RCPT = 2;
    public static final int COLUMN_SUBJ = 3;
    public static final int COLUMN_DATA = 4;
    private SortableTableViewer viewer;
    private NXCSession session;
    private Map<Long, ServerAction> actions = new HashMap<Long, ServerAction>();
    private Action actionRefresh;
    private Action actionNew;
    private Action actionEdit;
    private Action actionDelete;

    public void createPartControl(Composite parent) {
        this.session = (NXCSession)ConsoleSharedData.getSession();
        parent.setLayout((Layout)new FillLayout());
        String[] columnNames = new String[]{Messages.ActionManager_ColumnName, Messages.ActionManager_ColumnType, Messages.ActionManager_ColumnRcpt, Messages.ActionManager_ColumnSubj, Messages.ActionManager_ColumnData};
        int[] columnWidths = new int[]{150, 90, 100, 120, 200};
        this.viewer = new SortableTableViewer(parent, columnNames, columnWidths, 0, 128, 65538);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)TABLE_CONFIG_PREFIX);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ActionLabelProvider());
        this.viewer.setComparator((ViewerComparator)new ActionComparator());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null) {
                    ActionManager.this.actionEdit.setEnabled(selection.size() == 1);
                    ActionManager.this.actionDelete.setEnabled(selection.size() > 0);
                }
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ActionManager.this.actionEdit.run();
            }
        });
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTableViewerSettings((SortableTableViewer)ActionManager.this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)ActionManager.TABLE_CONFIG_PREFIX);
            }
        });
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.session.addListener((SessionListener)this);
        this.refreshActionList();
    }

    public void setFocus() {
        this.viewer.getTable().setFocus();
    }

    public void dispose() {
        this.session.removeListener((SessionListener)this);
        super.dispose();
    }

    private void refreshActionList() {
        new ConsoleJob(Messages.ActionManager_LoadJobName, (IWorkbenchPart)this, "org.netxms.ui.eclipse.actionmanager", "org.netxms.ui.eclipse.actionmanager"){

            protected String getErrorMessage() {
                return Messages.ActionManager_LoadJobError;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void runInternal(IProgressMonitor monitor) throws Exception {
                List actions = ActionManager.this.session.getActions();
                Map map = ActionManager.this.actions;
                synchronized (map) {
                    ActionManager.this.actions.clear();
                    for (ServerAction a : actions) {
                        ActionManager.this.actions.put(a.getId(), a);
                    }
                }
                ActionManager.this.updateActionsList();
            }
        }.start();
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionNew);
        manager.add((IAction)this.actionDelete);
        manager.add((IAction)this.actionEdit);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionNew);
        manager.add((IAction)this.actionDelete);
        manager.add((IAction)this.actionEdit);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction(){

            public void run() {
                ActionManager.this.refreshActionList();
            }
        };
        this.actionNew = new Action(){

            public void run() {
                ActionManager.this.createAction();
            }
        };
        this.actionNew.setText(Messages.ActionManager_ActionNew);
        this.actionNew.setImageDescriptor(SharedIcons.ADD_OBJECT);
        this.actionEdit = new Action(){

            public void run() {
                ActionManager.this.editAction();
            }
        };
        this.actionEdit.setText(Messages.ActionManager_ActionProperties);
        this.actionEdit.setImageDescriptor(SharedIcons.EDIT);
        this.actionDelete = new Action(){

            public void run() {
                ActionManager.this.deleteActions();
            }
        };
        this.actionDelete.setText(Messages.ActionManager_ActionDelete);
        this.actionDelete.setImageDescriptor(SharedIcons.DELETE_OBJECT);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ActionManager.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        mgr.add((IAction)this.actionNew);
        mgr.add((IAction)this.actionDelete);
        mgr.add((IContributionItem)new Separator());
        mgr.add((IContributionItem)new GroupMarker("additions"));
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.actionEdit);
    }

    private void createAction() {
        final ServerAction action = new ServerAction(0L);
        EditActionDlg dlg = new EditActionDlg(this.getSite().getShell(), action, true);
        if (dlg.open() == 0) {
            new ConsoleJob(Messages.ActionManager_CreateJobName, (IWorkbenchPart)this, "org.netxms.ui.eclipse.actionmanager", "org.netxms.ui.eclipse.actionmanager"){

                protected String getErrorMessage() {
                    return Messages.ActionManager_CreateJobError;
                }

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    long id = ActionManager.this.session.createAction(action.getName());
                    action.setId(id);
                    ActionManager.this.session.modifyAction(action);
                }
            }.start();
        }
    }

    private void editAction() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        final ServerAction action = (ServerAction)selection.getFirstElement();
        EditActionDlg dlg = new EditActionDlg(this.getSite().getShell(), action, false);
        if (dlg.open() == 0) {
            new ConsoleJob(Messages.ActionManager_UpdateJobName, (IWorkbenchPart)this, "org.netxms.ui.eclipse.actionmanager", "org.netxms.ui.eclipse.actionmanager"){

                protected String getErrorMessage() {
                    return Messages.ActionManager_UodateJobError;
                }

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    ActionManager.this.session.modifyAction(action);
                }
            }.start();
        }
    }

    private void deleteActions() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (!MessageDialog.openConfirm((Shell)this.getSite().getShell(), (String)Messages.ActionManager_Confirmation, (String)Messages.ActionManager_ConfirmDelete)) {
            return;
        }
        final Object[] objects = selection.toArray();
        new ConsoleJob(Messages.ActionManager_DeleteJobName, (IWorkbenchPart)this, "org.netxms.ui.eclipse.actionmanager", "org.netxms.ui.eclipse.actionmanager"){

            protected String getErrorMessage() {
                return Messages.ActionManager_DeleteJobError;
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                int i = 0;
                while (i < objects.length) {
                    ActionManager.this.session.deleteAction(((ServerAction)objects[i]).getId());
                    ++i;
                }
            }
        }.start();
    }

    private void updateActionsList() {
        new UIJob(Messages.ActionManager_UiUpdateJobName){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IStatus runInUIThread(IProgressMonitor monitor) {
                Map map = ActionManager.this.actions;
                synchronized (map) {
                    ActionManager.this.viewer.setInput((Object)ActionManager.this.actions.values().toArray());
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notificationHandler(SessionNotification n) {
        switch (n.getCode()) {
            case 1006: 
            case 1007: {
                Map<Long, ServerAction> map = this.actions;
                synchronized (map) {
                    this.actions.put(n.getSubCode(), (ServerAction)n.getObject());
                }
                this.updateActionsList();
                break;
            }
            case 1008: {
                Map<Long, ServerAction> map = this.actions;
                synchronized (map) {
                    this.actions.remove(n.getSubCode());
                }
                this.updateActionsList();
            }
        }
    }
}

