/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.EOFException;
import java.io.IOException;
import org.eclipse.birt.core.archive.ArchiveUtil;

public abstract class ArchiveEntry {
    protected long offset = 0L;
    private static final int MAX_BUFFER_SIZE = 4096;
    protected byte[] buffer = new byte[4096];
    protected boolean buffer_dirty;
    protected int buffer_offset;
    protected int buffer_size;

    public abstract String getName() throws IOException;

    protected abstract long _getLength() throws IOException;

    protected abstract void _setLength(long var1) throws IOException;

    protected abstract void _flush() throws IOException;

    protected abstract void _refresh() throws IOException;

    public abstract int read(long var1, byte[] var3, int var4, int var5) throws IOException;

    public abstract void write(long var1, byte[] var3, int var4, int var5) throws IOException;

    public abstract void close() throws IOException;

    public final synchronized long getLength() throws IOException {
        long length = this._getLength();
        if (length < this.offset + (long)this.buffer_size) {
            return this.offset + (long)this.buffer_size;
        }
        return length;
    }

    public final synchronized void setLength(long length) throws IOException {
        if (length <= this.offset) {
            this.offset = length;
            this.buffer_size = 0;
            this.buffer_offset = 0;
            this.buffer_dirty = false;
        } else if (length <= this.offset + (long)this.buffer_size) {
            this.buffer_size = (int)(length - this.offset);
            if (this.buffer_size < this.buffer_offset) {
                this.buffer_offset = this.buffer_size;
            }
        }
        this._setLength(length);
    }

    public final synchronized void flush() throws IOException {
        this.saveBuffer();
        this._flush();
    }

    public final synchronized void refresh() throws IOException {
        if (!this.buffer_dirty) {
            this.offset += (long)this.buffer_offset;
            this.buffer_offset = 0;
            this.buffer_size = 0;
        }
        this._refresh();
    }

    public final synchronized void seek(long off) throws IOException {
        if (off > this.offset && off < this.offset + (long)this.buffer_size) {
            this.buffer_offset = (int)(off - this.offset);
            return;
        }
        this.flushBuffer();
        this.offset = off;
        this.buffer_size = 0;
        this.buffer_offset = 0;
    }

    public final synchronized long getPosition() throws IOException {
        return this.offset + (long)this.buffer_offset;
    }

    public final synchronized void write(int b) throws IOException {
        if (this.buffer_offset >= 4096) {
            this.flushBuffer();
        }
        this.buffer[this.buffer_offset++] = (byte)b;
        if (this.buffer_size < this.buffer_offset) {
            this.buffer_size = this.buffer_offset;
        }
        this.buffer_dirty = true;
    }

    public final synchronized void writeInt(int v) throws IOException {
        if (this.buffer_offset + 4 > 4096) {
            this.flushBuffer();
        }
        ArchiveUtil.integerToBytes(v, this.buffer, this.buffer_offset);
        this.buffer_offset += 4;
        if (this.buffer_size < this.buffer_offset) {
            this.buffer_size = this.buffer_offset;
        }
        this.buffer_dirty = true;
    }

    public final synchronized void writeLong(long v) throws IOException {
        if (this.buffer_offset + 8 >= 4096) {
            this.flushBuffer();
        }
        ArchiveUtil.longToBytes(v, this.buffer, this.buffer_offset);
        this.buffer_offset += 8;
        if (this.buffer_size < this.buffer_offset) {
            this.buffer_size = this.buffer_offset;
        }
        this.buffer_dirty = true;
    }

    public final synchronized void write(byte[] b, int off, int len) throws IOException {
        if (this.buffer_offset + len <= 4096) {
            System.arraycopy(b, off, this.buffer, this.buffer_offset, len);
            this.buffer_offset += len;
            if (this.buffer_size < this.buffer_offset) {
                this.buffer_size = this.buffer_offset;
            }
            this.buffer_dirty = true;
            return;
        }
        this.flushBuffer();
        if (len < 4096) {
            System.arraycopy(b, off, this.buffer, 0, len);
            this.buffer_offset = len;
            if (this.buffer_size < this.buffer_offset) {
                this.buffer_size = this.buffer_offset;
            }
        } else {
            this.write(this.offset, b, off, len);
            this.offset += (long)len;
        }
        this.buffer_dirty = true;
    }

    public final synchronized int read() throws IOException {
        if (this.buffer_offset >= this.buffer_size) {
            this.refreshBuffer(1);
            if (this.buffer_size < 1) {
                return -1;
            }
        }
        return this.buffer[this.buffer_offset++] & 0xFF;
    }

    public final synchronized int readInt() throws IOException {
        if (this.buffer_offset + 4 > this.buffer_size) {
            this.refreshBuffer(4);
            if (this.buffer_size < 4) {
                throw new EOFException();
            }
        }
        int v = ArchiveUtil.bytesToInteger(this.buffer, this.buffer_offset);
        this.buffer_offset += 4;
        return v;
    }

    public final synchronized long readLong() throws IOException {
        if (this.buffer_offset + 8 > this.buffer_size) {
            this.refreshBuffer(8);
            if (this.buffer_size < 8) {
                throw new EOFException();
            }
        }
        long v = ArchiveUtil.bytesToLong(this.buffer, this.buffer_offset);
        this.buffer_offset += 8;
        return v;
    }

    public final synchronized int read(byte[] b, int off, int len) throws IOException {
        int size;
        if (this.buffer_offset < this.buffer_size) {
            int size2 = Math.min(len, this.buffer_size - this.buffer_offset);
            System.arraycopy(this.buffer, this.buffer_offset, b, off, size2);
            this.buffer_offset += size2;
            return size2;
        }
        long remainSize = this._getLength() - this.offset - (long)this.buffer_offset;
        if (remainSize <= 0L) {
            return -1;
        }
        if (len < 4096) {
            this.refreshBuffer(1);
            int size3 = Math.min(len, this.buffer_size - this.buffer_offset);
            System.arraycopy(this.buffer, this.buffer_offset, b, off, size3);
            this.buffer_offset += size3;
            return size3;
        }
        this.saveBuffer();
        this.offset += (long)this.buffer_offset;
        this.buffer_size = 0;
        this.buffer_offset = 0;
        int readSize = len;
        if (remainSize < (long)readSize) {
            readSize = (int)remainSize;
        }
        if ((size = this.read(this.offset + (long)this.buffer_offset, b, off, readSize)) > 0) {
            this.offset += (long)size;
        }
        return size;
    }

    protected void discardBuffer() throws IOException {
        this.offset += (long)this.buffer_offset;
        this.buffer_offset = 0;
        this.buffer_size = 0;
    }

    protected void saveBuffer() throws IOException {
        if (this.buffer_dirty) {
            this.write(this.offset, this.buffer, 0, this.buffer_size);
            this.buffer_dirty = false;
        }
    }

    protected void flushBuffer() throws IOException {
        if (this.buffer_dirty) {
            this.write(this.offset, this.buffer, 0, this.buffer_size);
            this.buffer_dirty = false;
        }
        this.offset += (long)this.buffer_offset;
        this.buffer_offset = 0;
        this.buffer_size = 0;
    }

    protected void refreshBuffer(int minSize) throws IOException {
        if (this.buffer_dirty) {
            this.write(this.offset, this.buffer, 0, this.buffer_size);
            this.buffer_dirty = false;
        }
        this.offset += (long)this.buffer_offset;
        this.buffer_size -= this.buffer_offset;
        if (this.buffer_size > 0) {
            System.arraycopy(this.buffer, this.buffer_offset, this.buffer, 0, this.buffer_size);
        }
        this.buffer_offset = 0;
        int readSize = 4096 - this.buffer_size;
        long remainSize = this._getLength() - this.offset;
        if (remainSize < (long)readSize) {
            readSize = (int)remainSize;
        }
        while (readSize > 0) {
            int size = this.read(this.offset + (long)this.buffer_size, this.buffer, this.buffer_size, readSize);
            if (size < 0) break;
            this.buffer_size += size;
            readSize -= size;
            if (this.buffer_size >= minSize) break;
        }
    }
}

