/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.logviewer.dialogs;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.log.ColumnFilter;
import org.netxms.client.log.Log;
import org.netxms.client.log.LogColumn;
import org.netxms.client.log.LogFilter;
import org.netxms.client.log.OrderingColumn;
import org.netxms.ui.eclipse.logviewer.Activator;
import org.netxms.ui.eclipse.logviewer.dialogs.AddConditionDialog;
import org.netxms.ui.eclipse.logviewer.dialogs.ColumnSelectionDialog;
import org.netxms.ui.eclipse.logviewer.dialogs.helpers.FilterTreeContentProvider;
import org.netxms.ui.eclipse.logviewer.dialogs.helpers.FilterTreeElement;
import org.netxms.ui.eclipse.logviewer.dialogs.helpers.FilterTreeLabelProvider;
import org.netxms.ui.eclipse.logviewer.dialogs.helpers.OrderingColumnEditingSupport;
import org.netxms.ui.eclipse.logviewer.dialogs.helpers.OrderingListLabelProvider;

public class QueryBuilder
extends Dialog {
    private Log logHandle;
    private LogFilter filter;
    private TreeViewer filterTree;
    private ArrayList<FilterTreeElement> elements;
    private FilterTreeElement rootElement;
    private Button buttonAddColumn;
    private Button buttonAddAndSet;
    private Button buttonAddOrSet;
    private Button buttonAddOperation;
    private Button buttonRemove;
    private HashSet<OrderingColumn> orderingColumns;
    private TableViewer orderingList;
    private Button buttonAddOrderingColumn;
    private Button buttonMoveUp;
    private Button buttonMoveDown;
    private Button buttonRemoveOrderingColumn;
    private Action actionAddColumn;
    private Action actionAddCondition;
    private Action actionAddAndGroup;
    private Action actionAddOrGroup;
    private Action actionRemoveColumn;
    private Action actionRemoveOrderingColumn;

    public QueryBuilder(Shell parentShell, Log logHandle, LogFilter filter) {
        super(parentShell);
        this.logHandle = logHandle;
        this.filter = filter;
        this.createInternalTree(filter);
        List originalColumns = filter.getOrderingColumns();
        this.orderingColumns = new HashSet(originalColumns.size());
        for (OrderingColumn c : originalColumns) {
            this.orderingColumns.add(new OrderingColumn(c));
        }
    }

    private void createInternalTree(LogFilter filter) {
        this.elements = new ArrayList();
        this.rootElement = new FilterTreeElement(0, null, null);
        this.elements.add(this.rootElement);
        Set columnFilters = filter.getColumnFilters();
        for (Map.Entry cf : columnFilters) {
            LogColumn lc = this.logHandle.getColumn((String)cf.getKey());
            if (lc == null) continue;
            FilterTreeElement column = new FilterTreeElement(1, lc, this.rootElement);
            this.addColumnFilter(column, (ColumnFilter)cf.getValue());
        }
    }

    private void addColumnFilter(FilterTreeElement parent, ColumnFilter filter) {
        FilterTreeElement entry = new FilterTreeElement(2, filter, parent);
        if (filter.getType() == 2) {
            for (ColumnFilter f : filter.getSubFilters()) {
                this.addColumnFilter(entry, f);
            }
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        dialogArea.setLayout((Layout)layout);
        Composite filterTreeArea = this.createFilterTree(dialogArea);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        filterTreeArea.setLayoutData((Object)gd);
        Composite orderingListArea = this.createOrderingList(dialogArea);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        orderingListArea.setLayoutData((Object)gd);
        this.createActions();
        return dialogArea;
    }

    private void createActions() {
        this.actionAddColumn = new Action(){

            public void run() {
                QueryBuilder.this.addColumn();
            }
        };
        this.actionAddColumn.setText("Add &column");
        this.actionAddAndGroup = new Action(){

            public void run() {
                QueryBuilder.this.addFilterSet(0);
            }
        };
        this.actionAddAndGroup.setText("Add &AND filter set");
        this.actionAddOrGroup = new Action(){

            public void run() {
                QueryBuilder.this.addFilterSet(1);
            }
        };
        this.actionAddOrGroup.setText("Add &OR filter set");
        this.actionAddCondition = new Action(){

            public void run() {
                QueryBuilder.this.addCondition();
            }
        };
        this.actionAddCondition.setText("Add co&ndition");
        this.actionRemoveColumn = new Action(){

            public void run() {
                QueryBuilder.this.removeFilterTreeElement();
            }
        };
        this.actionRemoveColumn.setText("&Remove");
        this.actionRemoveColumn.setImageDescriptor(Activator.getImageDescriptor("icons/remove.png"));
        this.actionRemoveOrderingColumn = new Action(){

            public void run() {
                QueryBuilder.this.removeOrderingColumn();
            }
        };
        this.actionRemoveOrderingColumn.setText("&Remove");
        this.actionRemoveOrderingColumn.setImageDescriptor(Activator.getImageDescriptor("icons/remove.png"));
    }

    private Composite createFilterTree(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Filter");
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        this.filterTree = new TreeViewer((Composite)group, 2052);
        this.filterTree.setContentProvider((IContentProvider)new FilterTreeContentProvider());
        this.filterTree.setLabelProvider((IBaseLabelProvider)new FilterTreeLabelProvider());
        ArrayList<FilterTreeElement> input = new ArrayList<FilterTreeElement>(1);
        input.add(this.rootElement);
        this.filterTree.setInput(input);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 400;
        gd.heightHint = 300;
        this.filterTree.getControl().setLayoutData((Object)gd);
        Composite buttons = new Composite((Composite)group, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 512;
        buttonLayout.fill = true;
        buttonLayout.pack = false;
        buttonLayout.marginTop = 0;
        buttonLayout.spacing = 4;
        buttons.setLayout((Layout)buttonLayout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 128;
        buttons.setLayoutData((Object)gd);
        this.buttonAddColumn = new Button(buttons, 8);
        this.buttonAddColumn.setText("Add &column");
        this.buttonAddColumn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                QueryBuilder.this.addColumn();
            }
        });
        RowData rd = new RowData();
        rd.width = 120;
        this.buttonAddColumn.setLayoutData((Object)rd);
        this.buttonAddAndSet = new Button(buttons, 8);
        this.buttonAddAndSet.setText("Add &AND group");
        this.buttonAddAndSet.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                QueryBuilder.this.addFilterSet(0);
            }
        });
        this.buttonAddOrSet = new Button(buttons, 8);
        this.buttonAddOrSet.setText("Add &OR group");
        this.buttonAddOrSet.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                QueryBuilder.this.addFilterSet(1);
            }
        });
        this.buttonAddOperation = new Button(buttons, 8);
        this.buttonAddOperation.setText("Add co&ndition");
        this.buttonAddOperation.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                QueryBuilder.this.addCondition();
            }
        });
        this.buttonRemove = new Button(buttons, 8);
        this.buttonRemove.setText("&Remove");
        this.buttonRemove.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                QueryBuilder.this.removeFilterTreeElement();
            }
        });
        this.createFilterPopupMenu();
        return group;
    }

    private void createFilterPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                QueryBuilder.this.fillFilterContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.filterTree.getControl());
        this.filterTree.getControl().setMenu(menu);
    }

    private void fillFilterContextMenu(IMenuManager mgr) {
        IStructuredSelection selection = (IStructuredSelection)this.filterTree.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        FilterTreeElement element = (FilterTreeElement)selection.getFirstElement();
        switch (element.getType()) {
            case 0: {
                mgr.add((IAction)this.actionAddColumn);
                break;
            }
            case 1: {
                mgr.add((IAction)this.actionAddAndGroup);
                mgr.add((IAction)this.actionAddOrGroup);
                mgr.add((IAction)this.actionAddCondition);
                mgr.add((IContributionItem)new Separator());
                mgr.add((IAction)this.actionRemoveColumn);
                break;
            }
            case 2: {
                ColumnFilter cf = (ColumnFilter)element.getObject();
                if (cf.getType() == 2) {
                    mgr.add((IAction)this.actionAddAndGroup);
                    mgr.add((IAction)this.actionAddOrGroup);
                    mgr.add((IAction)this.actionAddCondition);
                    mgr.add((IContributionItem)new Separator());
                }
                mgr.add((IAction)this.actionRemoveColumn);
            }
        }
    }

    private Composite createOrderingList(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Sorting");
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        this.orderingList = new TableViewer((Composite)group, 68354);
        TableViewerColumn column = new TableViewerColumn(this.orderingList, 16384);
        column.getColumn().setText("Column");
        column.getColumn().setWidth(200);
        column = new TableViewerColumn(this.orderingList, 16384);
        column.getColumn().setText("Descending");
        column.getColumn().setWidth(60);
        column.setEditingSupport((EditingSupport)new OrderingColumnEditingSupport((ColumnViewer)this.orderingList));
        this.orderingList.getTable().setLinesVisible(true);
        this.orderingList.getTable().setHeaderVisible(true);
        this.orderingList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.orderingList.setLabelProvider((IBaseLabelProvider)new OrderingListLabelProvider());
        this.orderingList.setInput((Object)this.orderingColumns.toArray());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.heightHint = 100;
        this.orderingList.getControl().setLayoutData((Object)gd);
        this.orderingList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                QueryBuilder.this.buttonRemoveOrderingColumn.setEnabled(!event.getSelection().isEmpty());
            }
        });
        Composite buttons = new Composite((Composite)group, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 512;
        buttonLayout.fill = true;
        buttonLayout.pack = false;
        buttonLayout.marginTop = 0;
        buttonLayout.spacing = 4;
        buttons.setLayout((Layout)buttonLayout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 128;
        buttons.setLayoutData((Object)gd);
        this.buttonAddOrderingColumn = new Button(buttons, 8);
        this.buttonAddOrderingColumn.setText("&Add column");
        this.buttonAddOrderingColumn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                QueryBuilder.this.addOrderingColumn();
            }
        });
        RowData rd = new RowData();
        rd.width = 120;
        this.buttonAddOrderingColumn.setLayoutData((Object)rd);
        this.buttonRemoveOrderingColumn = new Button(buttons, 8);
        this.buttonRemoveOrderingColumn.setText("R&emove");
        this.buttonRemoveOrderingColumn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                QueryBuilder.this.removeOrderingColumn();
            }
        });
        this.buttonRemoveOrderingColumn.setEnabled(false);
        this.createOrderingPopupMenu();
        return group;
    }

    private void createOrderingPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                QueryBuilder.this.fillOrderingContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.orderingList.getControl());
        this.orderingList.getControl().setMenu(menu);
    }

    private void fillOrderingContextMenu(IMenuManager mgr) {
        IStructuredSelection selection = (IStructuredSelection)this.orderingList.getSelection();
        if (!selection.isEmpty()) {
            mgr.add((IAction)this.actionRemoveOrderingColumn);
        }
    }

    private void addColumn() {
        ColumnSelectionDialog dlg = new ColumnSelectionDialog(this.getShell(), this.logHandle);
        if (dlg.open() == 0) {
            for (FilterTreeElement e : this.elements) {
                if (e.getType() != 1 || !((LogColumn)e.getObject()).getName().equals(dlg.getSelectedColumn().getName())) continue;
                this.filterTree.setSelection((ISelection)new StructuredSelection((Object)e), true);
                return;
            }
            FilterTreeElement column = new FilterTreeElement(1, dlg.getSelectedColumn(), this.rootElement);
            this.elements.add(column);
            this.filterTree.refresh();
            this.filterTree.setSelection((ISelection)new StructuredSelection((Object)column), true);
        }
    }

    private void addFilterSet(int operation) {
        FilterTreeElement newElement;
        IStructuredSelection selection = (IStructuredSelection)this.filterTree.getSelection();
        FilterTreeElement element = (FilterTreeElement)selection.getFirstElement();
        if (selection.isEmpty() || element.getType() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Warning", (String)"Please select column or filter set");
            return;
        }
        ColumnFilter cf = new ColumnFilter();
        cf.setOperation(operation);
        if (element.getType() == 1) {
            FilterTreeElement[] childs = element.getChilds();
            newElement = new FilterTreeElement(2, cf, element);
            int i = 0;
            while (i < childs.length) {
                childs[i].changeParent(newElement);
                ++i;
            }
        } else {
            ColumnFilter currFilter = (ColumnFilter)element.getObject();
            if (currFilter.getType() == 2) {
                newElement = new FilterTreeElement(2, cf, element);
            } else {
                newElement = new FilterTreeElement(2, cf, element.getParent());
                element.changeParent(newElement);
            }
        }
        this.elements.add(newElement);
        this.filterTree.refresh();
        this.filterTree.setSelection((ISelection)new StructuredSelection((Object)newElement), true);
    }

    private void addCondition() {
        IStructuredSelection selection = (IStructuredSelection)this.filterTree.getSelection();
        FilterTreeElement element = (FilterTreeElement)selection.getFirstElement();
        if (selection.isEmpty() || element.getType() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Warning", (String)"Please select column or filter set");
            return;
        }
        if (element.getType() == 1) {
            if (element.hasChilds()) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)"Warning", (String)"Please select column without conditions or condition set to add new condition");
                return;
            }
        } else if (((ColumnFilter)element.getObject()).getType() != 2) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Warning", (String)"Please select column without conditions or condition set to add new condition");
            return;
        }
        FilterTreeElement p = element;
        while (p.getType() != 1) {
            p = p.getParent();
        }
        LogColumn logColumn = (LogColumn)p.getObject();
        AddConditionDialog dlg = new AddConditionDialog(this.getShell(), logColumn);
        if (dlg.open() == 0) {
            FilterTreeElement condition = new FilterTreeElement(2, dlg.getFilter(), element);
            this.elements.add(condition);
            this.filterTree.refresh();
            this.filterTree.setSelection((ISelection)new StructuredSelection((Object)condition), true);
        }
    }

    private void removeFilterTreeElement() {
        IStructuredSelection selection = (IStructuredSelection)this.filterTree.getSelection();
        FilterTreeElement element = (FilterTreeElement)selection.getFirstElement();
        if (selection.isEmpty() || element.getType() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Warning", (String)"Only columns and filters can be deleted");
            return;
        }
        FilterTreeElement parent = element.getParent();
        parent.removeChild(element);
        this.filterTree.refresh();
    }

    public LogFilter getFilter() {
        return this.filter;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Log Query Builder");
    }

    protected void okPressed() {
        this.generateFilter();
        super.okPressed();
    }

    private void generateFilter() {
        this.optimizeTree(this.rootElement);
        this.filter = new LogFilter();
        FilterTreeElement[] columns = this.rootElement.getChilds();
        int i = 0;
        while (i < columns.length) {
            ColumnFilter cf = this.buildColumnFilter(columns[i].getChilds()[0]);
            this.filter.setColumnFilter(((LogColumn)columns[i].getObject()).getName(), cf);
            ++i;
        }
        this.filter.setOrderingColumns(new ArrayList<OrderingColumn>(this.orderingColumns));
    }

    private ColumnFilter buildColumnFilter(FilterTreeElement element) {
        ColumnFilter cf = (ColumnFilter)element.getObject();
        if (cf.getType() != 2) {
            return cf;
        }
        ColumnFilter filterSet = new ColumnFilter();
        filterSet.setOperation(cf.getOperation());
        FilterTreeElement[] childs = element.getChilds();
        int i = 0;
        while (i < childs.length) {
            filterSet.addSubFilter(this.buildColumnFilter(childs[i]));
            ++i;
        }
        return filterSet;
    }

    private void optimizeTree(FilterTreeElement root) {
        FilterTreeElement[] childs = root.getChilds();
        int i = 0;
        while (i < childs.length) {
            this.optimizeTree(childs[i]);
            if (!childs[i].hasChilds()) {
                if (childs[i].getType() == 2) {
                    if (((ColumnFilter)childs[i].getObject()).getType() == 2) {
                        root.removeChild(childs[i]);
                    }
                } else {
                    root.removeChild(childs[i]);
                }
            } else if (childs[i].getNumChilds() == 1 && childs[i].getType() == 2 && ((ColumnFilter)childs[i].getObject()).getType() == 2) {
                FilterTreeElement subFilter = childs[i].getChilds()[0];
                root.removeChild(childs[i]);
                subFilter.changeParent(root);
            }
            ++i;
        }
    }

    private void addOrderingColumn() {
        ColumnSelectionDialog dlg = new ColumnSelectionDialog(this.getShell(), this.logHandle);
        if (dlg.open() == 0) {
            OrderingColumn column = new OrderingColumn(dlg.getSelectedColumn());
            if (!this.orderingColumns.contains(column)) {
                this.orderingColumns.add(column);
                this.orderingList.setInput((Object)this.orderingColumns.toArray());
            } else {
                this.orderingList.setSelection((ISelection)new StructuredSelection((Object)column));
            }
        }
    }

    private void removeOrderingColumn() {
        IStructuredSelection selection = (IStructuredSelection)this.orderingList.getSelection();
        if (!selection.isEmpty()) {
            Iterator it = selection.iterator();
            while (it.hasNext()) {
                this.orderingColumns.remove(it.next());
            }
            this.orderingList.setInput((Object)this.orderingColumns.toArray());
        }
    }
}

