/*
 * Decompiled with CFR 0.152.
 */
package org.swtchart.internal.axis;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Display;
import org.swtchart.Chart;
import org.swtchart.IAxis;
import org.swtchart.internal.ChartLayoutData;
import org.swtchart.internal.Util;
import org.swtchart.internal.axis.Axis;

public class AxisTickLabels
implements PaintListener {
    private Chart chart;
    private Axis axis;
    private Color foreground;
    private int widthHint;
    private int heightHint;
    private Rectangle bounds;
    private ArrayList<Double> tickLabelValues;
    private ArrayList<String> tickLabels;
    private ArrayList<Integer> tickLabelPositions;
    private ArrayList<Boolean> tickVisibilities;
    private int tickLabelMaxLength;
    private Format format;
    private static final int DEFAULT_FOREGROUND = 9;
    private static final Font DEFAULT_FONT = Display.getDefault().getSystemFont();
    private static final String DEFAULT_DECIMAL_FORMAT = "#.###########";
    private Map<Integer, Integer[]> possibleTickSteps;
    private int timeUnit;
    private Font font;

    protected AxisTickLabels(Chart chart, Axis axis) {
        this.chart = chart;
        this.axis = axis;
        this.tickLabelValues = new ArrayList();
        this.tickLabels = new ArrayList();
        this.tickLabelPositions = new ArrayList();
        this.tickVisibilities = new ArrayList();
        this.initializePossibleTickSteps();
        this.font = DEFAULT_FONT;
        this.foreground = Display.getDefault().getSystemColor(9);
        chart.addPaintListener(this);
    }

    private void initializePossibleTickSteps() {
        Integer[] milliseconds = new Integer[]{1, 2, 5, 10, 20, 50, 100, 200, 500, 999};
        Integer[] seconds = new Integer[]{1, 2, 5, 10, 15, 20, 30, 59};
        Integer[] minutes = new Integer[]{1, 2, 3, 5, 10, 15, 20, 30, 59};
        Integer[] hours = new Integer[]{1, 2, 3, 4, 6, 12, 22};
        Integer[] dates = new Integer[]{1, 7, 14, 28};
        Integer[] months = new Integer[]{1, 2, 3, 4, 6, 11};
        Integer[] years = new Integer[]{1, 2, 5, 10, 20, 50, 100, 200, 500, 1000};
        this.possibleTickSteps = new HashMap<Integer, Integer[]>();
        this.possibleTickSteps.put(14, milliseconds);
        this.possibleTickSteps.put(13, seconds);
        this.possibleTickSteps.put(12, minutes);
        this.possibleTickSteps.put(11, hours);
        this.possibleTickSteps.put(5, dates);
        this.possibleTickSteps.put(2, months);
        this.possibleTickSteps.put(1, years);
    }

    public void setForeground(Color color) {
        this.foreground = color == null ? Display.getDefault().getSystemColor(9) : color;
    }

    protected Color getForeground() {
        if (this.foreground.isDisposed()) {
            this.foreground = Display.getDefault().getSystemColor(9);
        }
        return this.foreground;
    }

    protected void update(int length) {
        this.tickLabelValues.clear();
        this.tickLabels.clear();
        this.tickLabelPositions.clear();
        if (this.axis.isValidCategoryAxis()) {
            this.updateTickLabelForCategoryAxis(length);
        } else if (this.axis.isLogScaleEnabled()) {
            this.updateTickLabelForLogScale(length);
        } else if (this.axis.isDateEnabled()) {
            this.updateTickLabelForDateAxis(length);
        } else {
            this.updateTickLabelForLinearScale(length);
        }
        this.updateTickVisibility();
        this.updateTickLabelMaxLength();
    }

    private void updateTickLabelForDateAxis(int length) {
        double min = this.axis.getRange().lower;
        double max = this.axis.getRange().upper;
        double gridStepHint = Math.abs(max - min) / (double)length * (double)this.axis.getTick().getTickMarkStepHint();
        this.timeUnit = this.getTimeUnit(gridStepHint);
        if (this.timeUnit == 14 || this.timeUnit == 13 || this.timeUnit == 12 || this.timeUnit == 11 || this.timeUnit == 5) {
            Integer[] steps = this.possibleTickSteps.get(this.timeUnit);
            int i = 0;
            while (i < steps.length - 1) {
                if (gridStepHint < (double)(this.getPeriodInMillis(this.timeUnit, steps[i]) + this.getPeriodInMillis(this.timeUnit, steps[i + 1])) / 2.0) {
                    BigDecimal gridStep = new BigDecimal(Long.valueOf(this.getPeriodInMillis(this.timeUnit, steps[i])).toString());
                    this.updateTickLabelForLinearScale(length, gridStep);
                    break;
                }
                ++i;
            }
        } else if (this.timeUnit == 2 || this.timeUnit == 1) {
            this.updateTickLabelForMonthOrYear(length, gridStepHint, this.timeUnit);
        }
    }

    private void updateTickLabelForMonthOrYear(int length, double gridStepHint, int tickStepUnit) {
        double min = this.axis.getRange().lower;
        double max = this.axis.getRange().upper;
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date((long)min));
        int month = cal.get(2);
        int year = cal.get(1);
        if (tickStepUnit == 2) {
            if (month == 11) {
                ++year;
                month = 0;
            } else {
                ++month;
            }
        } else if (tickStepUnit == 1) {
            month = 0;
            ++year;
        }
        Integer[] steps = this.possibleTickSteps.get(tickStepUnit);
        int step = steps[steps.length - 1];
        int i = 0;
        while (i < steps.length - 1) {
            if (gridStepHint < (double)(this.getPeriodInMillis(tickStepUnit, steps[i]) + this.getPeriodInMillis(tickStepUnit, steps[i + 1])) / 2.0) {
                step = steps[i];
                break;
            }
            ++i;
        }
        cal.clear();
        cal.set(year, month, 1);
        while ((double)cal.getTimeInMillis() < max) {
            this.tickLabelValues.add(Double.valueOf(cal.getTimeInMillis()));
            this.tickLabels.add(this.format(cal.getTimeInMillis()));
            int tickLabelPosition = (int)(((double)cal.getTimeInMillis() - min) / (max - min) * (double)length);
            this.tickLabelPositions.add(tickLabelPosition);
            if (tickStepUnit == 2) {
                if ((month += step) + step > 11) {
                    ++year;
                    month -= 12;
                }
            } else if (tickStepUnit == 1) {
                year += step;
            }
            cal.clear();
            cal.set(year, month, 1);
        }
    }

    private void updateTickLabelForCategoryAxis(int length) {
        String[] series = this.axis.getCategorySeries();
        if (series == null) {
            return;
        }
        int max = (int)this.axis.getRange().upper;
        int min = (int)this.axis.getRange().lower;
        int sizeOfTickLabels = series.length < max - min + 1 ? series.length : max - min + 1;
        int initialIndex = min < 0 ? 0 : min;
        int i = 0;
        while (i < sizeOfTickLabels) {
            this.tickLabels.add(series[i + initialIndex]);
            int tickLabelPosition = (int)((double)length * ((double)i + 0.5) / (double)sizeOfTickLabels);
            this.tickLabelPositions.add(tickLabelPosition);
            ++i;
        }
    }

    private void updateTickLabelForLogScale(int length) {
        BigDecimal tickStep;
        double min = this.axis.getRange().lower;
        double max = this.axis.getRange().upper;
        int digitMin = (int)Math.ceil(Math.log10(min));
        int digitMax = (int)Math.ceil(Math.log10(max));
        BigDecimal MIN = new BigDecimal(new Double(min).toString());
        BigDecimal firstPosition = MIN.remainder(tickStep = this.pow(10.0, digitMin - 1)).doubleValue() <= 0.0 ? MIN.subtract(MIN.remainder(tickStep)) : MIN.subtract(MIN.remainder(tickStep)).add(tickStep);
        int i = digitMin;
        while (i <= digitMax) {
            BigDecimal j = firstPosition;
            while (j.doubleValue() <= this.pow(10.0, i).doubleValue()) {
                if (j.doubleValue() > max) break;
                if (this.axis.isDateEnabled()) {
                    Date date = new Date((long)j.doubleValue());
                    this.tickLabels.add(this.format(date));
                } else {
                    this.tickLabels.add(this.format(j.doubleValue()));
                }
                this.tickLabelValues.add(j.doubleValue());
                int tickLabelPosition = (int)((Math.log10(j.doubleValue()) - Math.log10(min)) / (Math.log10(max) - Math.log10(min)) * (double)length);
                this.tickLabelPositions.add(tickLabelPosition);
                j = j.add(tickStep);
            }
            tickStep = tickStep.multiply(this.pow(10.0, 1));
            firstPosition = tickStep.add(this.pow(10.0, i));
            ++i;
        }
    }

    private void updateTickLabelForLinearScale(int length) {
        double min = this.axis.getRange().lower;
        double max = this.axis.getRange().upper;
        this.updateTickLabelForLinearScale(length, this.getGridStep(length, min, max));
    }

    private void updateTickLabelForLinearScale(int length, BigDecimal tickStep) {
        BigDecimal zeroOclock;
        double min = this.axis.getRange().lower;
        double max = this.axis.getRange().upper;
        BigDecimal MIN = new BigDecimal(new Double(min).toString());
        BigDecimal firstPosition = MIN.remainder(tickStep).doubleValue() <= 0.0 ? MIN.subtract(MIN.remainder(tickStep)) : MIN.subtract(MIN.remainder(tickStep)).add(tickStep);
        if (this.axis.isDateEnabled() && MIN.compareTo(zeroOclock = firstPosition.subtract(new BigDecimal(new Double(3600000.0).toString()))) == -1) {
            firstPosition = zeroOclock;
        }
        BigDecimal b = firstPosition;
        while (b.doubleValue() <= max) {
            if (this.axis.isDateEnabled()) {
                Date date = new Date((long)b.doubleValue());
                this.tickLabels.add(this.format(date));
            } else {
                this.tickLabels.add(this.format(b.doubleValue()));
            }
            this.tickLabelValues.add(b.doubleValue());
            int tickLabelPosition = (int)((b.doubleValue() - min) / (max - min) * (double)length);
            this.tickLabelPositions.add(tickLabelPosition);
            b = b.add(tickStep);
        }
    }

    private void updateTickVisibility() {
        this.tickVisibilities.clear();
        int i = 0;
        while (i < this.tickLabelPositions.size()) {
            this.tickVisibilities.add(Boolean.TRUE);
            ++i;
        }
        if (this.tickLabelPositions.size() == 0 || this.axis.getTick().getTickLabelAngle() != 0) {
            return;
        }
        int previousPosition = 0;
        int i2 = 0;
        while (i2 < this.tickLabelPositions.size()) {
            boolean hasSpaceToDraw = true;
            if (i2 != 0) {
                hasSpaceToDraw = this.hasSpaceToDraw(previousPosition, this.tickLabelPositions.get(i2), this.tickLabels.get(i2));
            }
            boolean isMajorTick = true;
            if (!this.axis.isValidCategoryAxis()) {
                if (this.axis.isLogScaleEnabled()) {
                    isMajorTick = this.isMajorTick(this.tickLabelValues.get(i2));
                }
                String currentLabel = this.tickLabels.get(i2);
                try {
                    double value = Double.parseDouble(currentLabel);
                    if (value != this.tickLabelValues.get(i2)) {
                        isMajorTick = false;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (hasSpaceToDraw && isMajorTick) {
                previousPosition = this.tickLabelPositions.get(i2);
            } else {
                this.tickVisibilities.set(i2, Boolean.FALSE);
            }
            ++i2;
        }
    }

    private int getTimeUnit(double gridStepHint) {
        Integer[] units;
        Integer[] integerArray = units = new Integer[]{14, 13, 12, 11, 5, 2, 1};
        int n = units.length;
        int n2 = 0;
        while (n2 < n) {
            Integer unit = integerArray[n2];
            Integer[] steps = this.possibleTickSteps.get(unit);
            if (gridStepHint < (double)(this.getPeriodInMillis(unit, steps[steps.length - 2]) + this.getPeriodInMillis(unit, steps[steps.length - 1])) / 2.0) {
                return unit;
            }
            ++n2;
        }
        return 1;
    }

    private long getPeriodInMillis(int unit, int amount) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(0L);
        cal.roll(unit, amount);
        return cal.getTimeInMillis();
    }

    private String format(Object obj) {
        if (this.format == null) {
            if (this.axis.isDateEnabled()) {
                String dateFormat = "yyyyy.MMMMM.dd";
                if (this.timeUnit == 14) {
                    dateFormat = "HH:mm:ss.SSS";
                } else if (this.timeUnit == 13) {
                    dateFormat = "HH:mm:ss";
                } else if (this.timeUnit == 12) {
                    dateFormat = "HH:mm";
                } else if (this.timeUnit == 11) {
                    dateFormat = "dd HH:mm";
                } else if (this.timeUnit == 5) {
                    dateFormat = "MMMMM d";
                } else if (this.timeUnit == 2) {
                    dateFormat = "yyyy MMMMM";
                } else if (this.timeUnit == 1) {
                    dateFormat = "yyyy";
                }
                return new SimpleDateFormat(dateFormat).format(obj);
            }
            return new DecimalFormat(DEFAULT_DECIMAL_FORMAT).format(obj);
        }
        return this.format.format(obj);
    }

    private boolean isMajorTick(double tickValue) {
        if (!this.axis.isLogScaleEnabled()) {
            return true;
        }
        return Math.log10(tickValue) % 1.0 == 0.0;
    }

    private boolean hasSpaceToDraw(int previousPosition, int tickLabelPosition, String tickLabel) {
        int textLength;
        Point p = Util.getExtentInGC(this.axis.getTick().getFont(), tickLabel);
        int interval = tickLabelPosition - previousPosition;
        int n = textLength = this.axis.isHorizontalAxis() ? p.x : p.y;
        return interval > textLength;
    }

    private void updateTickLabelMaxLength() {
        int maxLength = 0;
        int i = 0;
        while (i < this.tickLabels.size()) {
            if (this.tickVisibilities.size() > i && this.tickVisibilities.get(i).booleanValue()) {
                Point p = Util.getExtentInGC(this.axis.getTick().getFont(), this.tickLabels.get(i));
                if (p.x > maxLength) {
                    maxLength = p.x;
                }
            }
            ++i;
        }
        if (this.tickLabelMaxLength != maxLength) {
            this.tickLabelMaxLength = maxLength;
            if (this.axis.getTick().getTickLabelAngle() != 0) {
                this.chart.updateLayout();
            }
        }
    }

    private BigDecimal pow(double base, int expornent) {
        BigDecimal value = expornent > 0 ? new BigDecimal(new Double(base).toString()).pow(expornent) : BigDecimal.ONE.divide(new BigDecimal(new Double(base).toString()).pow(-expornent));
        return value;
    }

    /*
     * Unable to fully structure code
     */
    private BigDecimal getGridStep(int lengthInPixels, double min, double max) {
        block4: {
            if (lengthInPixels <= 0) {
                throw new IllegalArgumentException("lengthInPixels must be positive value.");
            }
            if (min >= max) {
                throw new IllegalArgumentException("min must be less than max.");
            }
            length = Math.abs(max - min);
            mantissa = gridStepHint = length / (double)lengthInPixels * (double)this.axis.getTick().getTickMarkStepHint();
            exponent = 0;
            if (!(mantissa < 1.0)) ** GOTO lbl16
            while (mantissa < 1.0) {
                mantissa *= 10.0;
                --exponent;
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                mantissa /= 10.0;
                ++exponent;
lbl16:
                // 2 sources

                ** while (mantissa >= 10.0)
            }
        }
        gridStep = mantissa > 7.5 ? BigDecimal.TEN.multiply(this.pow(10.0, exponent)) : (mantissa > 3.5 ? new BigDecimal(new Double(5.0).toString()).multiply(this.pow(10.0, exponent)) : (mantissa > 1.5 ? new BigDecimal(new Double(2.0).toString()).multiply(this.pow(10.0, exponent)) : this.pow(10.0, exponent)));
        return gridStep;
    }

    public ArrayList<Integer> getTickLabelPositions() {
        return this.tickLabelPositions;
    }

    protected ArrayList<Double> getTickLabelValues() {
        return this.tickLabelValues;
    }

    protected void setFont(Font font) {
        this.font = font == null ? DEFAULT_FONT : font;
    }

    protected Font getFont() {
        if (this.font.isDisposed()) {
            this.font = DEFAULT_FONT;
        }
        return this.font;
    }

    public ChartLayoutData getLayoutData() {
        return new ChartLayoutData(this.widthHint, this.heightHint);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.bounds = new Rectangle(x, y, width, height);
    }

    protected Rectangle getBounds() {
        return this.bounds;
    }

    protected void dispose() {
        if (!this.chart.isDisposed()) {
            this.chart.removePaintListener(this);
        }
    }

    protected void updateLayoutData() {
        this.widthHint = -1;
        this.heightHint = -1;
        if (!this.axis.getTick().isVisible()) {
            this.widthHint = 0;
            this.heightHint = 0;
        } else if (this.axis.isHorizontalAxis()) {
            double angle = this.axis.getTick().getTickLabelAngle();
            this.heightHint = 5 + (int)((double)this.tickLabelMaxLength * Math.sin(Math.toRadians(angle)) + (double)Util.getExtentInGC((Font)this.getFont(), (String)"dummy").y * Math.cos(Math.toRadians(angle)));
        } else {
            this.widthHint = this.tickLabelMaxLength + 5;
        }
    }

    public void paintControl(PaintEvent e) {
        if (!this.axis.getTick().isVisible()) {
            return;
        }
        e.gc.setBackground(this.chart.getBackground());
        e.gc.setForeground(this.getForeground());
        if (this.axis.isHorizontalAxis()) {
            this.drawXTick(e.gc);
        } else {
            this.drawYTick(e.gc);
        }
    }

    private void drawXTick(GC gc) {
        int offset = this.axis.getTick().getAxisTickMarks().getBounds().x;
        gc.setFont(this.axis.getTick().getFont());
        int angle = this.axis.getTick().getTickLabelAngle();
        int i = 0;
        while (i < this.tickLabelPositions.size()) {
            if (this.axis.isValidCategoryAxis() || this.tickVisibilities.get(i).booleanValue()) {
                String text = this.tickLabels.get(i);
                int textWidth = gc.textExtent((String)text).x;
                int textHeight = gc.textExtent((String)text).y;
                if (angle == 0) {
                    int x = (int)((double)this.tickLabelPositions.get(i).intValue() - (double)textWidth / 2.0 + (double)offset);
                    gc.drawText(text, this.bounds.x + x, this.bounds.y);
                } else {
                    float y;
                    float x;
                    if (this.axis.getPosition() == IAxis.Position.Primary) {
                        x = (float)((double)(offset + this.bounds.x + this.tickLabelPositions.get(i)) - (double)textWidth * Math.cos(Math.toRadians(angle)) - (double)textHeight / 2.0 * Math.sin(Math.toRadians(angle)));
                        y = (float)((double)this.bounds.y + (double)textWidth * Math.sin(Math.toRadians(angle)));
                    } else {
                        x = (float)((double)(offset + this.bounds.x + this.tickLabelPositions.get(i)) - (double)textHeight / 2.0 * Math.sin(Math.toRadians(angle)));
                        y = (float)((double)this.bounds.y + (double)this.tickLabelMaxLength * Math.sin(Math.toRadians(angle)));
                    }
                    this.drawRotatedText(gc, text, x, y, angle);
                }
            }
            ++i;
        }
    }

    private void drawRotatedText(GC gc, String text, float x, float y, int angle) {
        int textWidth = gc.textExtent((String)text).x;
        int textHeight = gc.textExtent((String)text).y;
        Image image = new Image((Device)Display.getCurrent(), textWidth, textHeight);
        GC tmpGc = new GC((Drawable)image);
        tmpGc.setForeground(this.getForeground());
        tmpGc.setBackground(gc.getBackground());
        tmpGc.setFont(this.getFont());
        tmpGc.drawText(text, 0, 0);
        Transform transform = new Transform(gc.getDevice());
        transform.translate(x, y);
        transform.rotate((float)(360 - angle));
        gc.setTransform(transform);
        gc.drawImage(image, 0, 0);
        tmpGc.dispose();
        transform.dispose();
        image.dispose();
        gc.setTransform(null);
    }

    private void drawYTick(GC gc) {
        int margin = 10;
        gc.setFont(this.axis.getTick().getFont());
        int figureHeight = gc.textExtent((String)"dummy").y;
        int i = 0;
        while (i < this.tickLabelPositions.size()) {
            if (this.tickVisibilities.size() == 0 || this.tickLabels.size() == 0) break;
            if (this.tickVisibilities.get(i).booleanValue()) {
                String text = this.tickLabels.get(i);
                int x = 0;
                if (this.tickLabels.get(0).startsWith("-") && !text.startsWith("-")) {
                    x += gc.textExtent((String)"-").x;
                }
                int y = (int)((double)(this.bounds.height - 1 - this.tickLabelPositions.get(i)) - (double)figureHeight / 2.0 - (double)margin);
                gc.drawText(text, this.bounds.x + x, this.bounds.y + y);
            }
            ++i;
        }
    }

    protected void setFormat(Format format) {
        this.format = format;
    }

    protected Format getFormat() {
        return this.format;
    }
}

