/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.slm.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.objects.Node;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class CreateNodeLinkDialog
extends Dialog {
    private LabeledText nameField;
    private ObjectSelector nodeField;
    private String name;
    private long nodeId;

    public CreateNodeLinkDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Create Node Link Object");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        dialogArea.setLayout((Layout)layout);
        this.nameField = new LabeledText(dialogArea, 0);
        this.nameField.setLabel("Name (leave empty to use node's name)");
        this.nameField.getTextControl().setTextLimit(255);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 300;
        this.nameField.setLayoutData((Object)gd);
        this.nodeField = new ObjectSelector(dialogArea, 0);
        this.nodeField.setLabel("Node");
        this.nodeField.setObjectClass(Node.class);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.nodeField.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void okPressed() {
        this.nodeId = this.nodeField.getObjectId();
        if (this.nodeId == 0L) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Warning", (String)"Please select node object to link");
            return;
        }
        this.name = this.nameField.getText().trim();
        if (this.name.isEmpty()) {
            this.name = this.nodeField.getText();
        }
        super.okPressed();
    }

    public String getName() {
        return this.name;
    }

    public long getNodeId() {
        return this.nodeId;
    }
}

