/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.alarmviewer.widgets;

import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.netxms.api.client.SessionListener;
import org.netxms.api.client.SessionNotification;
import org.netxms.client.NXCListener;
import org.netxms.client.NXCSession;
import org.netxms.client.events.Alarm;
import org.netxms.ui.eclipse.alarmviewer.Activator;
import org.netxms.ui.eclipse.alarmviewer.AlarmComparator;
import org.netxms.ui.eclipse.alarmviewer.AlarmListFilter;
import org.netxms.ui.eclipse.alarmviewer.AlarmListLabelProvider;
import org.netxms.ui.eclipse.alarmviewer.Messages;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class AlarmList
extends Composite {
    public static final String JOB_FAMILY = "AlarmViewJob";
    public static final int COLUMN_SEVERITY = 0;
    public static final int COLUMN_STATE = 1;
    public static final int COLUMN_SOURCE = 2;
    public static final int COLUMN_MESSAGE = 3;
    public static final int COLUMN_COUNT = 4;
    public static final int COLUMN_CREATED = 5;
    public static final int COLUMN_LASTCHANGE = 6;
    private final ViewPart viewPart;
    private NXCSession session = (NXCSession)ConsoleSharedData.getSession();
    private NXCListener clientListener = null;
    private SortableTableViewer alarmViewer;
    private AlarmListFilter alarmFilter;
    private HashMap<Long, Alarm> alarmList;
    private Action actionCopy;
    private Action actionCopyMessage;

    public AlarmList(ViewPart viewPart, Composite parent, int style, final String configPrefix) {
        super(parent, style);
        this.viewPart = viewPart;
        String[] names = new String[]{Messages.AlarmList_ColumnSeverity, Messages.AlarmList_ColumnState, Messages.AlarmList_ColumnSource, Messages.AlarmList_ColumnMessage, Messages.AlarmList_ColumnCount, Messages.AlarmList_ColumnCreated, Messages.AlarmList_ColumnLastChange};
        int[] widths = new int[]{100, 100, 150, 300, 70, 100, 100};
        this.alarmViewer = new SortableTableViewer((Composite)this, names, widths, 0, 1024, -1);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.alarmViewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)configPrefix);
        this.alarmViewer.setLabelProvider((IBaseLabelProvider)new AlarmListLabelProvider());
        this.alarmViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.alarmViewer.setComparator((ViewerComparator)new AlarmComparator());
        this.alarmFilter = new AlarmListFilter();
        this.alarmViewer.addFilter((ViewerFilter)this.alarmFilter);
        this.alarmViewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTableViewerSettings((SortableTableViewer)AlarmList.this.alarmViewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)configPrefix);
            }
        });
        this.createActions();
        this.createPopupMenu();
        this.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                AlarmList.this.alarmViewer.getControl().setBounds(AlarmList.this.getClientArea());
            }
        });
        new ConsoleJob(Messages.AlarmList_SyncJobName, (IWorkbenchPart)viewPart, "org.netxms.ui.eclipse.alarmviewer", JOB_FAMILY){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                AlarmList.this.alarmList = AlarmList.this.session.getAlarms(false);
                this.runInUIThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (!AlarmList.this.alarmViewer.getControl().isDisposed()) {
                            HashMap hashMap = AlarmList.this.alarmList;
                            synchronized (hashMap) {
                                AlarmList.this.alarmViewer.setInput(AlarmList.this.alarmList.values());
                            }
                        }
                    }
                });
            }

            protected String getErrorMessage() {
                return Messages.AlarmList_SyncJobError;
            }
        }.start();
        this.clientListener = new NXCListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void notificationHandler(SessionNotification n) {
                switch (n.getCode()) {
                    case 1004: 
                    case 1005: {
                        HashMap hashMap = AlarmList.this.alarmList;
                        synchronized (hashMap) {
                            AlarmList.this.alarmList.put(((Alarm)n.getObject()).getId(), (Alarm)n.getObject());
                        }
                        AlarmList.this.scheduleAlarmViewerUpdate();
                        break;
                    }
                    case 1003: 
                    case 1011: {
                        HashMap hashMap = AlarmList.this.alarmList;
                        synchronized (hashMap) {
                            AlarmList.this.alarmList.remove(((Alarm)n.getObject()).getId());
                        }
                        AlarmList.this.scheduleAlarmViewerUpdate();
                        break;
                    }
                }
            }
        };
        this.session.addListener((SessionListener)this.clientListener);
    }

    private void scheduleAlarmViewerUpdate() {
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!AlarmList.this.alarmViewer.getControl().isDisposed()) {
                    AlarmList.this.alarmViewer.refresh();
                }
            }
        });
    }

    private void createActions() {
        this.actionCopy = new Action(Messages.AlarmList_CopyToClipboard){

            public void run() {
                TableItem[] selection = AlarmList.this.alarmViewer.getTable().getSelection();
                if (selection.length > 0) {
                    String newLine = Platform.getOS().equals("win32") ? "\r\n" : "\n";
                    StringBuilder sb = new StringBuilder();
                    int i = 0;
                    while (i < selection.length) {
                        if (i > 0) {
                            sb.append(newLine);
                        }
                        sb.append('[');
                        sb.append(selection[i].getText(0));
                        sb.append("]\t");
                        sb.append(selection[i].getText(2));
                        sb.append('\t');
                        sb.append(selection[i].getText(3));
                        ++i;
                    }
                    WidgetHelper.copyToClipboard((String)sb.toString());
                }
            }
        };
        this.actionCopyMessage = new Action(Messages.AlarmList_CopyMsgToClipboard){

            public void run() {
                TableItem[] selection = AlarmList.this.alarmViewer.getTable().getSelection();
                if (selection.length > 0) {
                    String newLine = Platform.getOS().equals("win32") ? "\r\n" : "\n";
                    StringBuilder sb = new StringBuilder();
                    int i = 0;
                    while (i < selection.length) {
                        if (i > 0) {
                            sb.append(newLine);
                        }
                        sb.append(selection[i].getText(3));
                        ++i;
                    }
                    WidgetHelper.copyToClipboard((String)sb.toString());
                }
            }
        };
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                AlarmList.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.alarmViewer.getControl());
        this.alarmViewer.getControl().setMenu(menu);
        if (this.viewPart != null) {
            this.viewPart.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.alarmViewer);
        }
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionCopy);
        manager.add((IAction)this.actionCopyMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRootObject(long objectId) {
        this.alarmFilter.setRootObject(objectId);
        HashMap<Long, Alarm> hashMap = this.alarmList;
        synchronized (hashMap) {
            this.alarmViewer.refresh();
        }
    }

    public void dispose() {
        if (this.session != null && this.clientListener != null) {
            this.session.removeListener((SessionListener)this.clientListener);
        }
        super.dispose();
    }
}

