/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.base;

import java.io.IOException;
import java.io.InputStream;
import org.netxms.base.NXCPException;
import org.netxms.base.NXCPMessage;

public class NXCPMessageReceiver {
    private byte[] recvBuffer;
    private int bufferPos = 0;

    public NXCPMessageReceiver(int bufferSize) {
        this.recvBuffer = new byte[bufferSize];
    }

    private long getMessageSize(byte[] header) throws IOException {
        return (long)header[4] << 24 & 0xFFFFFFFFFF000000L | (long)header[5] << 16 & 0xFF0000L | (long)header[6] << 8 & 0xFF00L | (long)header[7] & 0xFFL;
    }

    private NXCPMessage getMessageFromBuffer() throws IOException, NXCPException {
        NXCPMessage msg = null;
        if (this.bufferPos >= 16) {
            long size = this.getMessageSize(this.recvBuffer);
            if (size <= (long)this.bufferPos) {
                msg = new NXCPMessage(this.recvBuffer);
                System.arraycopy(this.recvBuffer, (int)size, this.recvBuffer, 0, this.bufferPos - (int)size);
                this.bufferPos = (int)((long)this.bufferPos - size);
            } else if (size > (long)this.recvBuffer.length) {
                throw new NXCPException(1);
            }
        }
        return msg;
    }

    public NXCPMessage receiveMessage(InputStream in) throws IOException, NXCPException {
        NXCPMessage msg = null;
        while ((msg = this.getMessageFromBuffer()) == null) {
            int bytes = in.read(this.recvBuffer, this.bufferPos, this.recvBuffer.length - this.bufferPos);
            if (bytes == -1) {
                throw new NXCPException(2);
            }
            this.bufferPos += bytes;
        }
        return msg;
    }
}

