/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.algorithms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.zest.layouts.algorithms.AbstractLayoutAlgorithm;
import org.eclipse.zest.layouts.dataStructures.InternalNode;
import org.eclipse.zest.layouts.dataStructures.InternalRelationship;

public class SparseTree
extends AbstractLayoutAlgorithm {
    private static final int ROW_BINDING_DELTA = 10;
    private static final int MINIMAL_DISTANCE = 10;

    public SparseTree(int styles) {
        super(styles);
    }

    protected void applyLayoutInternal(InternalNode[] entitiesToLayout, InternalRelationship[] relationshipsToConsider, double boundsX, double boundsY, double boundsWidth, double boundsHeight) {
        ArrayList<InternalNode> row;
        ArrayList<ArrayList<InternalNode>> rows = new ArrayList<ArrayList<InternalNode>>();
        int i = 0;
        while (i < entitiesToLayout.length) {
            this.addToRow(rows, entitiesToLayout[i]);
            ++i;
        }
        Collections.sort(rows, new Comparator<ArrayList<InternalNode>>(){

            @Override
            public int compare(ArrayList<InternalNode> o1, ArrayList<InternalNode> o2) {
                return (int)(o1.get(0).getLayoutEntity().getYInLayout() - o2.get(0).getLayoutEntity().getYInLayout());
            }
        });
        int currRowIdx = 0;
        while (currRowIdx < rows.size()) {
            row = rows.get(currRowIdx);
            Collections.sort(row, new Comparator<InternalNode>(){

                @Override
                public int compare(InternalNode node1, InternalNode node2) {
                    return (int)(node1.getLayoutEntity().getXInLayout() - node2.getLayoutEntity().getXInLayout());
                }
            });
            int currNodeIdx = 1;
            while (currNodeIdx < row.size()) {
                double prevNodePos;
                double minimalPos;
                InternalNode currNode = row.get(currNodeIdx);
                InternalNode prevNode = row.get(currNodeIdx - 1);
                double currNodePos = currNode.getLayoutEntity().getXInLayout();
                if (currNodePos < (minimalPos = (prevNodePos = prevNode.getLayoutEntity().getXInLayout()) + prevNode.getLayoutEntity().getWidthInLayout() + 10.0)) {
                    currNode.setLocation(minimalPos, currNode.getLayoutEntity().getYInLayout());
                }
                ++currNodeIdx;
            }
            ++currRowIdx;
        }
        currRowIdx = rows.size() - 1;
        while (currRowIdx > 0) {
            row = rows.get(currRowIdx);
            double leftmostX = row.get(0).getLayoutEntity().getXInLayout();
            int firstChildIdx = 0;
            InternalNode parent = this.getParentNode(row.get(0), relationshipsToConsider);
            int currNodeIdx = 1;
            while (currNodeIdx < row.size()) {
                InternalNode currNode = row.get(currNodeIdx);
                InternalNode nextParent = this.getParentNode(currNode, relationshipsToConsider);
                if (parent != nextParent) {
                    if (parent != null) {
                        this.centerNode(rows, currRowIdx, firstChildIdx, parent, relationshipsToConsider, leftmostX, row.get(currNodeIdx - 1).getLayoutEntity().getXInLayout() + row.get(currNodeIdx - 1).getLayoutEntity().getWidthInLayout());
                    }
                    parent = nextParent;
                    leftmostX = currNode.getLayoutEntity().getXInLayout();
                    firstChildIdx = currNodeIdx;
                }
                ++currNodeIdx;
            }
            if (parent != null) {
                InternalNode currNode = row.get(row.size() - 1);
                this.centerNode(rows, currRowIdx, firstChildIdx, parent, relationshipsToConsider, leftmostX, currNode.getLayoutEntity().getXInLayout() + currNode.getLayoutEntity().getWidthInLayout());
            }
            --currRowIdx;
        }
    }

    private void centerNode(ArrayList<ArrayList<InternalNode>> rows, int currRowIdx, int firstChildIdx, InternalNode node, InternalRelationship[] relationships, double leftmostX, double rightmostX) {
        block3: {
            double shift;
            block2: {
                double newX = leftmostX + (rightmostX - leftmostX) / 2.0 - node.getLayoutEntity().getWidthInLayout() / 2.0;
                shift = newX - node.getLayoutEntity().getXInLayout();
                if (!(shift > 0.0)) break block2;
                ArrayList<InternalNode> row = rows.get(currRowIdx - 1);
                node.setLocation(newX, node.getLayoutEntity().getYInLayout());
                int index = row.indexOf(node);
                if (index == -1) break block3;
                int i = index + 1;
                while (i < row.size()) {
                    InternalNode n = row.get(i);
                    n.setLocation(n.getLayoutEntity().getXInLayout() + shift, n.getLayoutEntity().getYInLayout());
                    ++i;
                }
                break block3;
            }
            ArrayList<InternalNode> row = rows.get(currRowIdx);
            int i = firstChildIdx;
            while (i < row.size()) {
                InternalNode n = row.get(i);
                n.setLocation(n.getLayoutEntity().getXInLayout() - shift, n.getLayoutEntity().getYInLayout());
                this.shiftChildNodes(rows, currRowIdx + 1, n, relationships, -shift);
                ++i;
            }
        }
    }

    private void shiftChildNodes(ArrayList<ArrayList<InternalNode>> rows, int currRowIdx, InternalNode parent, InternalRelationship[] relationships, double shift) {
        if (rows.size() <= currRowIdx) {
            return;
        }
        ArrayList<InternalNode> row = rows.get(currRowIdx);
        for (InternalNode n : row) {
            if (this.getParentNode(n, relationships) != parent) continue;
            n.setLocation(n.getLayoutEntity().getXInLayout() + shift, n.getLayoutEntity().getYInLayout());
            this.shiftChildNodes(rows, currRowIdx + 1, n, relationships, shift);
        }
    }

    private InternalNode getParentNode(InternalNode node, InternalRelationship[] relationships) {
        InternalRelationship[] internalRelationshipArray = relationships;
        int n = relationships.length;
        int n2 = 0;
        while (n2 < n) {
            InternalRelationship r = internalRelationshipArray[n2];
            if (r.getDestination() == node) {
                return r.getSource();
            }
            ++n2;
        }
        return null;
    }

    private void addToRow(ArrayList<ArrayList<InternalNode>> rows, InternalNode node) {
        double nodeY = node.getLayoutEntity().getYInLayout();
        for (ArrayList<InternalNode> row : rows) {
            double rowY = row.get(0).getLayoutEntity().getYInLayout();
            if (!(Math.abs(nodeY - rowY) <= 10.0)) continue;
            row.add(node);
            return;
        }
        ArrayList<InternalNode> newRow = new ArrayList<InternalNode>();
        newRow.add(node);
        rows.add(newRow);
    }

    protected int getCurrentLayoutStep() {
        return 0;
    }

    protected int getTotalNumberOfLayoutSteps() {
        return 0;
    }

    protected boolean isValidConfiguration(boolean asynchronous, boolean continuous) {
        return true;
    }

    protected void postLayoutAlgorithm(InternalNode[] entitiesToLayout, InternalRelationship[] relationshipsToConsider) {
    }

    protected void preLayoutAlgorithm(InternalNode[] entitiesToLayout, InternalRelationship[] relationshipsToConsider, double x, double y, double width, double height) {
    }

    public void setLayoutArea(double x, double y, double width, double height) {
    }
}

