/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.agentmanager.views;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.netxms.api.client.ProgressListener;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.packages.PackageDeploymentListener;
import org.netxms.client.packages.PackageInfo;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.agentmanager.Activator;
import org.netxms.ui.eclipse.agentmanager.views.PackageDeploymentMonitor;
import org.netxms.ui.eclipse.agentmanager.views.helpers.PackageComparator;
import org.netxms.ui.eclipse.agentmanager.views.helpers.PackageLabelProvider;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.shared.SharedIcons;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class PackageManager
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.agentmanager.views.PackageManager";
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_NAME = 1;
    public static final int COLUMN_VERSION = 2;
    public static final int COLUMN_PLATFORM = 3;
    public static final int COLUMN_FILE = 4;
    public static final int COLUMN_DESCRIPTION = 5;
    private List<PackageInfo> packageList = null;
    private SortableTableViewer viewer;
    private Action actionRefresh;
    private Action actionInstall;
    private Action actionRemove;
    private Action actionDeploy;

    public void createPartControl(Composite parent) {
        String[] names = new String[]{"ID", "Name", "Version", "Platform", "File", "Description"};
        int[] widths = new int[]{70, 120, 90, 120, 150, 400};
        this.viewer = new SortableTableViewer(parent, names, widths, 0, 128, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new PackageLabelProvider());
        this.viewer.setComparator((ViewerComparator)new PackageComparator());
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)PackageManager.this.viewer.getSelection();
                PackageManager.this.actionDeploy.setEnabled(selection.size() == 1);
                PackageManager.this.actionRemove.setEnabled(selection.size() > 0);
            }
        });
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        new ConsoleJob("Open package database", (IWorkbenchPart)this, "org.netxms.ui.eclipse.agentmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                block2: {
                    try {
                        session.lockPackageDatabase();
                    }
                    catch (NXCException e) {
                        if (e.getErrorCode() == 28) break block2;
                        throw e;
                    }
                }
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        PackageManager.this.refresh();
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot open package database";
            }
        }.start();
    }

    public void setFocus() {
        this.viewer.getTable().setFocus();
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction(){

            public void run() {
                PackageManager.this.refresh();
            }
        };
        this.actionInstall = new Action("&Install new package...", SharedIcons.ADD_OBJECT){

            public void run() {
                PackageManager.this.installPackage();
            }
        };
        this.actionRemove = new Action("&Remove", SharedIcons.DELETE_OBJECT){

            public void run() {
                PackageManager.this.removePackage();
            }
        };
        this.actionDeploy = new Action("&Deploy to managed nodes...", Activator.getImageDescriptor("icons/package_deploy.gif")){

            public void run() {
                PackageManager.this.deployPackage();
            }
        };
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionInstall);
        manager.add((IAction)this.actionRemove);
        manager.add((IAction)this.actionDeploy);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionInstall);
        manager.add((IAction)this.actionRefresh);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                PackageManager.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionDeploy);
        manager.add((IAction)this.actionRemove);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("additions"));
    }

    private void refresh() {
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        new ConsoleJob("Load package list", (IWorkbenchPart)this, "org.netxms.ui.eclipse.agentmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List list = session.getInstalledPackages();
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        PackageManager.this.packageList = list;
                        PackageManager.this.viewer.setInput((Object)list.toArray());
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot get package list from server";
            }
        }.start();
    }

    private void installPackage() {
        FileDialog fd = new FileDialog(this.getSite().getShell(), 4096);
        fd.setText("Select Package File");
        fd.setFilterExtensions(new String[]{"*.npi", "*.*"});
        fd.setFilterNames(new String[]{"NetXMS Package Info", "All files"});
        String npiName = fd.open();
        if (npiName != null) {
            try {
                final File npiFile = new File(npiName);
                final PackageInfo p = new PackageInfo(npiFile);
                final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
                new ConsoleJob("Install package", (IWorkbenchPart)this, "org.netxms.ui.eclipse.agentmanager", null){

                    protected void runInternal(final IProgressMonitor monitor) throws Exception {
                        long id = session.installPackage(p, new File(npiFile.getParent(), p.getFileName()), new ProgressListener(){
                            long prevAmount = 0L;

                            public void setTotalWorkAmount(long amount) {
                                monitor.beginTask("Upload package file", (int)amount);
                            }

                            public void markProgress(long amount) {
                                monitor.worked((int)(amount - this.prevAmount));
                                this.prevAmount = amount;
                            }
                        });
                        p.setId(id);
                        this.runInUIThread(new Runnable(){

                            @Override
                            public void run() {
                                PackageManager.this.packageList.add(p);
                                PackageManager.this.viewer.setInput((Object)PackageManager.this.packageList.toArray());
                            }
                        });
                    }

                    protected String getErrorMessage() {
                        return "Cannot install package";
                    }
                }.start();
            }
            catch (IOException e) {
                MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Error", (String)("Cannot open package information file: " + e.getLocalizedMessage()));
            }
        }
    }

    private void removePackage() {
        if (!MessageDialog.openConfirm((Shell)this.getSite().getShell(), (String)"Confirm Package Delete", (String)"Are you sure you wish to delete selected packages?")) {
            return;
        }
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        final Object[] packages = ((IStructuredSelection)this.viewer.getSelection()).toArray();
        final ArrayList removedPackages = new ArrayList();
        new ConsoleJob("Delete agent packages", (IWorkbenchPart)this, "org.netxms.ui.eclipse.agentmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                Object[] objectArray = packages;
                int n = packages.length;
                int n2 = 0;
                while (n2 < n) {
                    Object p = objectArray[n2];
                    session.removePackage(((PackageInfo)p).getId());
                    removedPackages.add(p);
                    ++n2;
                }
            }

            protected void jobFinalize() {
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        PackageManager.this.packageList.removeAll(removedPackages);
                        PackageManager.this.viewer.setInput((Object)PackageManager.this.packageList.toArray());
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot delete package from server";
            }
        }.start();
    }

    private void deployPackage() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        final PackageInfo pkg = (PackageInfo)selection.getFirstElement();
        ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.getSite().getShell(), null, ObjectSelectionDialog.createNodeSelectionFilter());
        dlg.enableMultiSelection(true);
        if (dlg.open() != 0) {
            return;
        }
        final HashSet<Long> objects = new HashSet<Long>();
        for (GenericObject o : dlg.getSelectedObjects()) {
            objects.add(o.getObjectId());
        }
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        ConsoleJob job = new ConsoleJob("Deploy agent package", null, "org.netxms.ui.eclipse.agentmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.deployPackage(pkg.getId(), objects.toArray(new Long[objects.size()]), new PackageDeploymentListener(){
                    private PackageDeploymentMonitor monitor = null;

                    public void statusUpdate(long nodeId, int status, String message) {
                        if (this.monitor != null) {
                            this.monitor.statusUpdate(nodeId, status, message);
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void deploymentStarted() {
                        Object sync;
                        Object object = sync = new Object();
                        synchronized (object) {
                            this.runInUIThread(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    try {
                                        monitor = (PackageDeploymentMonitor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.netxms.ui.eclipse.agentmanager.views.PackageDeploymentMonitor", this.toString(), 1);
                                    }
                                    catch (PartInitException e) {
                                        MessageDialog.openError((Shell)PackageManager.this.getSite().getShell(), (String)"Error", (String)("Cannot open deployment monitor view: " + e.getLocalizedMessage()));
                                    }
                                    Object object = sync;
                                    synchronized (object) {
                                        sync.notify();
                                    }
                                }
                            });
                            try {
                                sync.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }

                    public void deploymentComplete() {
                        this.runInUIThread(new Runnable(){

                            @Override
                            public void run() {
                                MessageDialog.openInformation((Shell)PackageManager.this.getSite().getShell(), (String)"Information", (String)"Package deployment completed");
                            }
                        });
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot start package deployment";
            }
        };
        job.setUser(false);
        job.start();
    }

    public void dispose() {
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        new ConsoleJob("Unlock package database", null, "org.netxms.ui.eclipse.agentmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                block2: {
                    try {
                        session.unlockPackageDatabase();
                    }
                    catch (NXCException e) {
                        if (e.getErrorCode() == 28) break block2;
                        throw e;
                    }
                }
            }

            protected String getErrorMessage() {
                return "Cannot unlock package database";
            }
        }.start();
        super.dispose();
    }
}

