/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.logviewer.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.netxms.client.log.Log;
import org.netxms.client.log.LogColumn;
import org.netxms.client.log.OrderingColumn;
import org.netxms.ui.eclipse.logviewer.widgets.ColumnFilterEditor;
import org.netxms.ui.eclipse.logviewer.widgets.helpers.ColumnSelectionHandler;
import org.netxms.ui.eclipse.logviewer.widgets.helpers.FilterTreeElement;
import org.netxms.ui.eclipse.logviewer.widgets.helpers.OrderingColumnEditingSupport;
import org.netxms.ui.eclipse.logviewer.widgets.helpers.OrderingListLabelProvider;
import org.netxms.ui.eclipse.shared.SharedIcons;

public class FilterBuilder
extends Composite {
    private Log logHandle = null;
    private List<FilterTreeElement> elements = new ArrayList<FilterTreeElement>();
    private FilterTreeElement rootElement = null;
    private List<OrderingColumn> orderingColumns = new ArrayList<OrderingColumn>();
    private FormToolkit toolkit;
    private Form form;
    private Section condition;
    private Section ordering;
    private TableViewer orderingList;
    private Action actionExecute;
    private Action actionClose;
    private Menu columnSelectionMenu = null;

    public FilterBuilder(Composite parent, int style) {
        super(parent, style);
        this.rootElement = new FilterTreeElement(0, null, null);
        this.elements.add(this.rootElement);
        this.setLayout((Layout)new FillLayout());
        this.toolkit = new FormToolkit(this.getDisplay());
        this.form = this.toolkit.createForm((Composite)this);
        this.form.setText("Filter");
        this.form.getToolBarManager().add((IAction)new Action("&Execute", SharedIcons.EXECUTE){

            public void run() {
                if (FilterBuilder.this.actionExecute != null) {
                    FilterBuilder.this.actionExecute.run();
                }
            }
        });
        this.form.getToolBarManager().add((IAction)new Action("&Clear filter", SharedIcons.CLEAR_LOG){

            public void run() {
                FilterBuilder.this.clearFilter();
            }
        });
        this.form.getToolBarManager().add((IAction)new Action("Close", SharedIcons.CLOSE){

            public void run() {
                if (FilterBuilder.this.actionClose != null) {
                    FilterBuilder.this.actionClose.run();
                }
            }
        });
        this.form.getToolBarManager().update(true);
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 3;
        this.form.getBody().setLayout((Layout)layout);
        this.createConditionSection();
        this.createOrderingSection();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (FilterBuilder.this.columnSelectionMenu != null) {
                    FilterBuilder.this.columnSelectionMenu.dispose();
                }
            }
        });
    }

    private void createConditionSection() {
        this.condition = this.toolkit.createSection(this.form.getBody(), 256);
        this.condition.setText("Condition");
        TableWrapData twd = new TableWrapData();
        twd.grabHorizontal = true;
        twd.align = 128;
        this.condition.setLayoutData((Object)twd);
        Composite clientArea = this.toolkit.createComposite((Composite)this.condition);
        GridLayout layout = new GridLayout();
        clientArea.setLayout((Layout)layout);
        this.condition.setClient((Control)clientArea);
        final ImageHyperlink addColumnLink = this.toolkit.createImageHyperlink(clientArea, 0);
        addColumnLink.setText("Add column");
        addColumnLink.setImage(SharedIcons.IMG_ADD_OBJECT);
        addColumnLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                FilterBuilder.this.addColumnToFilter((Control)addColumnLink);
            }
        });
    }

    private void createOrderingSection() {
        this.ordering = this.toolkit.createSection(this.form.getBody(), 256);
        this.ordering.setText("Ordering");
        TableWrapData twd = new TableWrapData();
        twd.grabHorizontal = false;
        twd.align = 128;
        this.ordering.setLayoutData((Object)twd);
        Composite clientArea = this.toolkit.createComposite((Composite)this.ordering);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        clientArea.setLayout((Layout)layout);
        this.ordering.setClient((Control)clientArea);
        this.orderingList = new TableViewer(clientArea, 68354);
        this.toolkit.adapt((Composite)this.orderingList.getTable());
        TableViewerColumn column = new TableViewerColumn(this.orderingList, 16384);
        column.getColumn().setText("Column");
        column.getColumn().setWidth(200);
        column = new TableViewerColumn(this.orderingList, 16384);
        column.getColumn().setText("Descending");
        column.getColumn().setWidth(60);
        column.setEditingSupport((EditingSupport)new OrderingColumnEditingSupport((ColumnViewer)this.orderingList));
        this.orderingList.getTable().setLinesVisible(true);
        this.orderingList.getTable().setHeaderVisible(true);
        this.orderingList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.orderingList.setLabelProvider((IBaseLabelProvider)new OrderingListLabelProvider());
        this.orderingList.setInput((Object)this.orderingColumns.toArray());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalSpan = 2;
        gd.heightHint = 60;
        this.orderingList.getControl().setLayoutData((Object)gd);
        ImageHyperlink linkAdd = this.toolkit.createImageHyperlink(clientArea, 0);
        linkAdd.setText("Add");
        linkAdd.setImage(SharedIcons.IMG_ADD_OBJECT);
        linkAdd.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                FilterBuilder.this.addSortingColumn();
            }
        });
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkAdd.setLayoutData((Object)gd);
        final ImageHyperlink linkRemove = this.toolkit.createImageHyperlink(clientArea, 0);
        linkRemove.setText("Remove");
        linkRemove.setImage(SharedIcons.IMG_DELETE_OBJECT);
        linkRemove.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                FilterBuilder.this.removeSortingColumn();
            }
        });
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkRemove.setLayoutData((Object)gd);
        linkRemove.setEnabled(false);
        this.orderingList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                linkRemove.setEnabled(!FilterBuilder.this.orderingList.getSelection().isEmpty());
            }
        });
    }

    public void setExecuteAction(Action action) {
        this.actionExecute = action;
    }

    public void setCloseAction(Action action) {
        this.actionClose = action;
    }

    public void clearFilter() {
    }

    private void addSortingColumn() {
        this.createColumnSelectionMenu(new ColumnSelectionHandler(){

            @Override
            public void columnSelected(LogColumn column) {
                OrderingColumn orderingColumn = new OrderingColumn(column);
                if (!FilterBuilder.this.orderingColumns.contains(orderingColumn)) {
                    FilterBuilder.this.orderingColumns.add(orderingColumn);
                    FilterBuilder.this.orderingList.setInput((Object)FilterBuilder.this.orderingColumns.toArray());
                } else {
                    FilterBuilder.this.orderingList.setSelection((ISelection)new StructuredSelection((Object)column));
                }
            }
        });
    }

    private void removeSortingColumn() {
        IStructuredSelection selection = (IStructuredSelection)this.orderingList.getSelection();
        for (Object o : selection.toList()) {
            this.orderingColumns.remove(o);
        }
        this.orderingList.setInput((Object)this.orderingColumns.toArray());
    }

    public void setLogHandle(Log logHandle) {
        this.logHandle = logHandle;
        this.form.setText("Filter: " + logHandle.getName());
    }

    private void addColumnToFilter(final Control lastControl) {
        this.createColumnSelectionMenu(new ColumnSelectionHandler(){

            @Override
            public void columnSelected(LogColumn column) {
                for (FilterTreeElement e : FilterBuilder.this.elements) {
                    if (e.getType() != 1 || !((LogColumn)e.getObject()).getName().equals(column.getName())) continue;
                    return;
                }
                final FilterTreeElement columnElement = new FilterTreeElement(1, column, FilterBuilder.this.rootElement);
                FilterBuilder.this.elements.add(columnElement);
                ColumnFilterEditor editor = new ColumnFilterEditor((Composite)FilterBuilder.this.condition.getClient(), 2048, column, columnElement, new Runnable(){

                    @Override
                    public void run() {
                        FilterBuilder.this.rootElement.removeChild(columnElement);
                        FilterBuilder.this.elements.remove(columnElement);
                        columnElement.getEditor().dispose();
                        FilterBuilder.this.getParent().layout(true, true);
                    }
                });
                editor.moveAbove(lastControl);
                GridData gd = new GridData();
                gd.grabExcessHorizontalSpace = true;
                gd.horizontalAlignment = 4;
                editor.setLayoutData(gd);
                columnElement.setEditor(editor);
                FilterBuilder.this.getParent().layout(true, true);
            }
        });
    }

    private void createColumnSelectionMenu(final ColumnSelectionHandler handler) {
        if (this.logHandle == null) {
            return;
        }
        if (this.columnSelectionMenu != null) {
            this.columnSelectionMenu.dispose();
        }
        this.columnSelectionMenu = new Menu((Decorations)this.getShell(), 8);
        this.getShell().setMenu(this.columnSelectionMenu);
        for (final LogColumn lc : this.logHandle.getColumns()) {
            MenuItem item = new MenuItem(this.columnSelectionMenu, 8);
            item.setText(lc.getDescription());
            item.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    handler.columnSelected(lc);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
        }
        this.columnSelectionMenu.addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent e) {
            }

            public void menuHidden(MenuEvent e) {
                FilterBuilder.this.getShell().setMenu(null);
            }
        });
        this.columnSelectionMenu.setVisible(true);
    }
}

