/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.DataCollectionConfiguration;
import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.client.objects.Interface;
import org.netxms.client.objects.Node;
import org.netxms.ui.eclipse.datacollection.dialogs.CreateInterfaceDciDialog;
import org.netxms.ui.eclipse.datacollection.dialogs.helpers.InterfaceDciInfo;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class CreateInterfraceDci
implements IObjectActionDelegate {
    private static final int IFDCI_IN_BYTES = 0;
    private static final int IFDCI_OUT_BYTES = 1;
    private static final int IFDCI_IN_PACKETS = 2;
    private static final int IFDCI_OUT_PACKETS = 3;
    private static final int IFDCI_IN_ERRORS = 4;
    private static final int IFDCI_OUT_ERRORS = 5;
    private Shell shell;
    private ViewPart viewPart;
    private List<Interface> objects = new ArrayList<Interface>();

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
        this.viewPart = targetPart instanceof ViewPart ? (ViewPart)targetPart : null;
    }

    public void run(IAction action) {
        final CreateInterfaceDciDialog dlg = new CreateInterfaceDciDialog(this.shell, this.objects.size() == 1 ? this.objects.get(0) : null);
        if (dlg.open() == 0) {
            final ArrayList<Interface> ifaces = new ArrayList<Interface>(this.objects);
            HashSet<Node> nodes = new HashSet<Node>();
            for (Interface iface : ifaces) {
                Node node = iface.getParentNode();
                if (node == null) continue;
                nodes.add(node);
            }
            final HashMap<Long, Boolean> lockRequired = new HashMap<Long, Boolean>(nodes.size());
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            for (Node n : nodes) {
                IViewReference ref = page.findViewReference("org.netxms.ui.eclipse.datacollection.view.data_collection_editor", Long.toString(n.getObjectId()));
                lockRequired.put(n.getObjectId(), ref == null || ref.getView(false) == null);
            }
            new ConsoleJob("Create DCIs for interface", (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.datacollection", null){

                protected String getErrorMessage() {
                    return "Cannot create DCI for interface";
                }

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    InterfaceDciInfo[] dciInfo = dlg.getDciInfo();
                    monitor.beginTask("Creating DCIs", ifaces.size() * dciInfo.length);
                    int i = 0;
                    while (i < ifaces.size()) {
                        int j = 0;
                        while (j < dciInfo.length) {
                            if (dciInfo[j].enabled) {
                                CreateInterfraceDci.createInterfaceDci((Interface)ifaces.get(i), j, dciInfo[j], dlg.getPollingInterval(), dlg.getRetentionTime(), ifaces.size() > 1, lockRequired);
                            }
                            monitor.worked(1);
                            ++j;
                        }
                        ++i;
                    }
                    monitor.done();
                }
            }.start();
        }
    }

    private static void createInterfaceDci(Interface iface, int dciType, InterfaceDciInfo dciInfo, int pollingInterval, int retentionTime, boolean updateDescription, Map<Long, Boolean> lockRequired) throws Exception {
        Node node = iface.getParentNode();
        if (node == null) {
            throw new NXCException(46);
        }
        NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        DataCollectionConfiguration dcc = lockRequired.get(node.getObjectId()) != false ? session.openDataCollectionConfiguration(node.getObjectId()) : new DataCollectionConfiguration(session, node.getObjectId());
        DataCollectionItem dci = dcc.findItem(dcc.createItem());
        dci.setPollingInterval(pollingInterval);
        dci.setRetentionTime(retentionTime);
        dci.setOrigin(node.hasAgent() ? 1 : 2);
        dci.setDataType(1);
        dci.setStatus(0);
        dci.setDescription(updateDescription ? dciInfo.description.replaceAll("@@ifName@@", iface.getObjectName()) : dciInfo.description);
        dci.setDeltaCalculation(dciInfo.delta ? 2 : 0);
        if (dci.getOrigin() == 1) {
            switch (dciType) {
                case 0: {
                    dci.setName("Net.Interface.BytesIn(" + iface.getIfIndex() + ")");
                    break;
                }
                case 1: {
                    dci.setName("Net.Interface.BytesOut(" + iface.getIfIndex() + ")");
                    break;
                }
                case 2: {
                    dci.setName("Net.Interface.PacketsIn(" + iface.getIfIndex() + ")");
                    break;
                }
                case 3: {
                    dci.setName("Net.Interface.PacketsOut(" + iface.getIfIndex() + ")");
                    break;
                }
                case 4: {
                    dci.setName("Net.Interface.InErrors(" + iface.getIfIndex() + ")");
                    break;
                }
                case 5: {
                    dci.setName("Net.Interface.OutErrors(" + iface.getIfIndex() + ")");
                }
            }
        } else {
            switch (dciType) {
                case 0: {
                    dci.setName(".1.3.6.1.2.1.2.2.1.10." + iface.getIfIndex());
                    break;
                }
                case 1: {
                    dci.setName(".1.3.6.1.2.1.2.2.1.16." + iface.getIfIndex());
                    break;
                }
                case 2: {
                    dci.setName(".1.3.6.1.2.1.2.2.1.11." + iface.getIfIndex());
                    break;
                }
                case 3: {
                    dci.setName(".1.3.6.1.2.1.2.2.1.17." + iface.getIfIndex());
                    break;
                }
                case 4: {
                    dci.setName(".1.3.6.1.2.1.2.2.1.14." + iface.getIfIndex());
                    break;
                }
                case 5: {
                    dci.setName(".1.3.6.1.2.1.2.2.1.20." + iface.getIfIndex());
                }
            }
        }
        dcc.modifyItem(dci);
        if (lockRequired.get(node.getObjectId()).booleanValue()) {
            dcc.close();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.objects.clear();
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() > 0) {
            for (Object o : ((IStructuredSelection)selection).toList()) {
                if (!(o instanceof Interface)) continue;
                this.objects.add((Interface)o);
            }
            action.setEnabled(this.objects.size() > 0);
        } else {
            action.setEnabled(false);
        }
    }
}

