/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.propertypages;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.objects.GenericObject;
import org.netxms.ui.eclipse.dashboard.widgets.internal.ObjectStatusChartConfig;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class ObjectStatusChart
extends PropertyPage {
    private ObjectStatusChartConfig config;
    private ObjectSelector objectSelector;
    private LabeledText title;
    private Button checkShowLegend;
    private Button checkShow3D;
    private Button checkTransposed;
    private Button checkTranslucent;

    protected Control createContents(Composite parent) {
        this.config = (ObjectStatusChartConfig)this.getElement().getAdapter(ObjectStatusChartConfig.class);
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        dialogArea.setLayout((Layout)layout);
        this.objectSelector = new ObjectSelector(dialogArea, 0);
        this.objectSelector.setLabel("Root Object");
        this.objectSelector.setObjectClass(GenericObject.class);
        this.objectSelector.setObjectId(this.config.getRootObject());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.objectSelector.setLayoutData((Object)gd);
        this.title = new LabeledText(dialogArea, 0);
        this.title.setLabel("Title");
        this.title.setText(this.config.getTitle());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.title.setLayoutData((Object)gd);
        this.checkShowLegend = new Button(dialogArea, 32);
        this.checkShowLegend.setText("Show &legend");
        this.checkShowLegend.setSelection(this.config.isShowLegend());
        this.checkShow3D = new Button(dialogArea, 32);
        this.checkShow3D.setText("&3D view");
        this.checkShow3D.setSelection(this.config.isShowIn3D());
        this.checkTransposed = new Button(dialogArea, 32);
        this.checkTransposed.setText("Trans&posed");
        this.checkTransposed.setSelection(this.config.isTransposed());
        this.checkTranslucent = new Button(dialogArea, 32);
        this.checkTranslucent.setText("&Translucent");
        this.checkTranslucent.setSelection(this.config.isTranslucent());
        return dialogArea;
    }

    public boolean performOk() {
        this.config.setRootObject(this.objectSelector.getObjectId());
        this.config.setTitle(this.title.getText());
        this.config.setShowLegend(this.checkShowLegend.getSelection());
        this.config.setShowIn3D(this.checkShow3D.getSelection());
        this.config.setTransposed(this.checkTransposed.getSelection());
        this.config.setTranslucent(this.checkTranslucent.getSelection());
        return true;
    }
}

