/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.widgets;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.netxms.ui.eclipse.library.Messages;

public class AbstractSelector
extends Composite {
    private Label label;
    private CLabel text;
    private Button button;
    private Action actionCopy;
    private Image scaledImage = null;

    public AbstractSelector(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 2;
        layout.horizontalSpacing = 2;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        this.setLayout((Layout)layout);
        this.label = new Label((Composite)this, 0);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 2;
        this.label.setLayoutData((Object)gd);
        this.text = new CLabel((Composite)this, 2048);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 128;
        this.text.setLayoutData((Object)gd);
        this.button = new Button((Composite)this, 8);
        gd = new GridData();
        gd.heightHint = this.text.computeSize((int)-1, (int)-1).y;
        this.button.setLayoutData((Object)gd);
        this.button.setText("...");
        this.button.setToolTipText(this.getButtonToolTip());
        this.button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                AbstractSelector.this.selectionButtonHandler();
            }
        });
        this.createActions();
        this.createContextMenu();
        this.text.setToolTipText(this.getTextToolTip());
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (AbstractSelector.this.scaledImage != null) {
                    AbstractSelector.this.scaledImage.dispose();
                }
            }
        });
    }

    private void createActions() {
        this.actionCopy = new Action(){

            public void run() {
                Clipboard cb = new Clipboard(AbstractSelector.this.getDisplay());
                cb.setContents(new Object[]{AbstractSelector.this.text.getText()}, new Transfer[]{TextTransfer.getInstance()});
            }
        };
        this.actionCopy.setText(Messages.AbstractSelector_CopyToClipboard);
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                AbstractSelector.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.text);
        this.text.setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        mgr.add((IAction)this.actionCopy);
    }

    protected void selectionButtonHandler() {
    }

    protected String getButtonToolTip() {
        return Messages.AbstractSelector_Select;
    }

    protected String getTextToolTip() {
        return null;
    }

    public void setLabel(String newLabel) {
        this.label.setText(newLabel);
    }

    public String getLabel() {
        return this.label.getText();
    }

    public void setText(String newText) {
        this.text.setText(newText);
    }

    public String getText() {
        return this.text.getText();
    }

    public void setImage(Image image) {
        if (this.scaledImage != null) {
            this.scaledImage.dispose();
            this.scaledImage = null;
        }
        if (image != null) {
            Rectangle size = image.getBounds();
            if (size.width > 64 || size.height > 64) {
                this.scaledImage = new Image((Device)this.getDisplay(), image.getImageData().scaledTo(64, 64));
                this.text.setImage(this.scaledImage);
            } else {
                this.text.setImage(image);
            }
        } else {
            this.text.setImage(null);
        }
    }

    public Image getImage() {
        return this.text.getImage();
    }

    public void setEnabled(boolean enabled) {
        this.text.setEnabled(enabled);
        this.button.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    protected Control getTextControl() {
        return this.text;
    }
}

