/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.filemanager.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.netxms.api.client.ProgressListener;
import org.netxms.client.NXCSession;
import org.netxms.ui.eclipse.filemanager.dialogs.StartClientToServerFileUploadDialog;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class UploadFileToServer
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow window;

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public void run(IAction action) {
        final StartClientToServerFileUploadDialog dlg = new StartClientToServerFileUploadDialog(this.window.getShell());
        if (dlg.open() == 0) {
            new ConsoleJob("Upload file to server", null, "org.netxms.ui.eclipse.filemanager", null){

                protected void runInternal(final IProgressMonitor monitor) throws Exception {
                    NXCSession session = (NXCSession)ConsoleSharedData.getSession();
                    session.uploadFileToServer(dlg.getLocalFile(), dlg.getRemoteFileName(), new ProgressListener(){
                        private long prevWorkDone = 0L;

                        public void setTotalWorkAmount(long workTotal) {
                            monitor.beginTask("Upload file " + dlg.getLocalFile().getAbsolutePath(), (int)workTotal);
                        }

                        public void markProgress(long workDone) {
                            monitor.worked((int)(workDone - this.prevWorkDone));
                            this.prevWorkDone = workDone;
                        }
                    });
                    monitor.done();
                }

                protected String getErrorMessage() {
                    return "Cannot upload file to server";
                }
            }.start();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

