/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.epp.widgets;

import org.eclipse.swt.widgets.Composite;
import org.netxms.client.situations.Situation;
import org.netxms.ui.eclipse.epp.SituationCache;
import org.netxms.ui.eclipse.epp.dialogs.SituationSelectionDialog;
import org.netxms.ui.eclipse.widgets.AbstractSelector;

public class SituationSelector
extends AbstractSelector {
    private long situationId = 0L;

    public SituationSelector(Composite parent, int style) {
        super(parent, style);
        this.setText("<none>");
    }

    protected void selectionButtonHandler() {
        SituationSelectionDialog dlg = new SituationSelectionDialog(this.getShell());
        dlg.enableMultiSelection(false);
        if (dlg.open() == 0) {
            Situation[] situations = dlg.getSelectedSituations();
            if (situations.length > 0) {
                this.situationId = situations[0].getId();
                this.setText(situations[0].getName());
                this.getTextControl().setToolTipText(situations[0].getComments());
            } else {
                this.situationId = 0L;
                this.setText("<none>");
                this.setImage(null);
                this.getTextControl().setToolTipText(null);
            }
        }
    }

    public void setSituationId(long situationId) {
        this.situationId = situationId;
        if (situationId != 0L) {
            Situation s = SituationCache.findSituation(situationId);
            if (s != null) {
                this.setText(s.getName());
                this.getTextControl().setToolTipText(s.getComments());
            } else {
                this.setText("<unknown>");
                this.setImage(null);
                this.getTextControl().setToolTipText(null);
            }
        } else {
            this.setText("<none>");
            this.setImage(null);
            this.getTextControl().setToolTipText(null);
        }
    }

    protected String getButtonToolTip() {
        return "Select situation";
    }

    public long getSituationId() {
        return this.situationId;
    }
}

