/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.perfview.objecttabs.internal;

import java.util.Arrays;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.DciData;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.client.datacollection.GraphItemStyle;
import org.netxms.client.datacollection.PerfTabDci;
import org.netxms.ui.eclipse.charts.widgets.LineChart;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.perfview.PerfTabGraphSettings;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.widgets.DashboardComposite;

public class PerfTabGraph
extends DashboardComposite {
    private long nodeId;
    private PerfTabDci dci;
    private LineChart chart;
    private Runnable refreshTimer;
    private boolean updateInProgress = false;
    private NXCSession session;

    public PerfTabGraph(Composite parent, long nodeId, PerfTabDci dci, PerfTabGraphSettings settings) {
        super(parent, 2048);
        this.nodeId = nodeId;
        this.dci = dci;
        this.session = (NXCSession)ConsoleSharedData.getSession();
        this.setLayout((Layout)new FillLayout());
        this.chart = new LineChart((Composite)this, 0);
        this.chart.setZoomEnabled(false);
        this.chart.setTitleVisible(true);
        this.chart.setChartTitle(settings.getTitle().isEmpty() ? dci.getDescription() : settings.getTitle());
        this.chart.setLegendVisible(false);
        GraphItemStyle style = new GraphItemStyle(settings.getType(), settings.getColorAsInt(), 2, 0);
        this.chart.setItemStyles(Arrays.asList(style));
        this.chart.addParameter(new GraphItem(nodeId, dci.getId(), 0, 0, "", dci.getDescription()));
        final Display display = this.getDisplay();
        this.refreshTimer = new Runnable(){

            @Override
            public void run() {
                if (PerfTabGraph.this.isDisposed()) {
                    return;
                }
                PerfTabGraph.this.refreshData();
                display.timerExec(30000, (Runnable)this);
            }
        };
        display.timerExec(30000, this.refreshTimer);
        this.refreshData();
    }

    private void refreshData() {
        if (this.updateInProgress) {
            return;
        }
        this.updateInProgress = true;
        ConsoleJob job = new ConsoleJob("Get DCI values for history graph", null, "org.netxms.ui.eclipse.perfview", "org.netxms.ui.eclipse.perfview"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final Date from = new Date(System.currentTimeMillis() - 3600000L);
                final Date to = new Date(System.currentTimeMillis());
                final DciData data = PerfTabGraph.this.session.getCollectedData(PerfTabGraph.this.nodeId, PerfTabGraph.this.dci.getId(), from, to, 0);
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!PerfTabGraph.this.chart.isDisposed()) {
                            PerfTabGraph.this.chart.setTimeRange(from, to);
                            PerfTabGraph.this.chart.updateParameter(0, data, true);
                        }
                        PerfTabGraph.this.updateInProgress = false;
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot get DCI values for history graph";
            }

            protected void jobFailureHandler() {
                PerfTabGraph.this.updateInProgress = false;
                super.jobFailureHandler();
            }
        };
        job.setUser(false);
        job.start();
    }
}

