/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.propertypages;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.ui.eclipse.dashboard.widgets.internal.DialChartConfig;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class DialChart
extends PropertyPage {
    private DialChartConfig config;
    private LabeledText title;
    private Button checkShowTitle;
    private Button checkShowLegend;
    private Button checkLegendInside;
    private LabeledText minValue;
    private LabeledText maxValue;
    private LabeledText leftYellowZone;
    private LabeledText leftRedZone;
    private LabeledText rightYellowZone;
    private LabeledText rightRedZone;

    protected Control createContents(Composite parent) {
        this.config = (DialChartConfig)this.getElement().getAdapter(DialChartConfig.class);
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        dialogArea.setLayout((Layout)layout);
        this.title = new LabeledText(dialogArea, 0);
        this.title.setLabel("Title");
        this.title.setText(this.config.getTitle());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.title.setLayoutData((Object)gd);
        this.minValue = new LabeledText(dialogArea, 0);
        this.minValue.setLabel("Minimum value");
        this.minValue.setText(Double.toString(this.config.getMinValue()));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.minValue.setLayoutData((Object)gd);
        this.maxValue = new LabeledText(dialogArea, 0);
        this.maxValue.setLabel("Maximum value");
        this.maxValue.setText(Double.toString(this.config.getMaxValue()));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.maxValue.setLayoutData((Object)gd);
        this.leftRedZone = new LabeledText(dialogArea, 0);
        this.leftRedZone.setLabel("Left red zone end");
        this.leftRedZone.setText(Double.toString(this.config.getLeftRedZone()));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.leftRedZone.setLayoutData((Object)gd);
        this.leftYellowZone = new LabeledText(dialogArea, 0);
        this.leftYellowZone.setLabel("Left yellow zone end");
        this.leftYellowZone.setText(Double.toString(this.config.getLeftYellowZone()));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.leftYellowZone.setLayoutData((Object)gd);
        this.rightYellowZone = new LabeledText(dialogArea, 0);
        this.rightYellowZone.setLabel("Right yellow zone start");
        this.rightYellowZone.setText(Double.toString(this.config.getRightYellowZone()));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.rightYellowZone.setLayoutData((Object)gd);
        this.rightRedZone = new LabeledText(dialogArea, 0);
        this.rightRedZone.setLabel("Right red zone start");
        this.rightRedZone.setText(Double.toString(this.config.getRightRedZone()));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.rightRedZone.setLayoutData((Object)gd);
        this.checkShowTitle = new Button(dialogArea, 32);
        this.checkShowTitle.setText("Show &title");
        this.checkShowTitle.setSelection(this.config.isShowTitle());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.checkShowTitle.setLayoutData((Object)gd);
        this.checkShowLegend = new Button(dialogArea, 32);
        this.checkShowLegend.setText("Show &legend");
        this.checkShowLegend.setSelection(this.config.isShowLegend());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.checkShowLegend.setLayoutData((Object)gd);
        this.checkLegendInside = new Button(dialogArea, 32);
        this.checkLegendInside.setText("Place legend &inside dial");
        this.checkLegendInside.setSelection(this.config.isLegendInside());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.checkLegendInside.setLayoutData((Object)gd);
        return dialogArea;
    }

    public boolean performOk() {
        double rr;
        double ry;
        double lr;
        double ly;
        double max;
        double min;
        try {
            min = Double.parseDouble(this.minValue.getText().trim());
            max = Double.parseDouble(this.maxValue.getText().trim());
            ly = Double.parseDouble(this.leftYellowZone.getText().trim());
            lr = Double.parseDouble(this.leftRedZone.getText().trim());
            ry = Double.parseDouble(this.rightYellowZone.getText().trim());
            rr = Double.parseDouble(this.rightRedZone.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Warning", (String)"Please enter correct number");
            return false;
        }
        this.config.setTitle(this.title.getText());
        this.config.setMinValue(min);
        this.config.setMaxValue(max);
        this.config.setLeftYellowZone(ly);
        this.config.setLeftRedZone(lr);
        this.config.setRightYellowZone(ry);
        this.config.setRightRedZone(rr);
        this.config.setShowTitle(this.checkShowTitle.getSelection());
        this.config.setShowLegend(this.checkShowLegend.getSelection());
        this.config.setLegendInside(this.checkLegendInside.getSelection());
        return true;
    }
}

