/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.alarmviewer;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.netxms.api.client.Session;
import org.netxms.api.client.SessionListener;
import org.netxms.api.client.SessionNotification;
import org.netxms.client.NXCListener;
import org.netxms.client.NXCSession;
import org.netxms.client.events.Alarm;
import org.netxms.client.objects.GenericObject;
import org.netxms.ui.eclipse.alarmviewer.Messages;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class AlarmNotifier {
    private static NXCListener listener = null;

    public static void init() {
        listener = new NXCListener(){

            public void notificationHandler(SessionNotification n) {
                if (n.getCode() == 1004 || n.getCode() == 1005) {
                    AlarmNotifier.processNewAlarm((Alarm)n.getObject());
                }
            }
        };
        Session session = ConsoleSharedData.getSession();
        if (session != null) {
            session.addListener((SessionListener)listener);
        }
    }

    public static void stop() {
        Session session = ConsoleSharedData.getSession();
        if (session != null && listener != null) {
            session.removeListener((SessionListener)listener);
        }
    }

    private static void processNewAlarm(final Alarm alarm) {
        if (alarm.getState() != 0) {
            return;
        }
        final TrayItem trayIcon = ConsoleSharedData.getTrayIcon();
        if (trayIcon != null) {
            new UIJob("Create alarm popup"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    IWorkbenchWindow[] wl;
                    NXCSession session = (NXCSession)ConsoleSharedData.getSession();
                    GenericObject object = session.findObjectById(alarm.getSourceObjectId());
                    int severityFlag = alarm.getCurrentSeverity() == 0 ? 2 : (alarm.getCurrentSeverity() == 4 ? 1 : 8);
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (window == null && (wl = PlatformUI.getWorkbench().getWorkbenchWindows()).length > 0) {
                        window = wl[0];
                    }
                    if (window != null) {
                        ToolTip tip = new ToolTip(window.getShell(), 0x1000 | severityFlag);
                        tip.setText(String.valueOf(Messages.AlarmNotifier_ToolTip_Header) + StatusDisplayInfo.getStatusText((int)alarm.getCurrentSeverity()) + ")");
                        tip.setMessage(String.valueOf(object != null ? object.getObjectName() : Long.toString(alarm.getSourceObjectId())) + ": " + alarm.getMessage());
                        tip.setAutoHide(true);
                        trayIcon.setToolTip(tip);
                        tip.setVisible(true);
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }
}

