/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.agentmanager.views;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;
import org.netxms.ui.eclipse.agentmanager.views.helpers.DeploymentStatus;
import org.netxms.ui.eclipse.agentmanager.views.helpers.DeploymentStatusComparator;
import org.netxms.ui.eclipse.agentmanager.views.helpers.DeploymentStatusLabelProvider;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class PackageDeploymentMonitor
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.agentmanager.views.PackageDeploymentMonitor";
    public static final int COLUMN_NODE = 0;
    public static final int COLUMN_STATUS = 1;
    public static final int COLUMN_ERROR = 2;
    private SortableTableViewer viewer;
    private Map<Long, DeploymentStatus> statusList = new HashMap<Long, DeploymentStatus>();

    public void createPartControl(Composite parent) {
        String[] names = new String[]{"Node", "Status", "Message"};
        int[] widths = new int[]{200, 110, 400};
        this.viewer = new SortableTableViewer(parent, names, widths, 0, 1024, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new DeploymentStatusLabelProvider());
        this.viewer.setComparator((ViewerComparator)new DeploymentStatusComparator());
    }

    public void setFocus() {
        this.viewer.getTable().setFocus();
    }

    public void statusUpdate(final long nodeId, final int status, final String message) {
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                DeploymentStatus s = (DeploymentStatus)PackageDeploymentMonitor.this.statusList.get(nodeId);
                if (s == null) {
                    s = new DeploymentStatus(nodeId, status, message);
                    PackageDeploymentMonitor.this.statusList.put(nodeId, s);
                    PackageDeploymentMonitor.this.viewer.setInput((Object)PackageDeploymentMonitor.this.statusList.values().toArray());
                } else {
                    s.setStatus(status);
                    s.setMessage(message);
                    PackageDeploymentMonitor.this.viewer.update((Object)s, null);
                }
            }
        });
    }
}

