/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.logviewer.views;

import java.util.Collection;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.AccessListElement;
import org.netxms.client.NXCSession;
import org.netxms.client.log.Log;
import org.netxms.client.log.LogColumn;
import org.netxms.client.log.LogFilter;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.logviewer.Activator;
import org.netxms.ui.eclipse.logviewer.Messages;
import org.netxms.ui.eclipse.logviewer.dialogs.QueryBuilder;
import org.netxms.ui.eclipse.logviewer.views.helpers.LogLabelProvider;
import org.netxms.ui.eclipse.logviewer.widgets.FilterBuilder;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.shared.SharedIcons;

public class LogViewer
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.logviewer.view.log_viewer";
    public static final String JOB_FAMILY = "LogViewerJob";
    private static final int PAGE_SIZE = 400;
    private static final int FIRST_PAGE = 0;
    private static final int LAST_PAGE = 255;
    private static final int PREV_PAGE = -1;
    private static final int NEXT_PAGE = 1;
    private NXCSession session;
    private FilterBuilder filterBuilder;
    private TableViewer viewer;
    private String logName;
    private Log logHandle;
    private LogFilter filter;
    private Image titleImage = null;
    private RefreshAction actionRefresh;
    private Action actionExecute;
    private Action actionClearFilter;
    private Action actionShowFilter;
    private Action actionGoFirstPage;
    private Action actionGoLastPage;
    private Action actionGoNextPage;
    private Action actionGoPrevPage;
    private org.netxms.client.Table resultSet;
    private long currentPosition;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.session = (NXCSession)ConsoleSharedData.getSession();
        this.logName = site.getSecondaryId();
        this.setPartName(Messages.getString("LogViewer_" + this.logName));
        ImageDescriptor img = Activator.getImageDescriptor("icons/" + this.logName + ".png");
        if (img != null) {
            this.titleImage = img.createImage();
            this.setTitleImage(this.titleImage);
        }
        this.filter = new LogFilter();
        Platform.getAdapterManager().loadAdapter((Object)new AccessListElement(0L, 0), "org.eclipse.ui.model.IWorkbenchAdapter");
    }

    public void createPartControl(Composite parent) {
        FormLayout layout = new FormLayout();
        parent.setLayout((Layout)layout);
        this.filterBuilder = new FilterBuilder(parent, 0);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        this.filterBuilder.setLayoutData(gd);
        this.viewer = new TableViewer(parent, 65538);
        Table table = this.viewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        this.viewer.getControl().setLayoutData((Object)gd);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.filterBuilder);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        table.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.filterBuilder.setLayoutData(fd);
        this.makeActions();
        this.contributeToActionBars();
        new ConsoleJob("Open log \"" + this.logName + "\"", (IWorkbenchPart)this, "org.netxms.ui.eclipse.logviewer", JOB_FAMILY){

            protected String getErrorMessage() {
                return "Cannot open server log file \"" + LogViewer.this.logName + "\"";
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                LogViewer.this.logHandle = LogViewer.this.session.openServerLog(LogViewer.this.logName);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        LogViewer.this.setupLogViewer();
                    }
                });
            }
        }.start();
        this.activateContext();
        this.filterBuilder.setExecuteAction(this.actionExecute);
        this.filterBuilder.setCloseAction(new Action(){

            public void run() {
                LogViewer.this.actionShowFilter.setChecked(false);
                LogViewer.this.showFilter(false);
            }
        });
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext("org.netxms.ui.eclipse.logviewer.context.LogViewer");
        }
    }

    private int estimateColumnWidth(LogColumn lc) {
        switch (lc.getType()) {
            case 6: {
                return 80;
            }
            case 5: {
                return 120;
            }
            case 1: {
                return 100;
            }
            case 2: {
                return 150;
            }
            case 0: {
                return 250;
            }
        }
        return 100;
    }

    private void setupLogViewer() {
        Table table = this.viewer.getTable();
        Collection columns = this.logHandle.getColumns();
        for (LogColumn lc : columns) {
            TableColumn column = new TableColumn(table, 16384);
            column.setText(lc.getDescription());
            column.setData((Object)lc);
            column.setWidth(this.estimateColumnWidth(lc));
        }
        this.viewer.setLabelProvider((IBaseLabelProvider)new LogLabelProvider(this.logHandle));
        this.filterBuilder.setLogHandle(this.logHandle);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionExecute);
        manager.add((IAction)this.actionClearFilter);
        manager.add((IAction)this.actionShowFilter);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionGoFirstPage);
        manager.add((IAction)this.actionGoPrevPage);
        manager.add((IAction)this.actionGoNextPage);
        manager.add((IAction)this.actionGoLastPage);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionGoFirstPage);
        manager.add((IAction)this.actionGoPrevPage);
        manager.add((IAction)this.actionGoNextPage);
        manager.add((IAction)this.actionGoLastPage);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionExecute);
        manager.add((IAction)this.actionClearFilter);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void makeActions() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        this.actionRefresh = new RefreshAction(){

            public void run() {
            }
        };
        this.actionExecute = new Action("&Execute query", SharedIcons.EXECUTE){

            public void run() {
                LogViewer.this.doQuery();
            }
        };
        this.actionClearFilter = new Action("&Clear filter", SharedIcons.CLEAR_LOG){

            public void run() {
                LogViewer.this.filterBuilder.clearFilter();
            }
        };
        this.actionGoFirstPage = new Action("&First page", Activator.getImageDescriptor("icons/first_page.png")){

            public void run() {
                LogViewer.this.goToPage(0);
            }
        };
        this.actionGoLastPage = new Action("&Last page", Activator.getImageDescriptor("icons/last_page.png")){

            public void run() {
                LogViewer.this.goToPage(255);
            }
        };
        this.actionGoNextPage = new Action("&Next page", Activator.getImageDescriptor("icons/next_page.png")){

            public void run() {
                LogViewer.this.goToPage(1);
            }
        };
        this.actionGoPrevPage = new Action("&Previous page", Activator.getImageDescriptor("icons/prev_page.png")){

            public void run() {
                LogViewer.this.goToPage(-1);
            }
        };
        this.actionShowFilter = new Action("Show &filter", 2){

            public void run() {
                LogViewer.this.showFilter(LogViewer.this.actionShowFilter.isChecked());
            }
        };
        this.actionShowFilter.setChecked(true);
        this.actionShowFilter.setActionDefinitionId("org.netxms.ui.eclipse.logviewer.commands.show_filter");
        handlerService.activateHandler(this.actionShowFilter.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionShowFilter));
    }

    private void doQuery() {
        QueryBuilder dlg = new QueryBuilder(this.getSite().getShell(), this.logHandle, this.filter);
        if (dlg.open() == 0) {
            this.filter = dlg.getFilter();
            new ConsoleJob("Query server log", (IWorkbenchPart)this, "org.netxms.ui.eclipse.logviewer", JOB_FAMILY){

                protected String getErrorMessage() {
                    return "Cannot query server log " + LogViewer.this.logName;
                }

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    LogViewer.this.logHandle.query(LogViewer.this.filter);
                    LogViewer.this.currentPosition = 0L;
                    LogViewer.this.resultSet = LogViewer.this.logHandle.retrieveData(LogViewer.this.currentPosition, 400L);
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            LogViewer.this.viewer.setInput((Object)LogViewer.this.resultSet.getAllRows());
                        }
                    });
                }
            }.start();
        }
    }

    private void goToPage(int page) {
        switch (page) {
            case 0: {
                this.currentPosition = 0L;
                break;
            }
            case 255: {
                this.currentPosition = this.logHandle.getNumRecords() - 400L;
                if (this.currentPosition >= 0L) break;
                this.currentPosition = 0L;
                break;
            }
            case 1: {
                if (this.logHandle.getNumRecords() - this.currentPosition <= 400L) break;
                this.currentPosition += 400L;
                break;
            }
            case -1: {
                this.currentPosition -= 400L;
                if (this.currentPosition >= 0L) break;
                this.currentPosition = 0L;
            }
        }
        new ConsoleJob("Get log page from server", (IWorkbenchPart)this, "org.netxms.ui.eclipse.logviewer", JOB_FAMILY){

            protected String getErrorMessage() {
                return "Cannot query server log " + LogViewer.this.logName;
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                LogViewer.this.resultSet = LogViewer.this.logHandle.retrieveData(LogViewer.this.currentPosition, 400L);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        LogViewer.this.viewer.setInput((Object)LogViewer.this.resultSet.getAllRows());
                    }
                });
            }
        }.start();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void dispose() {
        if (this.titleImage != null) {
            this.titleImage.dispose();
        }
        super.dispose();
    }

    private void showFilter(boolean show) {
        this.filterBuilder.setVisible(show);
        FormData fd = (FormData)this.viewer.getTable().getLayoutData();
        fd.top = show ? new FormAttachment((Control)this.filterBuilder) : new FormAttachment(0, 0);
        this.viewer.getTable().getParent().layout();
        if (show) {
            this.filterBuilder.setFocus();
        }
    }
}

