/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.logviewer.widgets;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.netxms.client.log.ColumnFilter;
import org.netxms.client.log.LogColumn;
import org.netxms.ui.eclipse.logviewer.widgets.helpers.FilterTreeElement;
import org.netxms.ui.eclipse.shared.SharedIcons;
import org.netxms.ui.eclipse.widgets.DashboardComposite;

public class ColumnFilterEditor
extends DashboardComposite {
    private LogColumn column;
    private FilterTreeElement columnElement;

    public ColumnFilterEditor(Composite parent, int style, LogColumn column, FilterTreeElement columnElement, final Runnable deleteHandler) {
        super(parent, style);
        this.column = column;
        this.columnElement = columnElement;
        GridLayout layout = new GridLayout();
        this.setLayout((Layout)layout);
        Composite header = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 3;
        header.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        header.setLayoutData((Object)gd);
        Label title = new Label(header, 0);
        title.setText(column.getDescription());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        title.setLayoutData((Object)gd);
        ImageHyperlink link = new ImageHyperlink(header, 0);
        link.setImage(SharedIcons.IMG_ADD_OBJECT);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ColumnFilterEditor.this.addElement(ColumnFilterEditor.this.columnElement);
            }
        });
        link = new ImageHyperlink(header, 0);
        link.setImage(SharedIcons.IMG_DELETE_OBJECT);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                deleteHandler.run();
            }
        });
    }

    private void addElement(FilterTreeElement currentElement) {
        boolean isGroup = false;
        if (currentElement.getType() == 2 && ((ColumnFilter)currentElement.getObject()).getType() == 2) {
            isGroup = true;
        }
        if (currentElement.hasChilds() && !isGroup) {
            this.addGroup(currentElement);
        } else {
            this.addCondition(currentElement);
        }
    }

    private void addGroup(FilterTreeElement currentElement) {
    }

    private void addCondition(FilterTreeElement currentElement) {
        switch (this.column.getType()) {
            case 2: {
                break;
            }
        }
    }
}

