/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.logviewer.widgets.helpers;

import java.util.ArrayList;
import org.netxms.ui.eclipse.logviewer.widgets.ColumnFilterEditor;

public class FilterTreeElement {
    public static final int ROOT = 0;
    public static final int COLUMN = 1;
    public static final int FILTER = 2;
    private int type;
    private Object object;
    private FilterTreeElement parent;
    private ArrayList<FilterTreeElement> childs;
    private ColumnFilterEditor editor;

    public FilterTreeElement(int type, Object object, FilterTreeElement parent) {
        this.type = type;
        this.object = object;
        this.parent = parent;
        this.childs = new ArrayList();
        if (parent != null) {
            parent.addChild(this);
        }
    }

    public int getType() {
        return this.type;
    }

    public Object getObject() {
        return this.object;
    }

    public FilterTreeElement getParent() {
        return this.parent;
    }

    public FilterTreeElement[] getChilds() {
        return this.childs.toArray(new FilterTreeElement[this.childs.size()]);
    }

    public boolean hasChilds() {
        return this.childs.size() > 0;
    }

    public int getNumChilds() {
        return this.childs.size();
    }

    public void addChild(FilterTreeElement element) {
        this.childs.add(element);
    }

    public void removeChild(FilterTreeElement element) {
        this.childs.remove(element);
    }

    public void changeParent(FilterTreeElement newParent) {
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
        this.parent = newParent;
        if (this.parent != null) {
            this.parent.addChild(this);
        }
    }

    public ColumnFilterEditor getEditor() {
        return this.editor;
    }

    public void setEditor(ColumnFilterEditor editor) {
        this.editor = editor;
    }
}

