/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.epp.dialogs;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.netxms.client.situations.Situation;
import org.netxms.ui.eclipse.epp.Activator;
import org.netxms.ui.eclipse.epp.SituationCache;
import org.netxms.ui.eclipse.epp.dialogs.helpers.SituationComparator;
import org.netxms.ui.eclipse.epp.dialogs.helpers.SituationLabelProvider;
import org.netxms.ui.eclipse.epp.dialogs.helpers.SituationListFilter;

public class SituationSelectionDialog
extends Dialog {
    private boolean multiSelection;
    private Text filterText;
    private TableViewer viewer;
    private Situation[] selectedSituations;
    private SituationListFilter filter;

    public SituationSelectionDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Select Situation");
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        try {
            newShell.setSize(settings.getInt("SelectSituation.cx"), settings.getInt("SelectSituation.cy"));
        }
        catch (NumberFormatException numberFormatException) {}
    }

    protected Control createDialogArea(Composite parent) {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.horizontalSpacing = 4;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        new Label(dialogArea, 0).setText("Filter:");
        this.filterText = new Text(dialogArea, 0);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.filterText.setLayoutData((Object)gd);
        String filterString = settings.get("SelectSituation.Filter");
        if (filterString != null) {
            this.filterText.setText(filterString);
        }
        this.viewer = new TableViewer(dialogArea, 0x10800 | (this.multiSelection ? 2 : 4) | 0x100 | 0x200);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setComparator((ViewerComparator)new SituationComparator());
        this.viewer.setLabelProvider((IBaseLabelProvider)new SituationLabelProvider());
        this.filter = new SituationListFilter();
        if (filterString != null) {
            this.filter.setFilterString(filterString);
        }
        this.viewer.addFilter((ViewerFilter)this.filter);
        this.viewer.setInput((Object)SituationCache.getAllSituations());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 2;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 450;
        this.viewer.getTable().setLayoutData((Object)gd);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SituationSelectionDialog.this.filter.setFilterString(SituationSelectionDialog.this.filterText.getText());
                SituationSelectionDialog.this.viewer.refresh();
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SituationSelectionDialog.this.okPressed();
            }
        });
        return dialogArea;
    }

    protected void cancelPressed() {
        this.saveSettings();
        super.cancelPressed();
    }

    protected void okPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        List list = selection.toList();
        this.selectedSituations = list.toArray(new Situation[list.size()]);
        this.saveSettings();
        super.okPressed();
    }

    private void saveSettings() {
        Point size = this.getShell().getSize();
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        settings.put("SelectSituation.cx", size.x);
        settings.put("SelectSituation.cy", size.y);
        settings.put("SelectSituation.Filter", this.filterText.getText());
    }

    public boolean isMultiSelectionEnabled() {
        return this.multiSelection;
    }

    public void enableMultiSelection(boolean enable) {
        this.multiSelection = enable;
    }

    public Situation[] getSelectedSituations() {
        return this.selectedSituations;
    }
}

