/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.epp.views;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.netxms.api.client.SessionListener;
import org.netxms.api.client.SessionNotification;
import org.netxms.client.NXCSession;
import org.netxms.client.situations.Situation;
import org.netxms.client.situations.SituationInstance;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.epp.Activator;
import org.netxms.ui.eclipse.epp.SituationCache;
import org.netxms.ui.eclipse.epp.views.helpers.SituationTreeContentProvider;
import org.netxms.ui.eclipse.epp.views.helpers.SituationTreeLabelProvider;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.shared.SharedIcons;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class SituationsManager
extends ViewPart
implements SessionListener {
    public static final String ID = "org.netxms.ui.eclipse.epp.views.SituationsManager";
    private NXCSession session;
    private Map<Long, Situation> situations = new HashMap<Long, Situation>();
    private TreeViewer situationTree;
    private SortableTableViewer details;
    private Action actionRefresh;
    private Action actionCreate;
    private Action actionDelete;

    public void init(IViewSite site) throws PartInitException {
        this.session = (NXCSession)ConsoleSharedData.getSession();
        super.init(site);
    }

    public void createPartControl(Composite parent) {
        SashForm splitter = new SashForm(parent, 256);
        this.situationTree = new TreeViewer((Composite)splitter, 2050);
        this.situationTree.setContentProvider((IContentProvider)new SituationTreeContentProvider());
        this.situationTree.setLabelProvider((IBaseLabelProvider)new SituationTreeLabelProvider());
        String[] names = new String[]{"Attribute", "Value"};
        int[] widths = new int[]{150, 150};
        this.details = new SortableTableViewer((Composite)splitter, names, widths, 0, 128, 67584);
        this.details.getTable().setHeaderVisible(true);
        this.details.getTable().setLinesVisible(true);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.details, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"SituationInstanceDetails");
        this.details.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTableViewerSettings((SortableTableViewer)SituationsManager.this.details, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"SituationInstanceDetails");
            }
        });
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.session.addListener((SessionListener)this);
        new ConsoleJob("Load situations configuration", (IWorkbenchPart)this, "org.netxms.ui.eclipse.epp", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List list = SituationsManager.this.session.getSituations();
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        for (Situation s : list) {
                            SituationsManager.this.situations.put(s.getId(), s);
                        }
                        SituationsManager.this.situationTree.setInput((Object)SituationsManager.this.situations);
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot load situations configuration";
            }

            protected void jobFailureHandler() {
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().hideView((IViewPart)SituationsManager.this);
                    }
                });
            }
        }.start();
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction(){

            public void run() {
                SituationsManager.this.situationTree.setInput((Object)SituationCache.getAllSituations());
            }
        };
        this.actionCreate = new Action("&Create..."){

            public void run() {
                SituationsManager.this.createSituation();
            }
        };
        this.actionDelete = new Action("&Delete"){

            public void run() {
                SituationsManager.this.deleteSelectedElements();
            }
        };
        this.actionDelete.setImageDescriptor(SharedIcons.DELETE_OBJECT);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionCreate);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionRefresh);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                SituationsManager.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.situationTree.getControl());
        this.situationTree.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.situationTree);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionCreate);
        manager.add((IAction)this.actionDelete);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("additions"));
    }

    public void setFocus() {
        this.situationTree.getTree().setFocus();
    }

    private void createSituation() {
        InputDialog dlg = new InputDialog(this.getSite().getShell(), "Create Situation", "Name for new situation object", "", new IInputValidator(){

            public String isValid(String newText) {
                if (newText.trim().isEmpty()) {
                    return "Situation name cannot be empty";
                }
                return null;
            }
        });
        if (dlg.open() == 0) {
            final String name = dlg.getValue().trim();
            new ConsoleJob("Create situation object", (IWorkbenchPart)this, "org.netxms.ui.eclipse.epp", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    SituationsManager.this.session.createSituation(name, "");
                }

                protected String getErrorMessage() {
                    return "Cannot create new situation object";
                }
            }.start();
        }
    }

    private void deleteSelectedElements() {
        IStructuredSelection selection = (IStructuredSelection)this.situationTree.getSelection();
        final Object[] elements = selection.toArray();
        new ConsoleJob("Delete situation objects", (IWorkbenchPart)this, "org.netxms.ui.eclipse.epp", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                Object[] objectArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    if (o instanceof Situation) {
                        SituationsManager.this.session.deleteSituation(((Situation)o).getId());
                    } else if (o instanceof SituationInstance) {
                        SituationsManager.this.session.deleteSituationInstance(((SituationInstance)o).getParent().getId(), ((SituationInstance)o).getName());
                    }
                    ++n2;
                }
            }

            protected String getErrorMessage() {
                return "Cannot delete situation object";
            }
        }.start();
    }

    public void notificationHandler(final SessionNotification n) {
        if (n.getCode() == 101 || n.getCode() == 103 || n.getCode() == 102) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    switch (n.getCode()) {
                        case 101: 
                        case 103: {
                            SituationsManager.this.situations.put(n.getSubCode(), (Situation)n.getObject());
                            break;
                        }
                        case 102: {
                            SituationsManager.this.situations.remove(n.getSubCode());
                        }
                    }
                    SituationsManager.this.situationTree.refresh();
                }
            });
        }
    }

    public void dispose() {
        this.session.removeListener((SessionListener)this);
        super.dispose();
    }
}

