/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.reporter.widgets;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.Report;
import org.netxms.client.reports.ReportRenderFormat;
import org.netxms.client.reports.ReportResult;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.reporter.Activator;
import org.netxms.ui.eclipse.reporter.widgets.FieldEditor;
import org.netxms.ui.eclipse.reporter.widgets.ObjectFieldEditor;
import org.netxms.ui.eclipse.reporter.widgets.ObjectListFieldEditor;
import org.netxms.ui.eclipse.reporter.widgets.StringFieldEditor;
import org.netxms.ui.eclipse.reporter.widgets.TimestampFieldEditor;
import org.netxms.ui.eclipse.reporter.widgets.helpers.ReportDefinition;
import org.netxms.ui.eclipse.reporter.widgets.helpers.ReportParameter;
import org.netxms.ui.eclipse.reporter.widgets.helpers.ReportResultLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.shared.SharedIcons;
import org.netxms.ui.eclipse.tools.ImageCache;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class ReportExecutionForm
extends Composite {
    private IWorkbenchPart workbenchPart = null;
    private Report report;
    private FormToolkit toolkit;
    private ScrolledForm form;
    private List<FieldEditor> fields = new ArrayList<FieldEditor>();
    private List<ReportParameter> parameters;
    private SortableTableViewer resultList;
    private ImageCache imageCache;

    public ReportExecutionForm(Composite parent, int style, Report report) {
        super(parent, style);
        this.report = report;
        this.imageCache = new ImageCache((Control)this);
        this.setLayout((Layout)new FillLayout());
        this.toolkit = new FormToolkit(this.getDisplay());
        this.form = this.toolkit.createScrolledForm((Composite)this);
        this.form.setText(report.getObjectName());
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        this.form.getBody().setLayout((Layout)layout);
        if (!report.getComments().isEmpty()) {
            this.toolkit.createLabel(this.form.getBody(), report.getComments(), 64);
        }
        Section section = this.toolkit.createSection(this.form.getBody(), 384);
        section.setText("Parameters");
        section.setDescription("Provide parameters necessary to run this report in fields below");
        TableWrapData td = new TableWrapData();
        td.align = 128;
        td.grabHorizontal = true;
        td.colspan = 2;
        section.setLayoutData((Object)td);
        Composite paramArea = this.toolkit.createComposite((Composite)section);
        layout = new TableWrapLayout();
        layout.numColumns = 2;
        paramArea.setLayout((Layout)layout);
        section.setClient((Control)paramArea);
        this.createParamEntryFields(paramArea);
        section = this.toolkit.createSection(this.form.getBody(), 384);
        section.setText("Actions");
        section.setDescription("Select desired action from the list below");
        td = new TableWrapData();
        td.align = 128;
        td.grabHorizontal = true;
        section.setLayoutData((Object)td);
        Composite actionArea = this.toolkit.createComposite((Composite)section);
        layout = new TableWrapLayout();
        actionArea.setLayout((Layout)layout);
        section.setClient((Control)actionArea);
        ImageHyperlink link = this.toolkit.createImageHyperlink(actionArea, 64);
        link.setImage(SharedIcons.IMG_EXECUTE);
        link.setText("Execute report");
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ReportExecutionForm.this.executeReport();
            }
        });
        link = this.toolkit.createImageHyperlink(actionArea, 64);
        link.setImage(this.imageCache.add(Activator.getImageDescriptor("icons/schedule.png")));
        link.setText("Schedule report execution");
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
            }
        });
        section = this.toolkit.createSection(this.form.getBody(), 384);
        section.setText("Results");
        section.setDescription("The following execution results are available for rendering");
        td = new TableWrapData();
        td.align = 128;
        td.grabHorizontal = true;
        td.grabVertical = true;
        section.setLayoutData((Object)td);
        Composite resultArea = this.toolkit.createComposite((Composite)section);
        layout = new TableWrapLayout();
        resultArea.setLayout((Layout)layout);
        section.setClient((Control)resultArea);
        this.createResultsSection(resultArea);
        this.refreshResultList();
    }

    private void createParamEntryFields(Composite parent) {
        try {
            ReportDefinition definition = ReportDefinition.createFromXml(this.report.getDefinition());
            this.parameters = definition.getParameters();
            for (ReportParameter p : this.parameters) {
                FieldEditor editor;
                switch (p.getDataType()) {
                    case 0: {
                        editor = new StringFieldEditor(p, this.toolkit, parent);
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        editor = new TimestampFieldEditor(p, this.toolkit, parent);
                        break;
                    }
                    case 2: {
                        editor = new ObjectFieldEditor(p, this.toolkit, parent);
                        break;
                    }
                    case 4: {
                        editor = new ObjectListFieldEditor(p, this.toolkit, parent);
                        break;
                    }
                    default: {
                        editor = new StringFieldEditor(p, this.toolkit, parent);
                    }
                }
                TableWrapData td = new TableWrapData();
                td.align = 128;
                td.grabHorizontal = true;
                td.colspan = p.getColumnSpan();
                editor.setLayoutData(td);
                this.fields.add(editor);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createResultsSection(Composite parent) {
        GridLayout layout = new GridLayout();
        parent.setLayout((Layout)layout);
        ImageHyperlink link = this.toolkit.createImageHyperlink(parent, 64);
        link.setImage(SharedIcons.IMG_REFRESH);
        link.setText("Refresh");
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ReportExecutionForm.this.refreshResultList();
            }
        });
        GridData gd = new GridData();
        gd.horizontalAlignment = 131072;
        link.setLayoutData((Object)gd);
        String[] names = new String[]{"Job ID", "Execution Time"};
        int[] widths = new int[]{90, 160};
        this.resultList = new SortableTableViewer(parent, names, widths, 0, 1024, 67586);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.resultList.getControl().setLayoutData((Object)gd);
        this.resultList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.resultList.setLabelProvider((IBaseLabelProvider)new ReportResultLabelProvider());
        link = this.toolkit.createImageHyperlink(parent, 64);
        link.setImage(this.imageCache.add(Activator.getImageDescriptor("icons/pdf.png")));
        link.setText("Render to PDF");
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ReportResult firstElement = (ReportResult)((IStructuredSelection)ReportExecutionForm.this.resultList.getSelection()).getFirstElement();
                if (firstElement != null) {
                    ReportExecutionForm.this.renderReport(firstElement.getJobId(), firstElement.getExecutionTime(), ReportRenderFormat.PDF);
                }
            }
        });
        link = this.toolkit.createImageHyperlink(parent, 64);
        link.setImage(SharedIcons.IMG_DELETE_OBJECT);
        link.setText("Delete");
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ReportExecutionForm.this.deleteResults();
            }
        });
    }

    private void renderReport(final long jobId, Date executeTime, final ReportRenderFormat format) {
        StringBuilder nameTemplate = new StringBuilder();
        nameTemplate.append(this.report.getObjectName());
        nameTemplate.append(" ");
        nameTemplate.append(new SimpleDateFormat("ddMMyyyy HHmm").format(executeTime));
        nameTemplate.append(".");
        nameTemplate.append(format.getExtension());
        FileDialog fileDialog = new FileDialog(this.getShell(), 8192);
        fileDialog.setFilterNames(new String[]{"PDF Files", "All Files"});
        fileDialog.setFilterExtensions(new String[]{"*.pdf", "*.*"});
        fileDialog.setFileName(nameTemplate.toString());
        final String fileName = fileDialog.open();
        if (fileName != null) {
            new ConsoleJob("Rendering report", this.workbenchPart, "org.netxms.ui.eclipse.reporter", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    NXCSession session = (NXCSession)ConsoleSharedData.getSession();
                    File reportFile = session.renderReport(jobId, format);
                    FileInputStream inputStream = null;
                    FileOutputStream outputStream = null;
                    try {
                        inputStream = new FileInputStream(reportFile);
                        outputStream = new FileOutputStream(fileName);
                        byte[] buffer = new byte[1024];
                        int size = 0;
                        do {
                            if ((size = inputStream.read(buffer)) <= 0) continue;
                            outputStream.write(buffer, 0, size);
                        } while (size == buffer.length);
                        outputStream.close();
                        outputStream = null;
                        ReportExecutionForm.this.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                ReportExecutionForm.this.openReport(fileName, format);
                            }
                        });
                    }
                    finally {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        if (outputStream != null) {
                            outputStream.close();
                        }
                    }
                }

                protected String getErrorMessage() {
                    return "Cannot render report " + ReportExecutionForm.this.report.getObjectName() + " job " + jobId;
                }
            }.start();
        }
    }

    private void executeReport() {
        final HashMap<String, String> execParameters = new HashMap<String, String>();
        if (this.parameters != null) {
            int i = 0;
            while (i < this.parameters.size()) {
                execParameters.put(this.parameters.get(i).getName(), this.fields.get(i).getValue());
                ++i;
            }
        }
        new ConsoleJob("Execute report", this.workbenchPart, "org.netxms.ui.eclipse.reporter", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                NXCSession session = (NXCSession)ConsoleSharedData.getSession();
                final long jobId = session.executeReport(ReportExecutionForm.this.report.getObjectId(), execParameters);
                ReportExecutionForm.this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openInformation((Shell)ReportExecutionForm.this.getShell(), (String)"Report Execution", (String)("Report " + ReportExecutionForm.this.report.getObjectName() + " execution started successfully. Job ID is " + jobId + "."));
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot execute report " + ReportExecutionForm.this.report.getObjectName();
            }
        }.start();
    }

    public void setWorkbenchPart(IWorkbenchPart workbenchPart) {
        this.workbenchPart = workbenchPart;
    }

    private void refreshResultList() {
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        new ConsoleJob("Refresh result list for report " + this.report.getObjectName(), this.workbenchPart, "org.netxms.ui.eclipse.reporter", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List results = session.getReportResults(ReportExecutionForm.this.report.getObjectId());
                ReportExecutionForm.this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (ReportExecutionForm.this.isDisposed()) {
                            return;
                        }
                        ReportExecutionForm.this.resultList.setInput((Object)results.toArray());
                        ReportExecutionForm.this.getParent().layout(true, true);
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot get result list for report " + ReportExecutionForm.this.report.getObjectName();
            }
        }.start();
    }

    private void openReport(String fileName, ReportRenderFormat format) {
        Program p = Program.findProgram((String)format.getExtension());
        if (p != null) {
            p.execute(fileName);
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Report was rendered successfully, but external viewer cannot be opened");
        }
    }

    private void deleteResults() {
        IStructuredSelection selection = (IStructuredSelection)this.resultList.getSelection();
        if (selection.size() == 0) {
            return;
        }
        if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)"Delete Report Results", (String)"Do you really want to delete selected results?")) {
            return;
        }
        final ArrayList<Long> resultIdList = new ArrayList<Long>(selection.size());
        for (Object o : selection.toList()) {
            resultIdList.add(((ReportResult)o).getJobId());
        }
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        new ConsoleJob("Delete report execution results", this.workbenchPart, "org.netxms.ui.eclipse.reporter", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.deleteReportResults(ReportExecutionForm.this.report.getObjectId(), (Collection)resultIdList);
                ReportExecutionForm.this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!ReportExecutionForm.this.isDisposed()) {
                            ReportExecutionForm.this.refreshResultList();
                        }
                    }
                });
            }

            protected String getErrorMessage() {
                return null;
            }
        }.start();
    }
}

