/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.reporter.widgets;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.netxms.ui.eclipse.reporter.widgets.FieldEditor;
import org.netxms.ui.eclipse.reporter.widgets.helpers.ReportParameter;

public class TimestampFieldEditor
extends FieldEditor {
    private DateTime datePicker;
    private DateTime timePicker;

    public TimestampFieldEditor(ReportParameter parameter, FormToolkit toolkit, Composite parent) {
        super(parameter, toolkit, parent);
    }

    @Override
    protected void createContent(Composite parent) {
        Date date;
        Composite area = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 2;
        area.setLayout((Layout)layout);
        try {
            date = new Date(Long.parseLong(this.parameter.getDefaultValue()) * 1000L);
        }
        catch (NumberFormatException numberFormatException) {
            date = new Date();
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        this.datePicker = new DateTime(area, 36);
        this.datePicker.setDate(c.get(1), c.get(2), c.get(5));
        if (this.parameter.getDataType() == 5) {
            this.timePicker = new DateTime(area, 128);
            this.timePicker.setTime(c.get(11), c.get(12), c.get(13));
        }
    }

    @Override
    public String getValue() {
        Calendar c = Calendar.getInstance();
        c.clear();
        switch (this.parameter.getDataType()) {
            case 5: {
                c.set(this.datePicker.getYear(), this.datePicker.getMonth(), this.datePicker.getDay(), this.timePicker.getHours(), this.timePicker.getMinutes(), this.timePicker.getSeconds());
                break;
            }
            case 6: {
                c.set(this.datePicker.getYear(), this.datePicker.getMonth(), this.datePicker.getDay(), 0, 0, 0);
                break;
            }
            case 7: {
                c.set(this.datePicker.getYear(), this.datePicker.getMonth(), this.datePicker.getDay(), 23, 59, 59);
            }
        }
        return Long.toString(c.getTimeInMillis() / 1000L);
    }
}

