/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.actions;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.objects.ServiceRoot;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class BindObject
implements IObjectActionDelegate {
    private Shell shell;
    private ViewPart viewPart;
    private long parentId;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
        this.viewPart = targetPart instanceof ViewPart ? (ViewPart)targetPart : null;
    }

    public void run(IAction action) {
        final ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.shell, null, ObjectSelectionDialog.createNodeSelectionFilter());
        if (dlg.open() == 0) {
            final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
            new ConsoleJob("Bind object", (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.objectmanager", null){

                protected String getErrorMessage() {
                    return "Cannot create object binding";
                }

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    List objects = dlg.getSelectedObjects();
                    for (GenericObject o : objects) {
                        session.bindObject(BindObject.this.parentId, o.getObjectId());
                    }
                }
            }.start();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
            Object obj = ((IStructuredSelection)selection).getFirstElement();
            if (obj instanceof ServiceRoot || obj instanceof Container) {
                action.setEnabled(true);
                this.parentId = ((GenericObject)obj).getObjectId();
            } else {
                action.setEnabled(false);
                this.parentId = 0L;
            }
        } else {
            action.setEnabled(false);
            this.parentId = 0L;
        }
    }
}

