/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.netxms.client.AgentParameter;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.GenericObject;
import org.netxms.ui.eclipse.datacollection.Activator;
import org.netxms.ui.eclipse.datacollection.dialogs.IParameterSelectionDialog;
import org.netxms.ui.eclipse.datacollection.dialogs.helpers.AgentParameterComparator;
import org.netxms.ui.eclipse.datacollection.dialogs.helpers.AgentParameterFilter;
import org.netxms.ui.eclipse.datacollection.dialogs.helpers.AgentParameterLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public abstract class AbstractSelectParamDlg
extends Dialog
implements IParameterSelectionDialog {
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_TYPE = 1;
    public static final int COLUMN_DESCRIPTION = 2;
    protected GenericObject object;
    protected Text filterText;
    protected SortableTableViewer viewer;
    private AgentParameter selectedParameter;
    private AgentParameterFilter filter;

    public AbstractSelectParamDlg(Shell parentShell, long nodeId) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.object = ((NXCSession)ConsoleSharedData.getSession()).findObjectById(nodeId);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Parameter Selection");
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        String prefix = this.getConfigurationPrefix();
        try {
            newShell.setSize(settings.getInt(String.valueOf(prefix) + ".cx"), settings.getInt(String.valueOf(prefix) + ".cy"));
        }
        catch (NumberFormatException numberFormatException) {}
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 5;
        dialogArea.setLayout((Layout)layout);
        Label label = new Label(dialogArea, 0);
        label.setText("Available parameters");
        this.filterText = new Text(dialogArea, 2048);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.filterText.setLayoutData((Object)gd);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractSelectParamDlg.this.filter.setFilter(AbstractSelectParamDlg.this.filterText.getText());
                AbstractSelectParamDlg.this.viewer.refresh(false);
            }
        });
        String[] names = new String[]{"Name", "Type", "Description"};
        int[] widths = new int[]{150, 100, 350};
        this.viewer = new SortableTableViewer(dialogArea, names, widths, 0, 128, 67584);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)(String.valueOf(this.getConfigurationPrefix()) + ".viewer"));
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new AgentParameterLabelProvider());
        this.viewer.setComparator((ViewerComparator)new AgentParameterComparator());
        this.filter = new AgentParameterFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        this.viewer.getTable().addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                AbstractSelectParamDlg.this.okPressed();
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTableViewerSettings((SortableTableViewer)AbstractSelectParamDlg.this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)(String.valueOf(AbstractSelectParamDlg.this.getConfigurationPrefix()) + ".viewer"));
            }
        });
        gd = new GridData();
        gd.heightHint = 250;
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.viewer.getControl().setLayoutData((Object)gd);
        this.fillParameterList();
        return dialogArea;
    }

    @Override
    public int getParameterDataType() {
        return this.selectedParameter.getDataType();
    }

    @Override
    public String getParameterDescription() {
        return this.selectedParameter.getDescription();
    }

    @Override
    public String getParameterName() {
        return this.selectedParameter.getName();
    }

    protected void okPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Warning", (String)"You must select parameter from the list!");
            return;
        }
        this.selectedParameter = (AgentParameter)selection.getFirstElement();
        this.saveSettings();
        super.okPressed();
    }

    protected void cancelPressed() {
        this.saveSettings();
        super.cancelPressed();
    }

    protected void saveSettings() {
        Point size = this.getShell().getSize();
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        settings.put(String.valueOf(this.getConfigurationPrefix()) + ".cx", size.x);
        settings.put(String.valueOf(this.getConfigurationPrefix()) + ".cy", size.y);
    }

    protected abstract void fillParameterList();

    protected abstract String getConfigurationPrefix();
}

