/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.propertypages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.client.datacollection.Threshold;
import org.netxms.client.events.EventTemplate;
import org.netxms.ui.eclipse.datacollection.Activator;
import org.netxms.ui.eclipse.datacollection.ThresholdLabelProvider;
import org.netxms.ui.eclipse.datacollection.dialogs.EditThresholdDialog;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class Thresholds
extends PropertyPage {
    public static final int COLUMN_OPERATION = 0;
    public static final int COLUMN_EVENT = 1;
    private static final String COLUMN_SETTINGS_PREFIX = "Thresholds.ThresholdList";
    private DataCollectionItem dci;
    private LabeledText instance;
    private TableViewer thresholds;
    private Button addButton;
    private Button modifyButton;
    private Button deleteButton;
    private Button upButton;
    private Button downButton;

    protected Control createContents(Composite parent) {
        Platform.getAdapterManager().loadAdapter((Object)new EventTemplate(0L), "org.eclipse.ui.model.IWorkbenchAdapter");
        this.dci = (DataCollectionItem)this.getElement().getAdapter(DataCollectionItem.class);
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.instance = new LabeledText(dialogArea, 0);
        this.instance.setLabel("Instance");
        this.instance.setText(this.dci.getInstance());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.instance.setLayoutData((Object)gd);
        Composite thresholdArea = new Composite(dialogArea, 0);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = 2;
        thresholdArea.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.verticalSpacing = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        thresholdArea.setLayout((Layout)layout);
        new Label(thresholdArea, 0).setText("Thresholds");
        this.thresholds = new TableViewer(thresholdArea, 67586);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = 2;
        this.thresholds.getControl().setLayoutData((Object)gd);
        this.setupThresholdList();
        this.thresholds.setInput((Object)this.dci.getThresholds().toArray());
        Composite leftButtons = new Composite(thresholdArea, 0);
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        leftButtons.setLayoutData((Object)gd);
        RowLayout buttonsLayout = new RowLayout(256);
        buttonsLayout.marginBottom = 0;
        buttonsLayout.marginLeft = 0;
        buttonsLayout.marginRight = 0;
        buttonsLayout.marginTop = 0;
        buttonsLayout.spacing = 4;
        buttonsLayout.fill = true;
        buttonsLayout.pack = false;
        leftButtons.setLayout((Layout)buttonsLayout);
        this.upButton = new Button(leftButtons, 8);
        this.upButton.setText("&Up");
        this.upButton.setEnabled(false);
        this.upButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                Thresholds.this.moveUp();
            }
        });
        this.downButton = new Button(leftButtons, 8);
        this.downButton.setText("&Down");
        this.downButton.setEnabled(false);
        this.downButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                Thresholds.this.moveDown();
            }
        });
        Composite buttons = new Composite(thresholdArea, 0);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        buttons.setLayoutData((Object)gd);
        buttonsLayout = new RowLayout(256);
        buttonsLayout.marginBottom = 0;
        buttonsLayout.marginLeft = 0;
        buttonsLayout.marginRight = 0;
        buttonsLayout.marginTop = 0;
        buttonsLayout.spacing = 4;
        buttonsLayout.fill = true;
        buttonsLayout.pack = false;
        buttons.setLayout((Layout)buttonsLayout);
        this.addButton = new Button(buttons, 8);
        this.addButton.setText("&Add...");
        RowData rd = new RowData();
        rd.width = 90;
        this.addButton.setLayoutData((Object)rd);
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                Thresholds.this.addThreshold();
            }
        });
        this.modifyButton = new Button(buttons, 8);
        this.modifyButton.setText("&Edit...");
        rd = new RowData();
        rd.width = 90;
        this.modifyButton.setLayoutData((Object)rd);
        this.modifyButton.setEnabled(false);
        this.modifyButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                Thresholds.this.editThreshold();
            }
        });
        this.deleteButton = new Button(buttons, 8);
        this.deleteButton.setText("&Delete");
        rd = new RowData();
        rd.width = 90;
        this.deleteButton.setLayoutData((Object)rd);
        this.deleteButton.setEnabled(false);
        this.deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                Thresholds.this.deleteThresholds();
            }
        });
        this.thresholds.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                ArrayList tlist = Thresholds.this.dci.getThresholds();
                int index = tlist.indexOf(selection.getFirstElement());
                Thresholds.this.upButton.setEnabled(selection.size() == 1 && index > 0);
                Thresholds.this.downButton.setEnabled(selection.size() == 1 && index >= 0 && index < tlist.size() - 1);
                Thresholds.this.modifyButton.setEnabled(selection.size() == 1);
                Thresholds.this.deleteButton.setEnabled(selection.size() > 0);
            }
        });
        this.thresholds.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Thresholds.this.editThreshold();
            }
        });
        return dialogArea;
    }

    private void deleteThresholds() {
        IStructuredSelection selection = (IStructuredSelection)this.thresholds.getSelection();
        if (!selection.isEmpty()) {
            ArrayList list = this.dci.getThresholds();
            Iterator it = selection.iterator();
            while (it.hasNext()) {
                list.remove(it.next());
            }
            this.thresholds.setInput((Object)this.dci.getThresholds().toArray());
        }
    }

    private void editThreshold() {
        IStructuredSelection selection = (IStructuredSelection)this.thresholds.getSelection();
        if (selection.size() == 1) {
            Threshold threshold = (Threshold)selection.getFirstElement();
            EditThresholdDialog dlg = new EditThresholdDialog(this.getShell(), threshold);
            if (dlg.open() == 0) {
                this.thresholds.update((Object)threshold, null);
            }
        }
    }

    private void addThreshold() {
        Threshold threshold = new Threshold();
        EditThresholdDialog dlg = new EditThresholdDialog(this.getShell(), threshold);
        if (dlg.open() == 0) {
            this.dci.getThresholds().add(threshold);
            this.thresholds.setInput((Object)this.dci.getThresholds().toArray());
            this.thresholds.setSelection((ISelection)new StructuredSelection((Object)threshold));
        }
    }

    private void moveUp() {
        Threshold threshold;
        ArrayList list;
        int index;
        IStructuredSelection selection = (IStructuredSelection)this.thresholds.getSelection();
        if (selection.size() == 1 && (index = (list = this.dci.getThresholds()).indexOf(threshold = (Threshold)selection.getFirstElement())) > 0) {
            Collections.swap(list, index - 1, index);
            this.thresholds.setInput((Object)this.dci.getThresholds().toArray());
            this.thresholds.setSelection((ISelection)new StructuredSelection((Object)threshold));
        }
    }

    private void moveDown() {
        Threshold threshold;
        ArrayList list;
        int index;
        IStructuredSelection selection = (IStructuredSelection)this.thresholds.getSelection();
        if (selection.size() == 1 && (index = (list = this.dci.getThresholds()).indexOf(threshold = (Threshold)selection.getFirstElement())) < list.size() - 1 && index >= 0) {
            Collections.swap(list, index + 1, index);
            this.thresholds.setInput((Object)this.dci.getThresholds().toArray());
            this.thresholds.setSelection((ISelection)new StructuredSelection((Object)threshold));
        }
    }

    private void setupThresholdList() {
        Table table = this.thresholds.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn column = new TableColumn(table, 16384);
        column.setText("Expression");
        column.setWidth(200);
        column = new TableColumn(table, 16384);
        column.setText("Event");
        column.setWidth(150);
        WidgetHelper.restoreColumnSettings((Table)table, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)COLUMN_SETTINGS_PREFIX);
        this.thresholds.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.thresholds.setLabelProvider((IBaseLabelProvider)new ThresholdLabelProvider());
    }

    protected void performApply() {
        this.saveSettings();
        this.applyChanges(true);
    }

    public boolean performOk() {
        this.saveSettings();
        this.applyChanges(false);
        return true;
    }

    protected void applyChanges(final boolean isApply) {
        if (isApply) {
            this.setValid(false);
        }
        this.dci.setInstance(this.instance.getText());
        new ConsoleJob("Update thresholds for DCI " + this.dci.getId(), null, "org.netxms.ui.eclipse.datacollection", null){

            protected String getErrorMessage() {
                return "Cannot update thresholds";
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                Thresholds.this.dci.getOwner().modifyItem(Thresholds.this.dci);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        ((TableViewer)Thresholds.this.dci.getOwner().getUserData()).update((Object)Thresholds.this.dci, null);
                    }
                });
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            Thresholds.this.setValid(true);
                        }
                    });
                }
            }
        }.start();
    }

    public boolean performCancel() {
        this.saveSettings();
        return true;
    }

    private void saveSettings() {
        WidgetHelper.saveColumnSettings((Table)this.thresholds.getTable(), (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)COLUMN_SETTINGS_PREFIX);
    }
}

