/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.perfview.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.ui.eclipse.charts.api.ChartDciConfig;
import org.netxms.ui.eclipse.datacollection.widgets.DciSelector;
import org.netxms.ui.eclipse.tools.ColorConverter;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class DataSourceEditDlg
extends Dialog {
    private ChartDciConfig dci;
    private DciSelector dciSelector;
    private LabeledText name;
    private Button colorAuto;
    private Button colorCustom;
    private ColorSelector colorSelector;

    public DataSourceEditDlg(Shell parentShell, ChartDciConfig dci) {
        super(parentShell);
        this.dci = dci;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Edit Data Source");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        dialogArea.setLayout((Layout)layout);
        this.dciSelector = new DciSelector(dialogArea, 0, false);
        this.dciSelector.setLabel("Data collection item");
        this.dciSelector.setDciId(this.dci.nodeId, this.dci.dciId);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 400;
        this.dciSelector.setLayoutData((Object)gd);
        this.name = new LabeledText(dialogArea, 0);
        this.name.setLabel("Display name");
        this.name.setText(this.dci.name);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.name.setLayoutData((Object)gd);
        Group colorGroup = new Group(dialogArea, 0);
        colorGroup.setText("Color");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        colorGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.numColumns = 2;
        colorGroup.setLayout((Layout)layout);
        this.colorAuto = new Button((Composite)colorGroup, 16);
        this.colorAuto.setText("&Automatic color");
        this.colorAuto.setSelection(this.dci.color.equalsIgnoreCase("UNSET"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.colorAuto.setLayoutData((Object)gd);
        this.colorAuto.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DataSourceEditDlg.this.colorSelector.setEnabled(false);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.colorCustom = new Button((Composite)colorGroup, 16);
        this.colorCustom.setText("&Custom color:");
        this.colorCustom.setSelection(!this.dci.color.equalsIgnoreCase("UNSET"));
        this.colorCustom.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DataSourceEditDlg.this.colorSelector.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.colorSelector = new ColorSelector((Composite)colorGroup);
        this.colorSelector.setColorValue(ColorConverter.rgbFromInt((int)this.dci.getColorAsInt()));
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        gd.grabExcessHorizontalSpace = true;
        this.colorSelector.getButton().setLayoutData((Object)gd);
        this.colorSelector.setEnabled(!this.dci.color.equalsIgnoreCase("UNSET"));
        return dialogArea;
    }

    protected void okPressed() {
        this.dci.nodeId = this.dciSelector.getNodeId();
        this.dci.dciId = this.dciSelector.getDciId();
        this.dci.name = this.name.getText();
        this.dci.color = this.colorAuto.getSelection() ? "UNSET" : "0x" + Integer.toHexString(ColorConverter.rgbToInt((RGB)this.colorSelector.getColorValue()));
        super.okPressed();
    }
}

