/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.perfview.views;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.dialogs.PropertyDialog;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.DciData;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.client.datacollection.GraphItemStyle;
import org.netxms.client.datacollection.GraphSettings;
import org.netxms.client.datacollection.GraphSettingsChangeListener;
import org.netxms.client.datacollection.Threshold;
import org.netxms.client.objects.GenericObject;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.charts.api.ChartColor;
import org.netxms.ui.eclipse.charts.api.ChartDciConfig;
import org.netxms.ui.eclipse.charts.api.ChartFactory;
import org.netxms.ui.eclipse.charts.api.HistoricalDataChart;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.perfview.Activator;
import org.netxms.ui.eclipse.perfview.ChartConfig;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.shared.SharedIcons;

public class HistoricalDataView
extends ViewPart
implements GraphSettingsChangeListener {
    public static final String ID = "org.netxms.ui.eclipse.perfview.views.HistoryGraph";
    public static final String PREDEFINED_GRAPH_SUBID = "org.netxms.ui.eclipse.charts.predefinedGraph";
    private static final int[] presetUnits;
    private static final int[] presetRanges;
    private static final String[] presetNames;
    private NXCSession session;
    private HistoricalDataChart chart = null;
    private boolean updateInProgress = false;
    private Runnable refreshTimer;
    private Composite chartParent = null;
    private GraphSettings settings = new GraphSettings();
    private ChartConfig config = new ChartConfig();
    private Action actionRefresh;
    private Action actionAutoRefresh;
    private Action actionZoomIn;
    private Action actionZoomOut;
    private Action actionAdjustX;
    private Action actionAdjustY;
    private Action actionAdjustBoth;
    private Action actionLogScale;
    private Action actionShowLegend;
    private Action actionLegendLeft;
    private Action actionLegendRight;
    private Action actionLegendTop;
    private Action actionLegendBottom;
    private Action actionProperties;
    private Action[] presetActions;

    static {
        int[] nArray = new int[12];
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[6] = 2;
        nArray[7] = 2;
        nArray[8] = 2;
        nArray[9] = 2;
        nArray[10] = 2;
        nArray[11] = 2;
        presetUnits = nArray;
        presetRanges = new int[]{10, 30, 1, 2, 4, 12, 1, 2, 5, 7, 31, 365};
        presetNames = new String[]{"10 minutes", "30 minutes", "hour", "2 hours", "4 hours", "12 hours", "day", "2 days", "5 days", "week", "month", "year"};
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        final Display display = site.getShell().getDisplay();
        this.refreshTimer = new Runnable(){

            @Override
            public void run() {
                if (((Widget)HistoricalDataView.this.chart).isDisposed()) {
                    return;
                }
                HistoricalDataView.this.updateChart();
                display.timerExec(HistoricalDataView.this.config.getRefreshRate() * 1000, (Runnable)this);
            }
        };
        this.session = (NXCSession)ConsoleSharedData.getSession();
        this.config.setTimeFrom(new Date(System.currentTimeMillis() - this.config.getTimeRangeMillis()));
        this.config.setTimeTo(new Date(System.currentTimeMillis()));
        String id = site.getSecondaryId();
        String[] fields = id.split("&");
        if (!fields[0].equals(PREDEFINED_GRAPH_SUBID)) {
            ArrayList<ChartDciConfig> items = new ArrayList<ChartDciConfig>();
            int i = 1;
            while (i < fields.length) {
                String[] subfields = fields[i].split("\\@");
                if (subfields.length == 6) {
                    try {
                        ChartDciConfig dci = new ChartDciConfig();
                        dci.nodeId = Long.parseLong(subfields[0], 10);
                        dci.dciId = Long.parseLong(subfields[1], 10);
                        dci.name = URLDecoder.decode(subfields[5], "UTF-8");
                        items.add(dci);
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                }
                ++i;
            }
            if (items.size() == 1) {
                ChartDciConfig item = (ChartDciConfig)items.get(0);
                GenericObject object = this.session.findObjectById(item.nodeId);
                if (object != null) {
                    this.setPartName(String.valueOf(object.getObjectName()) + ": " + item.name);
                }
            } else if (items.size() > 1) {
                GenericObject object;
                long nodeId = ((ChartDciConfig)items.get((int)0)).nodeId;
                for (ChartDciConfig item : items) {
                    if (item.nodeId == nodeId) continue;
                    nodeId = -1L;
                    break;
                }
                if (nodeId != -1L && (object = this.session.findObjectById(nodeId)) != null) {
                    this.setPartName(String.valueOf(object.getObjectName()) + ": historical data");
                }
            }
            this.config.setTitle(this.getPartName());
            this.config.setDciList(items.toArray(new ChartDciConfig[items.size()]));
        }
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        this.init(site);
        if (memento != null) {
            try {
                this.config = ChartConfig.createFromXml(memento.getTextData());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void saveState(IMemento memento) {
        try {
            memento.putTextData(this.config.createXml());
        }
        catch (Exception exception) {}
    }

    public void initPredefinedGraph(GraphSettings gs) {
        this.settings = gs;
        try {
            this.config = ChartConfig.createFromXml(this.settings.getConfig());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.settings.addChangeListener((GraphSettingsChangeListener)this);
        this.configureGraphFromSettings();
    }

    private void configureGraphFromSettings() {
        if (this.chart != null) {
            ((Widget)this.chart).dispose();
        }
        this.chart = ChartFactory.createLineChart((Composite)this.chartParent, (int)0);
        this.createPopupMenu();
        this.setPartName(this.config.getTitle());
        this.chart.setChartTitle(this.config.getTitle());
        this.chart.setLogScaleEnabled(this.config.isLogScale());
        this.chart.setGridVisible(this.config.isShowGrid());
        this.chart.setLegendVisible(this.config.isShowLegend());
        this.chart.setLegendPosition(this.config.getLegendPosition());
        ArrayList<GraphItemStyle> styles = new ArrayList<GraphItemStyle>(this.config.getDciList().length);
        int index = 0;
        ChartDciConfig[] chartDciConfigArray = this.config.getDciList();
        int n = chartDciConfigArray.length;
        int n2 = 0;
        while (n2 < n) {
            ChartDciConfig dci = chartDciConfigArray[n2];
            this.chart.addParameter(new GraphItem(dci.nodeId, dci.dciId, 0, 0, Long.toString(dci.dciId), dci.getName()));
            int color = dci.getColorAsInt();
            if (color == -1) {
                color = ChartColor.getDefaultColor((int)index).getRGB();
            }
            styles.add(new GraphItemStyle(0, color, 2, 0));
            ++index;
            ++n2;
        }
        this.chart.setItemStyles(styles);
        if (this.config.getTimeFrameType() == 1) {
            this.config.setTimeFrom(new Date(System.currentTimeMillis() - this.config.getTimeRangeMillis()));
            this.config.setTimeTo(new Date(System.currentTimeMillis()));
        }
        this.getDataFromServer();
        this.actionAutoRefresh.setChecked(this.config.isAutoRefresh());
        this.getSite().getShell().getDisplay().timerExec(this.config.isAutoRefresh() ? this.config.getRefreshRate() * 1000 : -1, this.refreshTimer);
    }

    public void createPartControl(Composite parent) {
        this.chartParent = parent;
        this.createActions();
        this.contributeToActionBars();
        this.configureGraphFromSettings();
        this.settings.addChangeListener((GraphSettingsChangeListener)this);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                HistoricalDataView.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.chart);
        ((Control)this.chart).setMenu(menu);
        Control[] controlArray = ((Composite)this.chart).getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control ch = controlArray[n2];
            ch.setMenu(menu);
            ++n2;
        }
    }

    private void getDataFromServer() {
        final ChartDciConfig[] dciList = this.config.getDciList();
        ConsoleJob job = new ConsoleJob("Get DCI values for history graph", (IWorkbenchPart)this, "org.netxms.ui.eclipse.perfview", "org.netxms.ui.eclipse.perfview"){
            private ChartDciConfig currentItem;

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                monitor.beginTask(this.getName(), dciList.length);
                final DciData[] data = new DciData[dciList.length];
                Threshold[][] thresholds = new Threshold[dciList.length][];
                int i = 0;
                while (i < dciList.length) {
                    this.currentItem = dciList[i];
                    data[i] = HistoricalDataView.this.session.getCollectedData(this.currentItem.nodeId, this.currentItem.dciId, HistoricalDataView.this.config.getTimeFrom(), HistoricalDataView.this.config.getTimeTo(), 0);
                    thresholds[i] = HistoricalDataView.this.session.getThresholds(this.currentItem.nodeId, this.currentItem.dciId);
                    monitor.worked(1);
                    ++i;
                }
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (!((Widget)HistoricalDataView.this.chart).isDisposed()) {
                            HistoricalDataView.this.chart.setTimeRange(HistoricalDataView.this.config.getTimeFrom(), HistoricalDataView.this.config.getTimeTo());
                            HistoricalDataView.this.setChartData(data);
                        }
                        HistoricalDataView.this.updateInProgress = false;
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot get value for DCI " + HistoricalDataView.this.session.getObjectName(this.currentItem.nodeId) + ":\"" + this.currentItem.name + "\"";
            }

            protected void jobFailureHandler() {
                HistoricalDataView.this.updateInProgress = false;
                super.jobFailureHandler();
            }

            protected IStatus createFailureStatus(final Exception e) {
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        HistoricalDataView.this.chart.addError(String.valueOf(this.getErrorMessage()) + " (" + e.getLocalizedMessage() + ")");
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setUser(false);
        job.start();
    }

    public void setFocus() {
        ((Composite)this.chart).setFocus();
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction(){

            public void run() {
                HistoricalDataView.this.updateChart();
            }
        };
        this.actionProperties = new Action("Properties"){

            public void run() {
                PropertyDialog dlg = PropertyDialog.createDialogOn((Shell)HistoricalDataView.this.getSite().getShell(), null, (Object)HistoricalDataView.this.config);
                if (dlg != null) {
                    dlg.open();
                    HistoricalDataView.this.configureGraphFromSettings();
                }
            }
        };
        this.actionAutoRefresh = new Action("Refresh &automatically"){

            public void run() {
                HistoricalDataView.this.config.setAutoRefresh(!HistoricalDataView.this.config.isAutoRefresh());
                this.setChecked(HistoricalDataView.this.config.isAutoRefresh());
                HistoricalDataView.this.getSite().getShell().getDisplay().timerExec(HistoricalDataView.this.config.isAutoRefresh() ? HistoricalDataView.this.config.getRefreshRate() * 1000 : -1, HistoricalDataView.this.refreshTimer);
            }
        };
        this.actionAutoRefresh.setChecked(this.config.isAutoRefresh());
        this.actionLogScale = new Action("&Logarithmic scale"){

            public void run() {
                try {
                    HistoricalDataView.this.chart.setLogScaleEnabled(!HistoricalDataView.this.config.isLogScale());
                    HistoricalDataView.this.config.setLogScale(!HistoricalDataView.this.config.isLogScale());
                }
                catch (IllegalStateException e) {
                    MessageDialog.openError((Shell)HistoricalDataView.this.getSite().getShell(), (String)"Error", (String)("Cannot switch to logarithmic scale: " + e.getLocalizedMessage()));
                }
                this.setChecked(HistoricalDataView.this.config.isLogScale());
            }
        };
        this.actionLogScale.setChecked(this.config.isLogScale());
        this.actionZoomIn = new Action("Zoom &in"){

            public void run() {
                HistoricalDataView.this.chart.zoomIn();
            }
        };
        this.actionZoomIn.setImageDescriptor(SharedIcons.ZOOM_IN);
        this.actionZoomOut = new Action("Zoom &out"){

            public void run() {
                HistoricalDataView.this.chart.zoomOut();
            }
        };
        this.actionZoomOut.setImageDescriptor(SharedIcons.ZOOM_OUT);
        this.actionAdjustX = new Action(){

            public void run() {
                HistoricalDataView.this.chart.adjustXAxis(true);
            }
        };
        this.actionAdjustX.setText("Adjust &X axis");
        this.actionAdjustX.setImageDescriptor(Activator.getImageDescriptor("icons/adjust_x.png"));
        this.actionAdjustY = new Action(){

            public void run() {
                HistoricalDataView.this.chart.adjustYAxis(true);
            }
        };
        this.actionAdjustY.setText("Adjust &Y axis");
        this.actionAdjustY.setImageDescriptor(Activator.getImageDescriptor("icons/adjust_y.png"));
        this.actionAdjustBoth = new Action(){

            public void run() {
                HistoricalDataView.this.chart.adjustXAxis(false);
                HistoricalDataView.this.chart.adjustYAxis(true);
            }
        };
        this.actionAdjustBoth.setText("&Adjust");
        this.actionAdjustBoth.setImageDescriptor(Activator.getImageDescriptor("icons/adjust.png"));
        this.actionShowLegend = new Action("&Show legend"){

            public void run() {
                HistoricalDataView.this.config.setShowLegend(!HistoricalDataView.this.config.isShowLegend());
                this.setChecked(HistoricalDataView.this.config.isShowLegend());
                HistoricalDataView.this.chart.setLegendVisible(HistoricalDataView.this.config.isShowLegend());
            }
        };
        this.actionShowLegend.setChecked(this.config.isShowLegend());
        this.actionLegendLeft = new Action("Place on &left", 8){

            public void run() {
                HistoricalDataView.this.config.setLegendPosition(1);
                HistoricalDataView.this.chart.setLegendPosition(HistoricalDataView.this.config.getLegendPosition());
            }
        };
        this.actionLegendLeft.setChecked(this.config.getLegendPosition() == 1);
        this.actionLegendRight = new Action("Place on &right", 8){

            public void run() {
                HistoricalDataView.this.config.setLegendPosition(2);
                HistoricalDataView.this.chart.setLegendPosition(HistoricalDataView.this.config.getLegendPosition());
            }
        };
        this.actionLegendRight.setChecked(this.config.getLegendPosition() == 2);
        this.actionLegendTop = new Action("Place on &top", 8){

            public void run() {
                HistoricalDataView.this.config.setLegendPosition(4);
                HistoricalDataView.this.chart.setLegendPosition(HistoricalDataView.this.config.getLegendPosition());
            }
        };
        this.actionLegendTop.setChecked(this.config.getLegendPosition() == 4);
        this.actionLegendBottom = new Action("Place on &bottom", 8){

            public void run() {
                HistoricalDataView.this.config.setLegendPosition(8);
                HistoricalDataView.this.chart.setLegendPosition(HistoricalDataView.this.config.getLegendPosition());
            }
        };
        this.actionLegendBottom.setChecked(this.config.getLegendPosition() == 8);
        this.presetActions = new Action[presetRanges.length];
        int i = 0;
        while (i < presetRanges.length) {
            final Integer presetIndex = i;
            this.presetActions[i] = new Action("Last " + presetNames[i]){

                public void run() {
                    HistoricalDataView.this.config.setTimeUnits(presetUnits[presetIndex]);
                    HistoricalDataView.this.config.setTimeRange(presetRanges[presetIndex]);
                    HistoricalDataView.this.updateChart();
                }
            };
            ++i;
        }
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        MenuManager presets = new MenuManager("&Presets");
        int i = 0;
        while (i < this.presetActions.length) {
            presets.add((IAction)this.presetActions[i]);
            ++i;
        }
        MenuManager legend = new MenuManager("&Legend");
        legend.add((IAction)this.actionShowLegend);
        legend.add((IContributionItem)new Separator());
        legend.add((IAction)this.actionLegendLeft);
        legend.add((IAction)this.actionLegendRight);
        legend.add((IAction)this.actionLegendTop);
        legend.add((IAction)this.actionLegendBottom);
        manager.add((IContributionItem)presets);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionAdjustBoth);
        manager.add((IAction)this.actionAdjustX);
        manager.add((IAction)this.actionAdjustY);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionZoomIn);
        manager.add((IAction)this.actionZoomOut);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionLogScale);
        manager.add((IAction)this.actionAutoRefresh);
        manager.add((IContributionItem)legend);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionProperties);
    }

    private void fillContextMenu(IMenuManager manager) {
        MenuManager presets = new MenuManager("&Presets");
        int i = 0;
        while (i < this.presetActions.length) {
            presets.add((IAction)this.presetActions[i]);
            ++i;
        }
        MenuManager legend = new MenuManager("&Legend");
        legend.add((IAction)this.actionShowLegend);
        legend.add((IContributionItem)new Separator());
        legend.add((IAction)this.actionLegendLeft);
        legend.add((IAction)this.actionLegendRight);
        legend.add((IAction)this.actionLegendTop);
        legend.add((IAction)this.actionLegendBottom);
        manager.add((IContributionItem)presets);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionAdjustBoth);
        manager.add((IAction)this.actionAdjustX);
        manager.add((IAction)this.actionAdjustY);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionZoomIn);
        manager.add((IAction)this.actionZoomOut);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionLogScale);
        manager.add((IAction)this.actionAutoRefresh);
        manager.add((IContributionItem)legend);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionProperties);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionAdjustBoth);
        manager.add((IAction)this.actionAdjustX);
        manager.add((IAction)this.actionAdjustY);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionZoomIn);
        manager.add((IAction)this.actionZoomOut);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void setChartData(DciData[] data) {
        int i = 0;
        while (i < data.length) {
            this.chart.updateParameter(i, data[i], false);
            ++i;
        }
        this.chart.refresh();
    }

    private void updateChart() {
        if (this.updateInProgress) {
            return;
        }
        this.updateInProgress = true;
        this.config.setTimeFrom(new Date(System.currentTimeMillis() - this.config.getTimeRangeMillis()));
        this.config.setTimeTo(new Date(System.currentTimeMillis()));
        this.getDataFromServer();
    }

    public void dispose() {
        this.getSite().getShell().getDisplay().timerExec(-1, this.refreshTimer);
        super.dispose();
    }

    public void onGraphSettingsChange(GraphSettings settings) {
        if (this.settings == settings) {
            this.configureGraphFromSettings();
        }
    }
}

