/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serverconfig.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class ConfigurationImportDialog
extends Dialog {
    private Text textFileName;
    private Button browseButton;
    private Button overrideEventsByName;
    private Button overrideEventsByCode;
    private String fileName;
    private int flags;

    public ConfigurationImportDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 4;
        dialogArea.setLayout((Layout)layout);
        this.textFileName = WidgetHelper.createLabeledText((Composite)dialogArea, (int)2048, (int)300, (String)"File name", null, (Object)"WidgetHelper::default_layout_data");
        this.browseButton = new Button(dialogArea, 8);
        this.browseButton.setText("Browse...");
        GridData gd = new GridData();
        gd.horizontalAlignment = 131072;
        gd.widthHint = 90;
        this.browseButton.setLayoutData((Object)gd);
        this.browseButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(ConfigurationImportDialog.this.getShell(), 4096);
                fd.setText("Select Configuration File");
                fd.setFilterExtensions(new String[]{"*.xml", "*.*"});
                fd.setFilterNames(new String[]{"XML files", "All files"});
                String selected = fd.open();
                if (selected != null) {
                    ConfigurationImportDialog.this.textFileName.setText(selected);
                }
            }
        });
        Group options = new Group(dialogArea, 0);
        FillLayout optionsLayout = new FillLayout(512);
        optionsLayout.spacing = 4;
        options.setLayout((Layout)optionsLayout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        options.setLayoutData((Object)gd);
        this.overrideEventsByName = new Button((Composite)options, 32);
        this.overrideEventsByName.setText("Replace events with matching &name");
        this.overrideEventsByCode = new Button((Composite)options, 32);
        this.overrideEventsByCode.setText("Replace events with matching event &code");
        return dialogArea;
    }

    protected void okPressed() {
        this.fileName = this.textFileName.getText();
        this.flags = 0;
        if (this.overrideEventsByName.getSelection()) {
            this.flags |= 2;
        }
        if (this.overrideEventsByCode.getSelection()) {
            this.flags |= 1;
        }
        super.okPressed();
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getFlags() {
        return this.flags;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Import Configuration");
    }
}

