/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.logviewer.widgets;

import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.netxms.api.client.users.AbstractUserObject;
import org.netxms.client.log.ColumnFilter;
import org.netxms.ui.eclipse.logviewer.widgets.ConditionEditor;
import org.netxms.ui.eclipse.shared.SharedIcons;
import org.netxms.ui.eclipse.usermanager.dialogs.SelectUserDialog;

public class UserConditionEditor
extends ConditionEditor {
    private static final String[] OPERATIONS = new String[]{"IS", "IS NOT"};
    private static final String EMPTY_SELECTION_TEXT = "<none>";
    private WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();
    private long userId = 0L;
    private CLabel objectName;

    public UserConditionEditor(Composite parent, FormToolkit toolkit) {
        super(parent, toolkit);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                UserConditionEditor.this.labelProvider.dispose();
            }
        });
    }

    @Override
    protected String[] getOperations() {
        return OPERATIONS;
    }

    @Override
    protected void createContent(Composite parent) {
        Composite group = new Composite((Composite)this, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 2;
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)gd);
        this.objectName = new CLabel(group, 0);
        this.toolkit.adapt((Composite)this.objectName);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 128;
        this.objectName.setLayoutData((Object)gd);
        this.objectName.setText(EMPTY_SELECTION_TEXT);
        ImageHyperlink selectionLink = this.toolkit.createImageHyperlink(group, 0);
        selectionLink.setImage(SharedIcons.IMG_FIND);
        selectionLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                UserConditionEditor.this.selectUser();
            }
        });
    }

    private void selectUser() {
        SelectUserDialog dlg = new SelectUserDialog(this.getShell(), false);
        dlg.enableMultiSelection(false);
        if (dlg.open() == 0) {
            AbstractUserObject[] users = dlg.getSelection();
            if (users.length > 0) {
                this.userId = users[0].getId();
                this.objectName.setText(users[0].getName());
                this.objectName.setImage(this.labelProvider.getImage((Object)users[0]));
            } else {
                this.userId = 0L;
                this.objectName.setText(EMPTY_SELECTION_TEXT);
                this.objectName.setImage(null);
            }
        }
    }

    @Override
    public ColumnFilter createFilter() {
        ColumnFilter filter = new ColumnFilter(0, this.userId);
        filter.setNegated(this.getSelectedOperation() == 1);
        return filter;
    }
}

