/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.propertypages;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.Template;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.nxsl.widgets.ScriptEditor;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class AutoApply
extends PropertyPage {
    private Template object;
    private Button checkboxEnable;
    private ScriptEditor filterSource;
    private boolean initialApplyFlag;
    private String initialApplyFilter;

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.object = (Template)this.getElement().getAdapter(Template.class);
        if (this.object == null) {
            return dialogArea;
        }
        this.initialApplyFlag = this.object.isAutoApplyEnabled();
        this.initialApplyFilter = new String(this.object.getAutoApplyFilter());
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.checkboxEnable = new Button(dialogArea, 32);
        this.checkboxEnable.setText("Apply this template automatically to nodes selected by filter");
        this.checkboxEnable.setSelection(this.object.isAutoApplyEnabled());
        this.checkboxEnable.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                if (AutoApply.this.checkboxEnable.getSelection()) {
                    AutoApply.this.filterSource.setEnabled(true);
                    AutoApply.this.filterSource.setFocus();
                } else {
                    AutoApply.this.filterSource.setEnabled(false);
                }
            }
        });
        Label label = new Label(dialogArea, 0);
        label.setText("Filtering script");
        GridData gd = new GridData();
        gd.verticalIndent = 5;
        label.setLayoutData((Object)gd);
        this.filterSource = new ScriptEditor(dialogArea, 2048, 768);
        this.filterSource.setText(this.object.getAutoApplyFilter());
        this.filterSource.setEnabled(this.object.isAutoApplyEnabled());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.widthHint = 0;
        gd.heightHint = 0;
        this.filterSource.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void applyChanges(final boolean isApply) {
        final boolean isAutoApplyEnabled = this.checkboxEnable.getSelection();
        if (!isAutoApplyEnabled && !this.initialApplyFlag || isAutoApplyEnabled && this.initialApplyFlag && this.initialApplyFilter.equals(this.filterSource.getText())) {
            return;
        }
        if (isApply) {
            this.setValid(false);
        }
        final String newApplyFilter = new String(this.filterSource.getText());
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        final NXCObjectModificationData md = new NXCObjectModificationData(this.object.getObjectId());
        md.setAutoApplyEnabled(isAutoApplyEnabled);
        md.setAutoApplyFilter(newApplyFilter);
        new ConsoleJob("Update auto-apply filter", null, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.modifyObject(md);
                AutoApply.this.initialApplyFlag = isAutoApplyEnabled;
                AutoApply.this.initialApplyFilter = newApplyFilter;
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            AutoApply.this.setValid(true);
                        }
                    });
                }
            }

            protected String getErrorMessage() {
                return "Cannot change template automatic apply options";
            }
        }.start();
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }
}

