/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.propertypages;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.Node;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class NodePolling
extends PropertyPage {
    private Node object;
    private ObjectSelector pollerNode;
    private Button radioDefault;
    private Button radioEnable;
    private Button radioDisable;
    private List<Button> flagButtons = new ArrayList<Button>();
    private List<Integer> flagValues = new ArrayList<Integer>();

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.object = (Node)this.getElement().getAdapter(Node.class);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        Group servicePollGroup = new Group(dialogArea, 0);
        servicePollGroup.setText("Network service polling");
        layout = new GridLayout();
        layout.horizontalSpacing = 5;
        layout.numColumns = 2;
        servicePollGroup.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        servicePollGroup.setLayoutData((Object)gd);
        this.pollerNode = new ObjectSelector((Composite)servicePollGroup, 0);
        this.pollerNode.setLabel("Poller node");
        this.pollerNode.setObjectClass(Node.class);
        this.pollerNode.setEmptySelectionName("<server>");
        this.pollerNode.setObjectId(this.object.getPollerNodeId());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.pollerNode.setLayoutData((Object)gd);
        Label label = new Label((Composite)servicePollGroup, 64);
        label.setText("All network services of this node will be polled from poller node specified here, if not overrided by network service settings.");
        gd = new GridData();
        gd.widthHint = 250;
        label.setLayoutData((Object)gd);
        Group optionsGroup = new Group(dialogArea, 0);
        optionsGroup.setText("Options");
        layout = new GridLayout();
        layout.verticalSpacing = 5;
        optionsGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        optionsGroup.setLayoutData((Object)gd);
        this.addFlag((Composite)optionsGroup, 0x2000000, "Disable usage of NetXMS &agent for all polls");
        this.addFlag((Composite)optionsGroup, 0x1000000, "Disable usage of &SNMP for all polls");
        this.addFlag((Composite)optionsGroup, 0x4000000, "Disable usage of &ICMP pings for status polling");
        this.addFlag((Composite)optionsGroup, 0x10000000, "Disable s&tatus polling");
        this.addFlag((Composite)optionsGroup, 0x20000000, "Disable &configuration polling");
        this.addFlag((Composite)optionsGroup, 0x40000000, "Disable &routing table polling");
        this.addFlag((Composite)optionsGroup, 0x800000, "Disable &topology polling");
        this.addFlag((Composite)optionsGroup, 0x400000, "Disable network &discovery polling");
        this.addFlag((Composite)optionsGroup, Integer.MIN_VALUE, "Disable data c&ollection");
        Group ifXTableGroup = new Group(dialogArea, 0);
        ifXTableGroup.setText("Use ifXTable for interface polling");
        layout = new GridLayout();
        layout.horizontalSpacing = 5;
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = true;
        ifXTableGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        ifXTableGroup.setLayoutData((Object)gd);
        this.radioDefault = new Button((Composite)ifXTableGroup, 16);
        this.radioDefault.setText("De&fault");
        this.radioDefault.setSelection(this.object.getIfXTablePolicy() == 0);
        this.radioEnable = new Button((Composite)ifXTableGroup, 16);
        this.radioEnable.setText("&Enable");
        this.radioEnable.setSelection(this.object.getIfXTablePolicy() == 1);
        this.radioDisable = new Button((Composite)ifXTableGroup, 16);
        this.radioDisable.setText("&Disable");
        this.radioDisable.setSelection(this.object.getIfXTablePolicy() == 2);
        return dialogArea;
    }

    private void addFlag(Composite parent, int value, String name) {
        Button button = new Button(parent, 32);
        button.setText(name);
        button.setSelection((this.object.getFlags() & value) != 0);
        this.flagButtons.add(button);
        this.flagValues.add(value);
    }

    private int collectNodeFlags() {
        int flags = this.object.getFlags();
        int i = 0;
        while (i < this.flagButtons.size()) {
            flags = this.flagButtons.get(i).getSelection() ? (flags |= this.flagValues.get(i).intValue()) : (flags &= ~this.flagValues.get(i).intValue());
            ++i;
        }
        return flags;
    }

    private int collectIfXTablePolicy() {
        if (this.radioEnable.getSelection()) {
            return 1;
        }
        if (this.radioDisable.getSelection()) {
            return 2;
        }
        return 0;
    }

    protected boolean applyChanges(final boolean isApply) {
        final NXCObjectModificationData md = new NXCObjectModificationData(this.object.getObjectId());
        md.setPollerNode(this.pollerNode.getObjectId());
        md.setNodeFlags(this.collectNodeFlags());
        md.setIfXTablePolicy(this.collectIfXTablePolicy());
        if (isApply) {
            this.setValid(false);
        }
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        new ConsoleJob("Update node polling settings", null, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.modifyObject(md);
            }

            protected String getErrorMessage() {
                return "Cannot update node polling settings";
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            NodePolling.this.setValid(true);
                        }
                    });
                }
            }
        }.start();
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    public boolean performOk() {
        return this.applyChanges(false);
    }
}

