/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.widgets;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.objects.Node;
import org.netxms.ui.eclipse.datacollection.dialogs.SelectDciDialog;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.widgets.AbstractSelector;

public class DciSelector
extends AbstractSelector {
    private long nodeId = 0L;
    private long dciId = 0L;
    private String emptySelectionName = "<none>";
    private NXCSession session;
    private int dcObjectType = -1;

    public DciSelector(Composite parent, int style, boolean useHyperlink) {
        super(parent, style, useHyperlink);
        this.setText(this.emptySelectionName);
        this.session = (NXCSession)ConsoleSharedData.getSession();
    }

    protected void selectionButtonHandler() {
        SelectDciDialog dlg = new SelectDciDialog(this.getShell());
        dlg.setDcObjectType(this.dcObjectType);
        if (dlg.open() == 0) {
            DciValue dci = dlg.getSelection();
            this.setDciId(dci.getNodeId(), dci.getId());
        }
    }

    private void updateText() {
        if (this.nodeId == 0L) {
            this.setText(this.emptySelectionName);
            return;
        }
        new ConsoleJob("Resolve DCI name", null, "org.netxms.ui.eclipse.datacollection", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final String[] names = DciSelector.this.session.resolveDciNames(new long[]{DciSelector.this.nodeId}, new long[]{DciSelector.this.dciId});
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        Node node = (Node)DciSelector.this.session.findObjectById(DciSelector.this.nodeId, Node.class);
                        StringBuilder sb = new StringBuilder();
                        if (node != null) {
                            sb.append(node.getObjectName());
                        } else {
                            sb.append('[');
                            sb.append(DciSelector.this.nodeId);
                            sb.append(']');
                        }
                        sb.append(" / ");
                        if (names.length > 0) {
                            sb.append(names[0]);
                        } else {
                            sb.append('[');
                            sb.append(DciSelector.this.dciId);
                            sb.append(']');
                        }
                        DciSelector.this.setText(sb.toString());
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot resolve DCI name";
            }
        }.start();
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public long getDciId() {
        return this.dciId;
    }

    public void setDciId(long nodeId, long dciId) {
        this.nodeId = nodeId;
        this.dciId = dciId;
        this.updateText();
    }

    public String getEmptySelectionName() {
        return this.emptySelectionName;
    }

    public void setEmptySelectionName(String emptySelectionName) {
        this.emptySelectionName = emptySelectionName;
    }

    public int getDcObjectType() {
        return this.dcObjectType;
    }

    public void setDcObjectType(int dcObjectType) {
        this.dcObjectType = dcObjectType;
    }
}

