/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.objecttabs;

import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.objects.Interface;
import org.netxms.client.objects.Node;
import org.netxms.ui.eclipse.objectview.Activator;
import org.netxms.ui.eclipse.objectview.objecttabs.ObjectTab;
import org.netxms.ui.eclipse.objectview.objecttabs.helpers.InterfaceListComparator;
import org.netxms.ui.eclipse.objectview.objecttabs.helpers.InterfaceListLabelProvider;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class InterfacesTab
extends ObjectTab {
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_NAME = 1;
    public static final int COLUMN_TYPE = 2;
    public static final int COLUMN_INDEX = 3;
    public static final int COLUMN_SLOT = 4;
    public static final int COLUMN_PORT = 5;
    public static final int COLUMN_DESCRIPTION = 6;
    public static final int COLUMN_ADMIN_STATE = 7;
    public static final int COLUMN_OPER_STATE = 8;
    public static final int COLUMN_EXPECTED_STATE = 9;
    public static final int COLUMN_STATUS = 10;
    public static final int COLUMN_8021X_PAE_STATE = 11;
    public static final int COLUMN_8021X_BACKEND_STATE = 12;
    private SortableTableViewer viewer;
    private InterfaceListLabelProvider labelProvider;

    @Override
    protected void createTabContent(Composite parent) {
        String[] names = new String[]{"ID", "Name", "ifType", "ifIndex", "Slot", "Port", "Description", "Admin State", "Oper State", "Exp. State", "Status", "802.1x PAE", "802.1x Backend"};
        int[] widths = new int[]{60, 150, 90, 70, 70, 70, 150, 80, 80, 80, 80, 80, 80};
        this.viewer = new SortableTableViewer(parent, names, widths, 1, 128, 65538);
        this.labelProvider = new InterfaceListLabelProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setComparator((ViewerComparator)new InterfaceListComparator());
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"InterfaceTable");
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveColumnSettings((Table)InterfacesTab.this.viewer.getTable(), (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"InterfaceTable");
            }
        });
        this.createPopupMenu();
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                InterfacesTab.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        if (this.getViewPart() != null) {
            this.getViewPart().getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
        }
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new GroupMarker("additions"));
    }

    @Override
    public void refresh() {
        if (this.getObject() != null) {
            this.viewer.setInput((Object)this.getObject().getAllChilds(3).toArray());
        } else {
            this.viewer.setInput((Object)new Interface[0]);
        }
    }

    @Override
    public void objectChanged(GenericObject object) {
        this.labelProvider.setNode((Node)object);
        this.refresh();
    }

    @Override
    public boolean showForObject(GenericObject object) {
        return object instanceof Node;
    }
}

