/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectbrowser.widgets;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.progress.UIJob;
import org.netxms.api.client.SessionListener;
import org.netxms.api.client.SessionNotification;
import org.netxms.client.NXCListener;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.GenericObject;
import org.netxms.ui.eclipse.objectbrowser.widgets.internal.ObjectTreeComparator;
import org.netxms.ui.eclipse.objectbrowser.widgets.internal.ObjectTreeContentProvider;
import org.netxms.ui.eclipse.objectbrowser.widgets.internal.ObjectTreeFilter;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.widgets.FilterText;

public class ObjectTree
extends Composite {
    public static final int NONE = 0;
    public static final int CHECKBOXES = 1;
    public static final int MULTI = 2;
    private boolean filterEnabled = true;
    private TreeViewer objectTree;
    private FilterText filterText;
    private ObjectTreeFilter filter;
    private Set<Long> checkedObjects = new HashSet<Long>(0);
    private NXCListener sessionListener = null;
    private NXCSession session = (NXCSession)ConsoleSharedData.getSession();
    private long[] expandedElements = null;
    private int changeCount = 0;

    public ObjectTree(Composite parent, int style, int options, long[] rootObjects, Set<Integer> classFilter) {
        super(parent, style);
        FormLayout formLayout = new FormLayout();
        this.setLayout((Layout)formLayout);
        this.filterText = new FilterText((Composite)this, 0);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ObjectTree.this.onFilterModify();
            }
        });
        this.filterText.setCloseAction(new Action(){

            public void run() {
                ObjectTree.this.enableFilter(false);
            }
        });
        this.objectTree = new TreeViewer((Composite)this, 0x10000000 | ((options & 2) == 2 ? 2 : 4) | ((options & 1) == 1 ? 32 : 0));
        this.objectTree.setContentProvider((IContentProvider)new ObjectTreeContentProvider(rootObjects));
        this.objectTree.setLabelProvider((IBaseLabelProvider)WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
        this.objectTree.setComparator((ViewerComparator)new ObjectTreeComparator());
        this.filter = new ObjectTreeFilter(rootObjects, classFilter);
        this.objectTree.addFilter((ViewerFilter)this.filter);
        this.objectTree.setInput((Object)this.session);
        this.objectTree.getControl().addListener(13, new Listener(){

            void checkItems(TreeItem item, boolean isChecked) {
                if (item.getData() == null) {
                    return;
                }
                item.setGrayed(false);
                item.setChecked(isChecked);
                Long id = ((GenericObject)item.getData()).getObjectId();
                if (isChecked) {
                    ObjectTree.this.checkedObjects.add(id);
                } else {
                    ObjectTree.this.checkedObjects.remove(id);
                }
                TreeItem[] items = item.getItems();
                int i = 0;
                while (i < items.length) {
                    this.checkItems(items[i], isChecked);
                    ++i;
                }
            }

            void checkPath(TreeItem item, boolean checked, boolean grayed) {
                if (item == null) {
                    return;
                }
                if (grayed) {
                    checked = true;
                } else {
                    int index = 0;
                    TreeItem[] items = item.getItems();
                    while (index < items.length) {
                        TreeItem child = items[index];
                        if (child.getGrayed() || checked != child.getChecked()) {
                            grayed = true;
                            checked = true;
                            break;
                        }
                        ++index;
                    }
                }
                item.setChecked(checked);
                item.setGrayed(grayed);
                this.checkPath(item.getParentItem(), checked, grayed);
            }

            public void handleEvent(Event event) {
                if (event.detail != 32) {
                    return;
                }
                TreeItem item = (TreeItem)event.item;
                GenericObject object = (GenericObject)item.getData();
                if (object == null) {
                    return;
                }
                boolean isChecked = item.getChecked();
                if (isChecked) {
                    ObjectTree.this.objectTree.expandToLevel((Object)object, -1);
                }
                this.checkItems(item, isChecked);
                this.checkPath(item.getParentItem(), isChecked, false);
                Long id = object.getObjectId();
                if (isChecked) {
                    ObjectTree.this.checkedObjects.add(id);
                } else {
                    ObjectTree.this.checkedObjects.remove(id);
                }
            }
        });
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.filterText);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.objectTree.getTree().setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.filterText.setLayoutData((Object)fd);
        this.sessionListener = new NXCListener(){

            public void notificationHandler(SessionNotification n) {
                if (n.getCode() == 4) {
                    ObjectTree objectTree = ObjectTree.this;
                    objectTree.changeCount = objectTree.changeCount + 1;
                    new UIJob(ObjectTree.this.getDisplay(), "Update object tree"){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            if (ObjectTree.this.isDisposed() || ObjectTree.this.objectTree.getControl().isDisposed()) {
                                return Status.OK_STATUS;
                            }
                            ObjectTree objectTree = ObjectTree.this;
                            objectTree.changeCount = objectTree.changeCount - 1;
                            if (ObjectTree.this.changeCount <= 0) {
                                ObjectTree.this.saveExpandedState();
                                ObjectTree.this.objectTree.refresh();
                                ObjectTree.this.restoreExpandedState();
                            }
                            return Status.OK_STATUS;
                        }
                    }.schedule(500L);
                }
            }
        };
        this.session.addListener((SessionListener)this.sessionListener);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ObjectTree.this.session != null && ObjectTree.this.sessionListener != null) {
                    ObjectTree.this.session.removeListener((SessionListener)ObjectTree.this.sessionListener);
                }
            }
        });
        if (this.filterEnabled) {
            this.filterText.setFocus();
        } else {
            this.enableFilter(false);
        }
    }

    public void enableDragSupport() {
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        this.objectTree.addDragSupport(3, transfers, (DragSourceListener)new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event) {
                LocalSelectionTransfer.getTransfer().setSelection(ObjectTree.this.objectTree.getSelection());
                event.doit = true;
            }

            public void dragSetData(DragSourceEvent event) {
                event.data = LocalSelectionTransfer.getTransfer().getSelection();
            }
        });
    }

    public Tree getTreeControl() {
        return this.objectTree.getTree();
    }

    public TreeViewer getTreeViewer() {
        return this.objectTree;
    }

    public void enableFilter(boolean enable) {
        this.filterEnabled = enable;
        this.filterText.setVisible(this.filterEnabled);
        FormData fd = (FormData)this.objectTree.getTree().getLayoutData();
        fd.top = enable ? new FormAttachment((Control)this.filterText) : new FormAttachment(0, 0);
        this.layout();
        if (enable) {
            this.filterText.setFocus();
        } else {
            this.setFilter("");
        }
    }

    public boolean isFilterEnabled() {
        return this.filterEnabled;
    }

    public void setFilter(String text) {
        this.filterText.setText(text);
        this.onFilterModify();
    }

    public String getFilter() {
        return this.filterText.getText();
    }

    public Long[] getCheckedObjects() {
        return this.checkedObjects.toArray(new Long[this.checkedObjects.size()]);
    }

    private void saveExpandedState() {
        Object[] elements = this.objectTree.getExpandedElements();
        this.expandedElements = new long[elements.length];
        int i = 0;
        while (i < elements.length) {
            this.expandedElements[i] = ((GenericObject)elements[i]).getObjectId();
            ++i;
        }
    }

    private void restoreExpandedState() {
        if (this.expandedElements == null) {
            return;
        }
        Object[] objects = this.session.findMultipleObjects(this.expandedElements, false).toArray();
        this.objectTree.setExpandedElements(objects);
    }

    public long getFirstSelectedObject() {
        IStructuredSelection selection = (IStructuredSelection)this.objectTree.getSelection();
        if (selection.isEmpty()) {
            return 0L;
        }
        return ((GenericObject)selection.getFirstElement()).getObjectId();
    }

    public Long[] getSelectedObjects() {
        IStructuredSelection selection = (IStructuredSelection)this.objectTree.getSelection();
        HashSet<Long> objects = new HashSet<Long>(selection.size());
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            objects.add(((GenericObject)it.next()).getObjectId());
        }
        return objects.toArray(new Long[objects.size()]);
    }

    public GenericObject getFirstSelectedObject2() {
        IStructuredSelection selection = (IStructuredSelection)this.objectTree.getSelection();
        return (GenericObject)selection.getFirstElement();
    }

    public void refresh() {
        this.objectTree.setInput((Object)this.session);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.objectTree.getControl().setEnabled(enabled);
        this.filterText.setEnabled(enabled);
    }

    private void onFilterModify() {
        String text = this.filterText.getText();
        this.filter.setFilterString(text);
        this.objectTree.refresh(false);
        GenericObject obj = this.filter.getLastMatch();
        if (obj != null) {
            this.objectTree.setSelection((ISelection)new StructuredSelection((Object)obj), true);
            GenericObject parent = this.filter.getParent(obj);
            if (parent != null) {
                this.objectTree.expandToLevel((Object)parent, 1);
            }
            this.objectTree.reveal((Object)obj);
        }
    }

    public boolean isHideUnmanaged() {
        return this.filter.isHideUnmanaged();
    }

    public void setHideUnmanaged(boolean hideUnmanaged) {
        this.filter.setHideUnmanaged(hideUnmanaged);
        this.onFilterModify();
    }

    public boolean isHideTemplateChecks() {
        return this.filter.isHideTemplateChecks();
    }

    public void setHideTemplateChecks(boolean hideTemplateChecks) {
        this.filter.setHideTemplateChecks(hideTemplateChecks);
        this.onFilterModify();
    }

    public void setFilterCloseAction(Action action) {
        this.filterText.setCloseAction(action);
    }
}

