/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objecttools.propertypages;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.objecttools.ObjectToolDetails;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class General
extends PropertyPage {
    private ObjectToolDetails objectTool;
    private LabeledText textName;
    private LabeledText textDescription;
    private LabeledText textData;
    private LabeledText textParameter;
    private LabeledText textRegexp;
    private Button checkOutput;
    private Button checkConfirmation;
    private LabeledText textConfirmation;
    private Button radioIndexOID;
    private Button radioIndexValue;

    public void createControl(Composite parent) {
        this.noDefaultAndApplyButton();
        super.createControl(parent);
    }

    protected Control createContents(Composite parent) {
        this.objectTool = (ObjectToolDetails)this.getElement().getAdapter(ObjectToolDetails.class);
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.textName = new LabeledText(dialogArea, 0);
        this.textName.setLabel("Name");
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.textName.setLayoutData((Object)gd);
        this.textName.setText(this.objectTool.getName());
        this.textDescription = new LabeledText(dialogArea, 0);
        this.textDescription.setLabel("Description");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.textDescription.setLayoutData((Object)gd);
        this.textDescription.setText(this.objectTool.getDescription());
        this.textData = new LabeledText(dialogArea, 0);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.textData.setLayoutData((Object)gd);
        this.textData.setText(this.objectTool.getData());
        switch (this.objectTool.getType()) {
            case 0: {
                this.textData.setLabel("Operation");
                break;
            }
            case 5: 
            case 6: {
                this.textData.setLabel("Command");
                this.createOutputGroup(dialogArea);
                break;
            }
            case 1: {
                this.textData.setLabel("Agent's action");
                this.createOutputGroup(dialogArea);
                break;
            }
            case 4: {
                this.textData.setLabel("URL");
                break;
            }
            case 7: {
                this.textData.setLabel("Remote file name");
                break;
            }
            case 2: {
                this.textData.setLabel("Title");
                Group snmpOptGroup = new Group(dialogArea, 0);
                snmpOptGroup.setText("SNMP Table Options");
                gd = new GridData();
                gd.horizontalAlignment = 4;
                gd.grabExcessHorizontalSpace = true;
                snmpOptGroup.setLayoutData((Object)gd);
                layout = new GridLayout();
                snmpOptGroup.setLayout((Layout)layout);
                new Label((Composite)snmpOptGroup, 0).setText("Use as index for second and subsequent columns:");
                this.radioIndexOID = new Button((Composite)snmpOptGroup, 16);
                this.radioIndexOID.setText("&OID suffix of first column");
                this.radioIndexOID.setSelection((this.objectTool.getFlags() & 0x10000) == 0);
                this.radioIndexValue = new Button((Composite)snmpOptGroup, 16);
                this.radioIndexValue.setText("&Value of first column");
                this.radioIndexValue.setSelection(!this.radioIndexOID.getSelection());
                break;
            }
            case 3: {
                this.textData.setLabel("Title");
                String[] parts = this.objectTool.getData().split("\u007f");
                this.textData.setText(parts.length > 0 ? parts[0] : "");
                this.textParameter = new LabeledText(dialogArea, 0);
                this.textParameter.setLabel("Parameter");
                gd = new GridData();
                gd.horizontalAlignment = 4;
                gd.grabExcessHorizontalSpace = true;
                this.textParameter.setLayoutData((Object)gd);
                this.textParameter.setText(parts.length > 1 ? parts[1] : "");
                this.textRegexp = new LabeledText(dialogArea, 0);
                this.textRegexp.setLabel("Regular expression");
                gd = new GridData();
                gd.horizontalAlignment = 4;
                gd.grabExcessHorizontalSpace = true;
                this.textRegexp.setLayoutData((Object)gd);
                this.textRegexp.setText(parts.length > 2 ? parts[2] : "");
            }
        }
        Group confirmationGroup = new Group(dialogArea, 0);
        confirmationGroup.setText("Confirmation");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        confirmationGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        confirmationGroup.setLayout((Layout)layout);
        this.checkConfirmation = new Button((Composite)confirmationGroup, 32);
        this.checkConfirmation.setText("This tool requires confirmation before execution");
        this.checkConfirmation.setSelection((this.objectTool.getFlags() & 8) != 0);
        this.checkConfirmation.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                General.this.textConfirmation.setEnabled(General.this.checkConfirmation.getSelection());
                if (General.this.checkConfirmation.getSelection()) {
                    General.this.textConfirmation.setFocus();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.textConfirmation = new LabeledText((Composite)confirmationGroup, 0);
        this.textConfirmation.setLabel("Confirmation message");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.textConfirmation.setLayoutData((Object)gd);
        this.textConfirmation.setText(this.objectTool.getConfirmationText());
        this.textConfirmation.setEnabled(this.checkConfirmation.getSelection());
        return dialogArea;
    }

    private void createOutputGroup(Composite parent) {
        Group outputGroup = new Group(parent, 0);
        outputGroup.setText("Execution options");
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        outputGroup.setLayoutData((Object)gd);
        outputGroup.setLayout((Layout)new GridLayout());
        this.checkOutput = new Button((Composite)outputGroup, 32);
        this.checkOutput.setText("Command generates output");
        this.checkOutput.setSelection((this.objectTool.getFlags() & 0x10) != 0);
    }

    protected void applyChanges(boolean isApply) {
        this.objectTool.setName(this.textName.getText());
        this.objectTool.setDescription(this.textDescription.getText());
        if (this.objectTool.getType() == 3) {
            this.objectTool.setData(String.valueOf(this.textData.getText()) + "\u007f" + this.textParameter.getText() + "\u007f" + this.textRegexp.getText());
        } else {
            this.objectTool.setData(this.textData.getText());
        }
        if (this.checkConfirmation.getSelection()) {
            this.objectTool.setFlags(this.objectTool.getFlags() | 8);
        } else {
            this.objectTool.setFlags(this.objectTool.getFlags() & 0xFFFFFFF7);
        }
        this.objectTool.setConfirmationText(this.textConfirmation.getText());
        if (this.objectTool.getType() == 2) {
            if (this.radioIndexValue.getSelection()) {
                this.objectTool.setFlags(this.objectTool.getFlags() | 0x10000);
            } else {
                this.objectTool.setFlags(this.objectTool.getFlags() & 0xFFFEFFFF);
            }
        }
        if (this.objectTool.getType() == 5 || this.objectTool.getType() == 6 || this.objectTool.getType() == 1) {
            if (this.checkOutput.getSelection()) {
                this.objectTool.setFlags(this.objectTool.getFlags() | 0x10);
            } else {
                this.objectTool.setFlags(this.objectTool.getFlags() & 0xFFFFFFEF);
            }
        }
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }
}

