/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.epp.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.netxms.api.client.SessionListener;
import org.netxms.api.client.SessionNotification;
import org.netxms.client.NXCListener;
import org.netxms.client.NXCSession;
import org.netxms.client.ServerAction;
import org.netxms.client.events.EventProcessingPolicy;
import org.netxms.client.events.EventProcessingPolicyRule;
import org.netxms.client.events.EventTemplate;
import org.netxms.ui.eclipse.epp.Activator;
import org.netxms.ui.eclipse.epp.widgets.RuleEditor;
import org.netxms.ui.eclipse.epp.widgets.helpers.ImageFactory;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.shared.SharedIcons;

public class EventProcessingPolicyEditor
extends ViewPart
implements ISaveablePart {
    public static final String ID = "org.netxms.ui.eclipse.epp.view.policy_editor";
    public static final String JOB_FAMILY = "PolicyEditorJob";
    private static final Color BACKGROUND_COLOR = new Color((Device)Display.getCurrent(), 255, 255, 255);
    private NXCSession session;
    private boolean policyLocked = false;
    private EventProcessingPolicy policy;
    private NXCListener sessionListener;
    private Map<Long, ServerAction> actions = new HashMap<Long, ServerAction>();
    private ScrolledComposite scroller;
    private Composite dataArea;
    private List<RuleEditor> ruleEditors = new ArrayList<RuleEditor>();
    private boolean verticalLayout = false;
    private boolean modified = false;
    private Set<RuleEditor> selection = new HashSet<RuleEditor>();
    private int lastSelectedRule = -1;
    private List<EventProcessingPolicyRule> clipboard = new ArrayList<EventProcessingPolicyRule>(0);
    private Font normalFont;
    private Font boldFont;
    private Image imageAlarm;
    private Image imageSituation;
    private Image imageExecute;
    private Image imageTerminate;
    private Image imageStop;
    private Image imageCollapse;
    private Image imageExpand;
    private Image imageEdit;
    private Action actionHorizontal;
    private Action actionVertical;
    private Action actionSave;
    private Action actionCollapseAll;
    private Action actionExpandAll;
    private Action actionInsertBefore;
    private Action actionInsertAfter;
    private Action actionCut;
    private Action actionCopy;
    private Action actionPaste;
    private Action actionDelete;
    private Action actionEnableRule;
    private Action actionDisableRule;

    public void createPartControl(Composite parent) {
        this.session = (NXCSession)ConsoleSharedData.getSession();
        try {
            Platform.getAdapterManager().loadAdapter((Object)new EventTemplate(0L), "org.eclipse.ui.model.IWorkbenchAdapter");
            Platform.getAdapterManager().loadAdapter((Object)new ServerAction(0L), "org.eclipse.ui.model.IWorkbenchAdapter");
            Platform.getAdapterManager().loadAdapter((Object)this.session.getTopLevelObjects()[0], "org.eclipse.ui.model.IWorkbenchAdapter");
        }
        catch (Exception exception) {}
        this.imageStop = Activator.getImageDescriptor("icons/stop.png").createImage();
        this.imageAlarm = Activator.getImageDescriptor("icons/alarm.png").createImage();
        this.imageSituation = Activator.getImageDescriptor("icons/situation.gif").createImage();
        this.imageExecute = Activator.getImageDescriptor("icons/execute.png").createImage();
        this.imageTerminate = Activator.getImageDescriptor("icons/terminate.png").createImage();
        this.imageCollapse = SharedIcons.COLLAPSE.createImage();
        this.imageExpand = SharedIcons.EXPAND.createImage();
        this.imageEdit = SharedIcons.EDIT.createImage();
        this.scroller = new ScrolledComposite(parent, 512);
        this.dataArea = new Composite((Composite)this.scroller, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        this.dataArea.setLayout((Layout)layout);
        this.dataArea.setBackground(BACKGROUND_COLOR);
        this.scroller.setContent((Control)this.dataArea);
        this.scroller.setExpandVertical(true);
        this.scroller.setExpandHorizontal(true);
        this.scroller.getVerticalBar().setIncrement(20);
        this.scroller.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = EventProcessingPolicyEditor.this.scroller.getClientArea();
                EventProcessingPolicyEditor.this.scroller.setMinSize(EventProcessingPolicyEditor.this.dataArea.computeSize(r.width, -1));
            }
        });
        if (Platform.getOS().equals("win32")) {
            this.normalFont = new Font((Device)parent.getDisplay(), "Verdana", 8, 0);
            this.boldFont = new Font((Device)parent.getDisplay(), "Verdana", 8, 1);
        } else {
            this.normalFont = JFaceResources.getDefaultFont();
            this.boldFont = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
        }
        this.sessionListener = new NXCListener(){

            public void notificationHandler(SessionNotification n) {
                EventProcessingPolicyEditor.this.processSessionNotification(n);
            }
        };
        this.session.addListener((SessionListener)this.sessionListener);
        this.createActions();
        this.contributeToActionBars();
        this.openEventProcessingPolicy();
    }

    private void createActions() {
        this.actionHorizontal = new Action("&Horizontal layout", 8){

            public void run() {
                EventProcessingPolicyEditor.this.verticalLayout = false;
                EventProcessingPolicyEditor.this.updateLayout();
            }
        };
        this.actionHorizontal.setChecked(!this.verticalLayout);
        this.actionHorizontal.setImageDescriptor(Activator.getImageDescriptor("icons/h_layout.gif"));
        this.actionVertical = new Action("&Vertical layout", 8){

            public void run() {
                EventProcessingPolicyEditor.this.verticalLayout = true;
                EventProcessingPolicyEditor.this.updateLayout();
            }
        };
        this.actionVertical.setChecked(this.verticalLayout);
        this.actionVertical.setImageDescriptor(Activator.getImageDescriptor("icons/v_layout.gif"));
        this.actionSave = new Action("&Save policy"){

            public void run() {
                EventProcessingPolicyEditor.this.savePolicy();
            }
        };
        this.actionSave.setImageDescriptor(SharedIcons.SAVE);
        this.actionSave.setEnabled(false);
        this.actionCollapseAll = new Action("&Collapse all"){

            public void run() {
                EventProcessingPolicyEditor.this.setAllRulesCollapsed(true);
            }
        };
        this.actionCollapseAll.setImageDescriptor(SharedIcons.COLLAPSE_ALL);
        this.actionExpandAll = new Action("&Expand all"){

            public void run() {
                EventProcessingPolicyEditor.this.setAllRulesCollapsed(false);
            }
        };
        this.actionExpandAll.setImageDescriptor(SharedIcons.EXPAND_ALL);
        this.actionDelete = new Action("&Delete"){

            public void run() {
                EventProcessingPolicyEditor.this.deleteSelectedRules();
            }
        };
        this.actionDelete.setImageDescriptor(SharedIcons.DELETE_OBJECT);
        this.actionDelete.setEnabled(false);
        this.actionInsertBefore = new Action("Insert &before"){

            public void run() {
                EventProcessingPolicyEditor.this.insertRule(EventProcessingPolicyEditor.this.lastSelectedRule - 1);
            }
        };
        this.actionInsertAfter = new Action("Insert &after"){

            public void run() {
                EventProcessingPolicyEditor.this.insertRule(EventProcessingPolicyEditor.this.lastSelectedRule);
            }
        };
        this.actionCut = new Action("Cu&t"){

            public void run() {
                EventProcessingPolicyEditor.this.cutRules();
            }
        };
        this.actionCut.setImageDescriptor(SharedIcons.CUT);
        this.actionCut.setEnabled(false);
        this.actionCopy = new Action("&Copy"){

            public void run() {
                EventProcessingPolicyEditor.this.copyRules();
            }
        };
        this.actionCopy.setImageDescriptor(SharedIcons.COPY);
        this.actionCopy.setEnabled(false);
        this.actionPaste = new Action("&Paste"){

            public void run() {
                EventProcessingPolicyEditor.this.pasteRules();
            }
        };
        this.actionPaste.setImageDescriptor(SharedIcons.PASTE);
        this.actionPaste.setEnabled(false);
        this.actionEnableRule = new Action("E&nable"){

            public void run() {
                EventProcessingPolicyEditor.this.enableRules(true);
            }
        };
        this.actionDisableRule = new Action("D&isable"){

            public void run() {
                EventProcessingPolicyEditor.this.enableRules(false);
            }
        };
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionSave);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionExpandAll);
        manager.add((IAction)this.actionCollapseAll);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionHorizontal);
        manager.add((IAction)this.actionVertical);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionEnableRule);
        manager.add((IAction)this.actionDisableRule);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionInsertBefore);
        manager.add((IAction)this.actionInsertAfter);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionCut);
        manager.add((IAction)this.actionCopy);
        manager.add((IAction)this.actionPaste);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionDelete);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionSave);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionExpandAll);
        manager.add((IAction)this.actionCollapseAll);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionHorizontal);
        manager.add((IAction)this.actionVertical);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionCut);
        manager.add((IAction)this.actionCopy);
        manager.add((IAction)this.actionPaste);
        manager.add((IAction)this.actionDelete);
    }

    private void openEventProcessingPolicy() {
        ConsoleJob job = new ConsoleJob("Open event processing policy", (IWorkbenchPart)this, "org.netxms.ui.eclipse.epp", JOB_FAMILY){

            protected String getErrorMessage() {
                return "Cannot open event processing policy";
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void runInternal(IProgressMonitor monitor) throws Exception {
                List actions = EventProcessingPolicyEditor.this.session.getActions();
                Map map = EventProcessingPolicyEditor.this.actions;
                synchronized (map) {
                    for (ServerAction a : actions) {
                        EventProcessingPolicyEditor.this.actions.put(a.getId(), a);
                    }
                }
                EventProcessingPolicyEditor.this.policy = EventProcessingPolicyEditor.this.session.openEventProcessingPolicy();
                EventProcessingPolicyEditor.this.policyLocked = true;
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        EventProcessingPolicyEditor.this.initPolicyEditor();
                    }
                });
            }

            protected void jobFailureHandler() {
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        EventProcessingPolicyEditor.this.getViewSite().getPage().hideView((IViewPart)EventProcessingPolicyEditor.this);
                    }
                });
            }
        };
        job.start();
    }

    private void initPolicyEditor() {
        int ruleNumber = 1;
        for (EventProcessingPolicyRule rule : this.policy.getRules()) {
            RuleEditor editor = new RuleEditor(this.dataArea, rule, ruleNumber++, this);
            this.ruleEditors.add(editor);
            GridData gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            editor.setLayoutData(gd);
        }
        this.dataArea.layout();
        Rectangle r = this.scroller.getClientArea();
        this.scroller.setMinSize(this.dataArea.computeSize(r.width, -1));
    }

    private void updateLayout() {
        for (RuleEditor editor : this.ruleEditors) {
            editor.setVerticalLayout(this.verticalLayout, false);
        }
        this.updateEditorAreaLayout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSessionNotification(SessionNotification n) {
        switch (n.getCode()) {
            case 1006: {
                Map<Long, ServerAction> map = this.actions;
                synchronized (map) {
                    this.actions.put(n.getSubCode(), (ServerAction)n.getObject());
                    break;
                }
            }
            case 1007: {
                Map<Long, ServerAction> map = this.actions;
                synchronized (map) {
                    this.actions.put(n.getSubCode(), (ServerAction)n.getObject());
                    break;
                }
            }
            case 1008: {
                Map<Long, ServerAction> map = this.actions;
                synchronized (map) {
                    this.actions.remove(n.getSubCode());
                    break;
                }
            }
        }
    }

    private void setAllRulesCollapsed(boolean collapsed) {
        for (RuleEditor editor : this.ruleEditors) {
            editor.setCollapsed(collapsed, false);
        }
        this.updateEditorAreaLayout();
    }

    public void setFocus() {
        this.dataArea.setFocus();
    }

    private void savePolicy() {
        this.actionSave.setEnabled(false);
        new ConsoleJob("Save event processing policy", (IWorkbenchPart)this, "org.netxms.ui.eclipse.epp", JOB_FAMILY){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                EventProcessingPolicyEditor.this.session.saveEventProcessingPolicy(EventProcessingPolicyEditor.this.policy);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        EventProcessingPolicyEditor.this.modified = false;
                        EventProcessingPolicyEditor.this.firePropertyChange(257);
                    }
                });
            }

            protected void jobFinalize() {
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        EventProcessingPolicyEditor.this.actionSave.setEnabled(EventProcessingPolicyEditor.this.modified);
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot save event processing policy";
            }
        }.start();
    }

    public void dispose() {
        if (this.sessionListener != null) {
            this.session.removeListener((SessionListener)this.sessionListener);
        }
        if (this.policyLocked) {
            new ConsoleJob("Close event processing policy", null, "org.netxms.ui.eclipse.epp", JOB_FAMILY){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    EventProcessingPolicyEditor.this.session.closeEventProcessingPolicy();
                }

                protected String getErrorMessage() {
                    return "Cannot close event processing policy";
                }
            }.start();
        }
        if (Platform.getOS().equals("win32")) {
            this.normalFont.dispose();
            this.boldFont.dispose();
        }
        this.imageStop.dispose();
        this.imageAlarm.dispose();
        this.imageExecute.dispose();
        this.imageTerminate.dispose();
        this.imageCollapse.dispose();
        this.imageExpand.dispose();
        this.imageEdit.dispose();
        super.dispose();
        ImageFactory.clearCache();
    }

    public void updateEditorAreaLayout() {
        this.dataArea.layout();
        Rectangle r = this.scroller.getClientArea();
        this.scroller.setMinSize(this.dataArea.computeSize(r.width, -1));
    }

    public ServerAction findActionById(Long id) {
        return this.actions.get(id);
    }

    public Map<Long, ServerAction> findServerActions(List<Long> idList) {
        HashMap<Long, ServerAction> resultSet = new HashMap<Long, ServerAction>();
        for (Long id : idList) {
            ServerAction action = this.actions.get(id);
            if (action == null) continue;
            resultSet.put(id, action);
        }
        return resultSet;
    }

    public Collection<ServerAction> getActions() {
        return this.actions.values();
    }

    public Font getNormalFont() {
        return this.normalFont;
    }

    public Font getBoldFont() {
        return this.boldFont;
    }

    public Image getImageAlarm() {
        return this.imageAlarm;
    }

    public Image getImageExecute() {
        return this.imageExecute;
    }

    public Image getImageTerminate() {
        return this.imageTerminate;
    }

    public Image getImageStop() {
        return this.imageStop;
    }

    public Image getImageCollapse() {
        return this.imageCollapse;
    }

    public Image getImageExpand() {
        return this.imageExpand;
    }

    public Image getImageEdit() {
        return this.imageEdit;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
        this.actionSave.setEnabled(modified);
        this.firePropertyChange(257);
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            this.session.saveEventProcessingPolicy(this.policy);
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getViewSite().getShell(), (String)"Error", (String)("Cannot save event processing policy: " + e.getMessage()));
        }
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.modified;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.modified;
    }

    private void clearSelection() {
        for (RuleEditor e : this.selection) {
            e.setSelected(false);
        }
        this.selection.clear();
        this.lastSelectedRule = -1;
    }

    public void setSelection(RuleEditor e) {
        this.clearSelection();
        this.addToSelection(e, false);
    }

    public void addToSelection(RuleEditor e, boolean allFromPrevSelection) {
        if (allFromPrevSelection && this.lastSelectedRule != -1) {
            int direction = Integer.signum(e.getRuleNumber() - this.lastSelectedRule);
            int i = this.lastSelectedRule + direction;
            while (i != e.getRuleNumber()) {
                RuleEditor r = this.ruleEditors.get(i - 1);
                this.selection.add(r);
                r.setSelected(true);
                i += direction;
            }
        }
        this.selection.add(e);
        e.setSelected(true);
        this.lastSelectedRule = e.getRuleNumber();
        this.onSelectionChange();
    }

    private void onSelectionChange() {
        this.actionDelete.setEnabled(this.selection.size() > 0);
        this.actionInsertBefore.setEnabled(this.selection.size() == 1);
        this.actionInsertAfter.setEnabled(this.selection.size() == 1);
        this.actionCut.setEnabled(this.selection.size() > 0);
        this.actionCopy.setEnabled(this.selection.size() > 0);
        this.actionPaste.setEnabled(this.selection.size() == 1 && !this.clipboard.isEmpty());
    }

    private void deleteSelectedRules() {
        for (RuleEditor e : this.selection) {
            this.policy.deleteRule(e.getRuleNumber() - 1);
            this.ruleEditors.remove((Object)e);
            e.dispose();
        }
        int i = 0;
        while (i < this.ruleEditors.size()) {
            this.ruleEditors.get(i).setRuleNumber(i + 1);
            ++i;
        }
        this.selection.clear();
        this.lastSelectedRule = -1;
        this.onSelectionChange();
        this.updateEditorAreaLayout();
        this.setModified(true);
    }

    private void insertRule(int position) {
        EventProcessingPolicyRule rule = new EventProcessingPolicyRule();
        this.policy.insertRule(rule, position);
        RuleEditor editor = new RuleEditor(this.dataArea, rule, position + 1, this);
        this.ruleEditors.add(position, editor);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        editor.setLayoutData(gd);
        int i = position + 1;
        while (i < this.ruleEditors.size()) {
            this.ruleEditors.get(i).setRuleNumber(i + 1);
            ++i;
        }
        if (position < this.ruleEditors.size() - 1) {
            editor.moveAbove((Control)this.ruleEditors.get(position + 1));
        }
        this.updateEditorAreaLayout();
        this.setModified(true);
    }

    private void cutRules() {
        this.clipboard.clear();
        this.actionPaste.setEnabled(true);
        for (RuleEditor e : this.selection) {
            this.clipboard.add(e.getRule());
            this.policy.deleteRule(e.getRuleNumber() - 1);
            this.ruleEditors.remove((Object)e);
            e.dispose();
        }
        int i = 0;
        while (i < this.ruleEditors.size()) {
            this.ruleEditors.get(i).setRuleNumber(i + 1);
            ++i;
        }
        this.selection.clear();
        this.lastSelectedRule = -1;
        this.onSelectionChange();
        this.updateEditorAreaLayout();
        this.setModified(true);
    }

    private void copyRules() {
        this.clipboard.clear();
        this.actionPaste.setEnabled(true);
        for (RuleEditor e : this.selection) {
            this.clipboard.add(new EventProcessingPolicyRule(e.getRule()));
        }
    }

    private void pasteRules() {
        int position = this.lastSelectedRule;
        for (EventProcessingPolicyRule rule : this.clipboard) {
            this.policy.insertRule(rule, position);
            RuleEditor editor = new RuleEditor(this.dataArea, rule, position + 1, this);
            this.ruleEditors.add(position, editor);
            GridData gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            editor.setLayoutData(gd);
            if (position < this.ruleEditors.size() - 1) {
                editor.moveAbove((Control)this.ruleEditors.get(position + 1));
            }
            ++position;
        }
        int i = position;
        while (i < this.ruleEditors.size()) {
            this.ruleEditors.get(i).setRuleNumber(i + 1);
            ++i;
        }
        this.updateEditorAreaLayout();
        this.setModified(true);
    }

    private void enableRules(boolean enabled) {
        for (RuleEditor e : this.selection) {
            e.enableRule(enabled);
        }
    }

    public void fillRuleContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionEnableRule);
        manager.add((IAction)this.actionDisableRule);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionInsertBefore);
        manager.add((IAction)this.actionInsertAfter);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionCut);
        manager.add((IAction)this.actionCopy);
        manager.add((IAction)this.actionPaste);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionDelete);
    }

    public Image getImageSituation() {
        return this.imageSituation;
    }
}

