/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.propertypages;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.datacollection.ColumnDefinition;
import org.netxms.client.datacollection.DataCollectionObject;
import org.netxms.client.datacollection.DataCollectionTable;
import org.netxms.ui.eclipse.datacollection.Activator;
import org.netxms.ui.eclipse.datacollection.dialogs.EditColumnDialog;
import org.netxms.ui.eclipse.datacollection.propertypages.helpers.TableColumnLabelProvider;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class TableColumns
extends PropertyPage {
    private static final String COLUMN_SETTINGS_PREFIX = "TableColumns.ColumnList";
    private DataCollectionTable dci;
    private List<ColumnDefinition> columns;
    private LabeledText instanceColumn;
    private TableViewer columnList;
    private Button addButton;
    private Button modifyButton;
    private Button deleteButton;

    protected Control createContents(Composite parent) {
        this.dci = (DataCollectionTable)this.getElement().getAdapter(DataCollectionTable.class);
        this.columns = new ArrayList<ColumnDefinition>();
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.instanceColumn = new LabeledText(dialogArea, 0);
        this.instanceColumn.setLabel("Instance column");
        this.instanceColumn.setText(this.dci.getInstanceColumn());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.instanceColumn.setLayoutData((Object)gd);
        Composite columnListArea = new Composite(dialogArea, 0);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = 2;
        columnListArea.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.verticalSpacing = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        columnListArea.setLayout((Layout)layout);
        new Label(columnListArea, 0).setText("Columns");
        this.columnList = new TableViewer(columnListArea, 67586);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = 2;
        this.columnList.getControl().setLayoutData((Object)gd);
        this.setupColumnList();
        this.columnList.setInput((Object)this.columns.toArray());
        Composite leftButtons = new Composite(columnListArea, 0);
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        leftButtons.setLayoutData((Object)gd);
        RowLayout buttonsLayout = new RowLayout(256);
        buttonsLayout.marginBottom = 0;
        buttonsLayout.marginLeft = 0;
        buttonsLayout.marginRight = 0;
        buttonsLayout.marginTop = 0;
        buttonsLayout.spacing = 4;
        buttonsLayout.fill = true;
        buttonsLayout.pack = false;
        leftButtons.setLayout((Layout)buttonsLayout);
        Composite buttons = new Composite(columnListArea, 0);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        buttons.setLayoutData((Object)gd);
        buttonsLayout = new RowLayout(256);
        buttonsLayout.marginBottom = 0;
        buttonsLayout.marginLeft = 0;
        buttonsLayout.marginRight = 0;
        buttonsLayout.marginTop = 0;
        buttonsLayout.spacing = 4;
        buttonsLayout.fill = true;
        buttonsLayout.pack = false;
        buttons.setLayout((Layout)buttonsLayout);
        this.addButton = new Button(buttons, 8);
        this.addButton.setText("&Add...");
        RowData rd = new RowData();
        rd.width = 90;
        this.addButton.setLayoutData((Object)rd);
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                TableColumns.this.addColumn();
            }
        });
        this.modifyButton = new Button(buttons, 8);
        this.modifyButton.setText("&Edit...");
        rd = new RowData();
        rd.width = 90;
        this.modifyButton.setLayoutData((Object)rd);
        this.modifyButton.setEnabled(false);
        this.modifyButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                TableColumns.this.editColumn();
            }
        });
        this.deleteButton = new Button(buttons, 8);
        this.deleteButton.setText("&Delete");
        rd = new RowData();
        rd.width = 90;
        this.deleteButton.setLayoutData((Object)rd);
        this.deleteButton.setEnabled(false);
        this.deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                TableColumns.this.deleteColumns();
            }
        });
        this.columnList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                TableColumns.this.modifyButton.setEnabled(selection.size() == 1);
                TableColumns.this.deleteButton.setEnabled(selection.size() > 0);
            }
        });
        this.columnList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TableColumns.this.editColumn();
            }
        });
        return dialogArea;
    }

    private void setupColumnList() {
        Table table = this.columnList.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn column = new TableColumn(table, 16384);
        column.setText("Name");
        column.setWidth(150);
        column = new TableColumn(table, 16384);
        column.setText("Display Name");
        column.setWidth(150);
        column = new TableColumn(table, 16384);
        column.setText("Type");
        column.setWidth(80);
        column = new TableColumn(table, 16384);
        column.setText("SNMP OID");
        column.setWidth(200);
        WidgetHelper.restoreColumnSettings((Table)table, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)COLUMN_SETTINGS_PREFIX);
        this.columnList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.columnList.setLabelProvider((IBaseLabelProvider)new TableColumnLabelProvider());
        this.columnList.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((ColumnDefinition)e1).getName().compareToIgnoreCase(((ColumnDefinition)e2).getName());
            }
        });
    }

    private void deleteColumns() {
        IStructuredSelection selection = (IStructuredSelection)this.columnList.getSelection();
        if (!selection.isEmpty()) {
            Iterator it = selection.iterator();
            while (it.hasNext()) {
                this.columns.remove(it.next());
            }
            this.columnList.setInput((Object)this.columns.toArray());
        }
    }

    private void editColumn() {
        IStructuredSelection selection = (IStructuredSelection)this.columnList.getSelection();
        if (selection.size() == 1) {
            ColumnDefinition column = (ColumnDefinition)selection.getFirstElement();
            EditColumnDialog dlg = new EditColumnDialog(this.getShell(), column);
            if (dlg.open() == 0) {
                this.columnList.update((Object)column, null);
            }
        }
    }

    private void addColumn() {
        InputDialog idlg = new InputDialog(this.getShell(), "New column definition", "Column name", "", new IInputValidator(){

            public String isValid(String newText) {
                if (newText.trim().isEmpty()) {
                    return "Please enter non-empty column name";
                }
                return null;
            }
        });
        if (idlg.open() == 0) {
            ColumnDefinition column = new ColumnDefinition(idlg.getValue());
            EditColumnDialog dlg = new EditColumnDialog(this.getShell(), column);
            if (dlg.open() == 0) {
                this.columns.add(column);
                this.columnList.setInput((Object)this.columns.toArray());
                this.columnList.setSelection((ISelection)new StructuredSelection((Object)column));
            }
        }
    }

    protected void applyChanges(final boolean isApply) {
        if (isApply) {
            this.setValid(false);
        }
        this.dci.setInstanceColumn(this.instanceColumn.getText());
        this.dci.getColumns().clear();
        this.dci.getColumns().addAll(this.columns);
        new ConsoleJob("Update table columns for DCI " + this.dci.getId(), null, "org.netxms.ui.eclipse.datacollection", null){

            protected String getErrorMessage() {
                return "Cannot update table columns";
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                TableColumns.this.dci.getOwner().modifyObject((DataCollectionObject)TableColumns.this.dci);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        ((TableViewer)TableColumns.this.dci.getOwner().getUserData()).update((Object)TableColumns.this.dci, null);
                    }
                });
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            TableColumns.this.setValid(true);
                        }
                    });
                }
            }
        }.start();
    }

    protected void performApply() {
        this.saveSettings();
        this.applyChanges(true);
    }

    public boolean performOk() {
        this.saveSettings();
        this.applyChanges(false);
        return true;
    }

    public boolean performCancel() {
        this.saveSettings();
        return true;
    }

    private void saveSettings() {
        WidgetHelper.saveColumnSettings((Table)this.columnList.getTable(), (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)COLUMN_SETTINGS_PREFIX);
    }
}

