/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.charts.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.LeaderLineStyle;
import org.eclipse.birt.chart.model.attribute.LegendItemType;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.RiserType;
import org.eclipse.birt.chart.model.attribute.Text;
import org.eclipse.birt.chart.model.attribute.impl.LineAttributesImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.TextDataSet;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.data.impl.TextDataSetImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.impl.ChartWithoutAxesImpl;
import org.eclipse.birt.chart.model.type.BarSeries;
import org.eclipse.birt.chart.model.type.PieSeries;
import org.eclipse.birt.chart.model.type.impl.BarSeriesImpl;
import org.eclipse.birt.chart.model.type.impl.PieSeriesImpl;
import org.eclipse.swt.widgets.Composite;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.client.datacollection.Threshold;
import org.netxms.ui.eclipse.charts.api.ChartColor;
import org.netxms.ui.eclipse.charts.api.DataComparisonChart;
import org.netxms.ui.eclipse.charts.widgets.GenericBirtChart;
import org.netxms.ui.eclipse.charts.widgets.internal.DataComparisonElement;

public class DataComparisonBirtChart
extends GenericBirtChart
implements DataComparisonChart {
    private static final String CHART_FONT_NAME = "Verdana";
    private static final int CHART_FONT_SIZE_TITLE = 9;
    private static final int CHART_FONT_SIZE_LEGEND = 8;
    private static final int CHART_FONT_SIZE_AXIS = 8;
    private int chartType = 0;
    private List<DataComparisonElement> parameters = new ArrayList<DataComparisonElement>(16);
    private Axis xAxis = null;
    private Axis yAxis = null;
    private Series valueSeries = null;
    private boolean transposed = false;
    private boolean labelsVisible = false;
    private double rotation = 0.0;

    public DataComparisonBirtChart(Composite parent, int style, int chartType) {
        super(parent, style);
        this.chartType = chartType;
        if (chartType == 1 || chartType == 4) {
            this.labelsVisible = true;
        }
    }

    @Override
    protected Chart createChart() {
        ChartWithoutAxes chart;
        switch (this.chartType) {
            case 0: 
            case 3: {
                chart = this.createChartWithAxes();
                break;
            }
            case 1: {
                chart = this.createChartWithoutAxes();
                break;
            }
            default: {
                chart = ChartWithoutAxesImpl.create();
                chart.getTitle().setVisible(false);
            }
        }
        return chart;
    }

    private Chart createChartWithAxes() {
        ChartWithAxes chart = ChartWithAxesImpl.create();
        chart.setDimension(this.is3DModeEnabled() ? ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL : ChartDimension.TWO_DIMENSIONAL_LITERAL);
        chart.setTransposed(this.transposed);
        chart.getBlock().setBackground((Fill)this.getColorFromPreferences("Chart.Colors.Background"));
        chart.getPlot().setBackground((Fill)this.getColorFromPreferences("Chart.Colors.Background"));
        chart.getPlot().getClientArea().setBackground((Fill)this.getColorFromPreferences("Chart.Colors.PlotArea"));
        Text tc = chart.getTitle().getLabel().getCaption();
        tc.setValue(this.getChartTitle());
        tc.getFont().setSize(11.0f);
        tc.getFont().setName(CHART_FONT_NAME);
        tc.getFont().setSize(9.0f);
        tc.getFont().setBold(false);
        chart.getTitle().setVisible(this.isTitleVisible());
        chart.getLegend().setItemType(LegendItemType.CATEGORIES_LITERAL);
        chart.getLegend().setVisible(this.isLegendVisible());
        chart.getLegend().setPosition(this.positionFromInt(this.legendPosition));
        chart.getLegend().setBackground((Fill)this.getColorFromPreferences("Chart.Colors.Background"));
        chart.getLegend().getText().getFont().setName(CHART_FONT_NAME);
        chart.getLegend().getText().getFont().setSize(8.0f);
        chart.getLegend().getText().getFont().setBold(false);
        this.xAxis = chart.getPrimaryBaseAxes()[0];
        this.xAxis.getTitle().setVisible(false);
        this.xAxis.getLabel().setVisible(false);
        this.yAxis = chart.getPrimaryOrthogonalAxis(this.xAxis);
        this.yAxis.getTitle().setVisible(false);
        this.yAxis.getScale().setMin((DataElement)NumberDataElementImpl.create((double)0.0));
        this.yAxis.getMajorGrid().setLineAttributes(LineAttributesImpl.create((ColorDefinition)this.getColorFromPreferences("Chart.Grid.Y.Color"), (LineStyle)LineStyle.DOTTED_LITERAL, (int)0));
        this.yAxis.setType(this.useLogScale ? AxisType.LOGARITHMIC_LITERAL : AxisType.LINEAR_LITERAL);
        this.yAxis.getLabel().getCaption().getFont().setName(CHART_FONT_NAME);
        this.yAxis.getLabel().getCaption().getFont().setSize(8.0f);
        TextDataSet categoryValues = TextDataSetImpl.create((Object)this.getElementNames());
        Series seCategory = SeriesImpl.create();
        seCategory.setDataSet((DataSet)categoryValues);
        SeriesDefinition sdX = SeriesDefinitionImpl.create();
        sdX.setSeriesPalette(this.getBirtPalette());
        this.xAxis.getSeriesDefinitions().add((Object)sdX);
        sdX.getSeries().add((Object)seCategory);
        NumberDataSet valuesDataSet = NumberDataSetImpl.create((Object)this.getElementValues());
        this.valueSeries = this.createSeriesImplementation();
        this.valueSeries.setDataSet((DataSet)valuesDataSet);
        SeriesDefinition sdY = SeriesDefinitionImpl.create();
        this.yAxis.getSeriesDefinitions().add((Object)sdY);
        sdY.getSeries().add((Object)this.valueSeries);
        return chart;
    }

    private Chart createChartWithoutAxes() {
        ChartWithoutAxes chart = ChartWithoutAxesImpl.create();
        chart.setDimension(this.is3DModeEnabled() ? ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL : ChartDimension.TWO_DIMENSIONAL_LITERAL);
        chart.getBlock().setBackground((Fill)this.getColorFromPreferences("Chart.Colors.Background"));
        chart.getPlot().setBackground((Fill)this.getColorFromPreferences("Chart.Colors.Background"));
        chart.getPlot().getClientArea().setBackground((Fill)this.getColorFromPreferences("Chart.Colors.Background"));
        Text tc = chart.getTitle().getLabel().getCaption();
        tc.setValue(this.getChartTitle());
        tc.getFont().setSize(11.0f);
        tc.getFont().setName(CHART_FONT_NAME);
        tc.getFont().setSize(9.0f);
        tc.getFont().setBold(false);
        chart.getTitle().setVisible(this.isTitleVisible());
        chart.getLegend().setItemType(LegendItemType.CATEGORIES_LITERAL);
        chart.getLegend().setVisible(this.isLegendVisible());
        chart.getLegend().setPosition(this.positionFromInt(this.legendPosition));
        chart.getLegend().setBackground((Fill)this.getColorFromPreferences("Chart.Colors.Background"));
        chart.getLegend().getText().getFont().setName(CHART_FONT_NAME);
        chart.getLegend().getText().getFont().setSize(8.0f);
        chart.getLegend().getText().getFont().setBold(false);
        SeriesDefinition sdCategory = SeriesDefinitionImpl.create();
        sdCategory.setSeriesPalette(this.getBirtPalette());
        Series seCategory = SeriesImpl.create();
        seCategory.setDataSet((DataSet)TextDataSetImpl.create((Object)this.getElementNames()));
        sdCategory.getSeries().add((Object)seCategory);
        chart.getSeriesDefinitions().add((Object)sdCategory);
        SeriesDefinition sdValues = SeriesDefinitionImpl.create();
        NumberDataSet valuesDataSet = NumberDataSetImpl.create((Object)this.getElementValues());
        this.valueSeries = this.createSeriesImplementation();
        this.valueSeries.setDataSet((DataSet)valuesDataSet);
        sdValues.getSeries().add((Object)this.valueSeries);
        sdCategory.getSeriesDefinitions().add((Object)sdValues);
        return chart;
    }

    private Series createSeriesImplementation() {
        switch (this.chartType) {
            case 0: 
            case 3: {
                BarSeries bs = (BarSeries)BarSeriesImpl.create();
                bs.setTranslucent(this.translucent);
                if (this.chartType == 3) {
                    bs.setRiser(RiserType.TUBE_LITERAL);
                }
                bs.getLabel().setVisible(this.labelsVisible);
                return bs;
            }
            case 1: {
                PieSeries ps = (PieSeries)PieSeriesImpl.create();
                ps.setRotation(this.rotation);
                if (this.is3DModeEnabled()) {
                    ps.setExplosion(3);
                    ps.setRatio(0.4);
                } else {
                    ps.setExplosion(0);
                    ps.setRatio(1.0);
                }
                ps.setTranslucent(this.translucent);
                ps.getLabel().setVisible(this.labelsVisible);
                if (this.labelsVisible) {
                    ps.setLabelPosition(Position.OUTSIDE_LITERAL);
                    ps.setLeaderLineStyle(LeaderLineStyle.FIXED_LENGTH_LITERAL);
                    ps.getLeaderLineAttributes().setVisible(true);
                    ps.getLabel().getCaption().getFont().setName(CHART_FONT_NAME);
                    ps.getLabel().getCaption().getFont().setSize(8.0f);
                }
                return ps;
            }
        }
        return null;
    }

    private String[] getElementNames() {
        String[] names = new String[this.parameters.size()];
        int i = 0;
        while (i < names.length) {
            names[i] = this.parameters.get(i).getName();
            ++i;
        }
        return names;
    }

    private double[] getElementValues() {
        double[] values = new double[this.parameters.size()];
        int i = 0;
        while (i < values.length) {
            values[i] = this.parameters.get(i).getValue();
            ++i;
        }
        return values;
    }

    @Override
    public int getChartType() {
        return this.chartType;
    }

    @Override
    public void setChartType(int chartType) {
        if (this.chartType != chartType && this.getChart() != null) {
            this.chartType = chartType;
            this.recreateChart();
        } else {
            this.chartType = chartType;
        }
    }

    @Override
    public int addParameter(GraphItem dci, double value) {
        this.parameters.add(new DataComparisonElement(dci, value));
        return this.parameters.size() - 1;
    }

    @Override
    public void updateParameter(int index, double value, boolean updateChart) {
        try {
            this.parameters.get(index).setValue(value);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        if (updateChart) {
            this.refresh();
        }
    }

    @Override
    public void updateParameterThresholds(int index, Threshold[] thresholds) {
        try {
            this.parameters.get(index).setThresholds(thresholds);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
    }

    @Override
    public void refresh() {
        if (this.valueSeries == null) {
            return;
        }
        this.valueSeries.setDataSet((DataSet)NumberDataSetImpl.create((Object)this.getElementValues()));
        super.refresh();
    }

    @Override
    public void setTransposed(boolean transposed) {
        this.transposed = transposed;
        if (this.getChart() != null) {
            this.recreateChart();
        }
    }

    @Override
    public boolean isTransposed() {
        return this.transposed;
    }

    @Override
    public boolean hasAxes() {
        return this.chartType == 0;
    }

    @Override
    public void setLabelsVisible(boolean visible) {
        this.labelsVisible = visible;
        if (this.getChart() != null) {
            this.recreateChart();
        }
    }

    @Override
    public boolean isLabelsVisible() {
        return this.labelsVisible;
    }

    @Override
    public void setRotation(double angle) {
        this.rotation = angle;
        if (this.getChart() != null) {
            this.recreateChart();
        }
    }

    @Override
    public double getRotation() {
        return this.rotation;
    }

    @Override
    public boolean isGridVisible() {
        return false;
    }

    @Override
    public void setGridVisible(boolean visible) {
    }

    @Override
    public void setBackgroundColor(ChartColor color) {
    }

    @Override
    public void setPlotAreaColor(ChartColor color) {
    }

    @Override
    public void setLegendColor(ChartColor foreground, ChartColor background) {
    }

    @Override
    public void setAxisColor(ChartColor color) {
    }

    @Override
    public void setGridColor(ChartColor color) {
    }

    @Override
    public void addError(String message) {
    }

    @Override
    public void clearErrors() {
    }
}

