/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.objecttabs.elements;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.objects.ServiceContainer;
import org.netxms.ui.eclipse.charts.api.ChartColor;
import org.netxms.ui.eclipse.charts.api.ChartFactory;
import org.netxms.ui.eclipse.charts.api.DataComparisonChart;
import org.netxms.ui.eclipse.objectview.objecttabs.elements.OverviewPageElement;
import org.netxms.ui.eclipse.shared.SharedColors;
import org.netxms.ui.eclipse.tools.ColorCache;
import org.netxms.ui.eclipse.tools.ColorConverter;

public class AvailabilityChart
extends OverviewPageElement {
    DataComparisonChart dayChart;
    DataComparisonChart weekChart;
    DataComparisonChart monthChart;
    ColorCache colors;

    public AvailabilityChart(Composite parent, GenericObject object) {
        super(parent, object);
    }

    @Override
    protected String getTitle() {
        return "Availability";
    }

    @Override
    void onObjectChange() {
        ServiceContainer service = (ServiceContainer)this.getObject();
        this.dayChart.updateParameter(0, service.getUptimeForDay(), false);
        this.dayChart.updateParameter(1, 100.0 - service.getUptimeForDay(), true);
        this.weekChart.updateParameter(0, service.getUptimeForWeek(), false);
        this.weekChart.updateParameter(1, 100.0 - service.getUptimeForWeek(), true);
        this.monthChart.updateParameter(0, service.getUptimeForMonth(), false);
        this.monthChart.updateParameter(1, 100.0 - service.getUptimeForMonth(), true);
    }

    protected Control createClientArea(Composite parent) {
        Composite clientArea = new Composite(parent, 0);
        this.colors = new ColorCache((Control)clientArea);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        clientArea.setLayout((Layout)layout);
        this.dayChart = this.createChart(clientArea, "Today");
        this.weekChart = this.createChart(clientArea, "This Week");
        this.monthChart = this.createChart(clientArea, "This Month");
        Canvas legend = new Canvas(clientArea, 0);
        legend.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                AvailabilityChart.this.paintLegend(e.gc);
            }
        });
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        legend.setLayoutData((Object)gd);
        return clientArea;
    }

    private DataComparisonChart createChart(Composite parent, String title) {
        DataComparisonChart chart = ChartFactory.createPieChart((Composite)parent, (int)0);
        chart.setTitleVisible(true);
        chart.set3DModeEnabled(true);
        chart.setChartTitle(title);
        chart.setLegendVisible(false);
        chart.setLabelsVisible(false);
        chart.setRotation(225.0);
        chart.addParameter(new GraphItem(0L, 0L, 0, 0, "Up", "Up"), 100.0);
        chart.addParameter(new GraphItem(0L, 0L, 0, 0, "Down", "Down"), 0.0);
        chart.setPaletteEntry(0, new ChartColor(127, 154, 72));
        chart.setPaletteEntry(1, new ChartColor(158, 65, 62));
        chart.initializationComplete();
        GridData gd = new GridData();
        gd.widthHint = 250;
        gd.heightHint = 190;
        ((Control)chart).setLayoutData((Object)gd);
        return chart;
    }

    private void paintLegend(GC gc) {
        int th = gc.textExtent((String)"UptimeDowntime").y;
        gc.setBackground(this.colors.create(127, 154, 72));
        gc.setForeground(ColorConverter.adjustColor((Color)gc.getBackground(), (Color)SharedColors.BLACK, (float)0.2f, (ColorCache)this.colors));
        gc.fillRectangle(5, 10, th, th);
        gc.drawRectangle(5, 10, th, th);
        gc.setBackground(this.colors.create(158, 65, 62));
        gc.setForeground(ColorConverter.adjustColor((Color)gc.getBackground(), (Color)SharedColors.BLACK, (float)0.2f, (ColorCache)this.colors));
        gc.fillRectangle(5, 40, th, th);
        gc.drawRectangle(5, 40, th, th);
        gc.setForeground(SharedColors.BLACK);
        gc.drawText("Uptime", 10 + th, 10, true);
        gc.drawText("Downtime", 10 + th, 40, true);
    }

    @Override
    public boolean isApplicableForObject(GenericObject object) {
        return object instanceof ServiceContainer;
    }
}

