/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.reporter.widgets;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.netxms.client.objects.GenericObject;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.reporter.widgets.FieldEditor;
import org.netxms.ui.eclipse.reporter.widgets.helpers.ReportParameter;
import org.netxms.ui.eclipse.shared.SharedIcons;

public class ObjectListFieldEditor
extends FieldEditor {
    private TableViewer viewer;
    private Map<Long, GenericObject> objects = new HashMap<Long, GenericObject>();

    public ObjectListFieldEditor(ReportParameter parameter, FormToolkit toolkit, Composite parent) {
        super(parameter, toolkit, parent);
    }

    @Override
    protected void createContent(Composite parent) {
        Composite content = this.toolkit.createComposite(parent, 0);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 128;
        content.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        content.setLayout((Layout)layout);
        this.viewer = new TableViewer(content, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.viewer.setInput((Object)new Object[0]);
        ImageHyperlink link = this.toolkit.createImageHyperlink(content, 0);
        link.setImage(SharedIcons.IMG_ADD_OBJECT);
        link.setText("Add...");
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ObjectListFieldEditor.this.addObjects();
            }
        });
        link = this.toolkit.createImageHyperlink(content, 0);
        link.setImage(SharedIcons.IMG_DELETE_OBJECT);
        link.setText("Delete");
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ObjectListFieldEditor.this.deleteObjects();
            }
        });
    }

    private void addObjects() {
        ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.getShell(), null, ObjectSelectionDialog.createNodeSelectionFilter());
        if (dlg.open() == 0) {
            for (GenericObject o : dlg.getSelectedObjects()) {
                this.objects.put(o.getObjectId(), o);
            }
            this.viewer.setInput((Object)this.objects.values().toArray());
        }
    }

    private void deleteObjects() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        for (Object o : selection.toList()) {
            this.objects.remove(((GenericObject)o).getObjectId());
        }
        this.viewer.setInput((Object)this.objects.values().toArray());
    }

    @Override
    public String getValue() {
        if (this.objects.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (GenericObject o : this.objects.values()) {
            sb.append(o.getObjectId());
            sb.append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }
}

