/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.base;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.X509EncodedKeySpec;
import java.util.zip.CRC32;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.netxms.base.NXCPDataInputStream;
import org.netxms.base.NXCPException;
import org.netxms.base.NXCPMessage;

public final class EncryptionContext {
    private static final String[] CIPHERS = new String[]{"AES", "Blowfish", null, null, "AES"};
    private static int[] KEY_LENGTHS = new int[]{256, 256, 0, 0, 128};
    private static final String CIPHER_MODE = "/CBC/PKCS5Padding";
    private int cipher;
    private int keyLength;
    private Cipher encryptor;
    private Cipher decryptor;
    private SecretKey key;
    private IvParameterSpec iv;

    public static EncryptionContext createInstance(NXCPMessage request) throws NXCPException {
        int serverCiphers = request.getVariableAsInteger(122L);
        int selectedCipher = -1;
        for (int i = 0; i < CIPHERS.length; ++i) {
            if (CIPHERS[i] == null || (serverCiphers & 1 << i) == 0) continue;
            try {
                Cipher.getInstance(CIPHERS[i]);
                if (Cipher.getMaxAllowedKeyLength(CIPHERS[i]) < KEY_LENGTHS[i]) continue;
                selectedCipher = i;
                break;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (selectedCipher != -1) {
            try {
                return new EncryptionContext(selectedCipher);
            }
            catch (Exception e) {
                throw new NXCPException(3, (Throwable)e);
            }
        }
        throw new NXCPException(3);
    }

    protected EncryptionContext(int cipher) throws GeneralSecurityException {
        this.cipher = cipher;
        this.keyLength = KEY_LENGTHS[cipher];
        KeyGenerator keyGen = KeyGenerator.getInstance(CIPHERS[cipher]);
        keyGen.init(KEY_LENGTHS[cipher]);
        this.key = keyGen.generateKey();
        byte[] ivBytes = new byte[16];
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
        random.nextBytes(ivBytes);
        this.iv = new IvParameterSpec(ivBytes);
        this.encryptor = Cipher.getInstance(CIPHERS[cipher] + CIPHER_MODE);
        this.decryptor = Cipher.getInstance(CIPHERS[cipher] + CIPHER_MODE);
    }

    public byte[] getEncryptedSessionKey(NXCPMessage msg) throws GeneralSecurityException {
        byte[] pkeyBytes = msg.getVariableAsBinary(154L);
        PublicKey publicKey = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(pkeyBytes));
        Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA1AndMGF1Padding");
        cipher.init(1, publicKey);
        return cipher.doFinal(this.key.getEncoded());
    }

    public byte[] getEncryptedIv(NXCPMessage msg) throws GeneralSecurityException {
        byte[] pkeyBytes = msg.getVariableAsBinary(154L);
        PublicKey publicKey = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(pkeyBytes));
        Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA1AndMGF1Padding");
        cipher.init(1, publicKey);
        return cipher.doFinal(this.iv.getIV());
    }

    private byte[] encryptPayloadHeader(byte[] msgBytes) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(byteStream);
        CRC32 crc32 = new CRC32();
        crc32.update(msgBytes);
        outputStream.writeInt((int)crc32.getValue());
        outputStream.writeInt(0);
        return this.encryptor.update(byteStream.toByteArray());
    }

    public byte[] encryptMessage(NXCPMessage msg) throws IOException, GeneralSecurityException {
        byte[] msgBytes = msg.createNXCPMessage();
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(byteStream);
        outputStream.writeShort(131);
        outputStream.writeByte(0);
        outputStream.writeByte(0);
        outputStream.writeInt(0);
        this.encryptor.init(1, (Key)this.key, this.iv);
        byte[] ph = this.encryptPayloadHeader(msgBytes);
        if (ph != null) {
            outputStream.write(ph);
        }
        outputStream.write(this.encryptor.update(msgBytes));
        outputStream.write(this.encryptor.doFinal());
        int padding = 8 - byteStream.size() % 8 & 7;
        for (int i = 0; i < padding; ++i) {
            outputStream.writeByte(0);
        }
        byte[] encryptedMessage = byteStream.toByteArray();
        encryptedMessage[2] = (byte)padding;
        encryptedMessage[4] = (byte)(encryptedMessage.length >> 24);
        encryptedMessage[5] = (byte)(encryptedMessage.length >> 16 & 0xFF);
        encryptedMessage[6] = (byte)(encryptedMessage.length >> 8 & 0xFF);
        encryptedMessage[7] = (byte)(encryptedMessage.length & 0xFF);
        return encryptedMessage;
    }

    public byte[] decryptMessage(NXCPDataInputStream inputStream, int length) throws GeneralSecurityException, IOException {
        int bytesRead;
        this.decryptor.init(2, (Key)this.key, this.iv);
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        for (int bytes = length; bytes > 0; bytes -= bytesRead) {
            bytesRead = inputStream.read(buffer, 0, Math.min(buffer.length, bytes));
            byteStream.write(this.decryptor.update(buffer, 0, bytesRead));
        }
        byteStream.write(this.decryptor.doFinal());
        return byteStream.toByteArray();
    }

    public int getCipher() {
        return this.cipher;
    }

    public int getKeyLength() {
        return this.keyLength / 8;
    }

    public int getIvLength() {
        return this.iv.getIV().length;
    }
}

