/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.events;

import java.util.Date;
import org.netxms.base.NXCPMessage;

public class Event {
    private final long id;
    private final int code;
    private final Date timeStamp;
    private final long sourceId;
    private final int severity;
    private final String message;
    private final String userTag;
    private final String[] parameters;

    public Event(NXCPMessage msg, long baseId) {
        long varId = baseId;
        this.id = msg.getVariableAsInt64(varId++);
        this.code = msg.getVariableAsInteger(varId++);
        this.timeStamp = msg.getVariableAsDate(varId++);
        this.sourceId = msg.getVariableAsInt64(varId++);
        this.severity = msg.getVariableAsInteger(varId++);
        this.message = msg.getVariableAsString(varId++);
        this.userTag = msg.getVariableAsString(varId++);
        int count = msg.getVariableAsInteger(varId++);
        this.parameters = new String[count];
        for (int i = 0; i < count; ++i) {
            this.parameters[i] = msg.getVariableAsString(varId++);
        }
    }

    public long getId() {
        return this.id;
    }

    public int getCode() {
        return this.code;
    }

    public Date getTimeStamp() {
        return this.timeStamp;
    }

    public long getSourceId() {
        return this.sourceId;
    }

    public int getSeverity() {
        return this.severity;
    }

    public String getMessage() {
        return this.message;
    }

    public String getUserTag() {
        return this.userTag;
    }

    public String[] getParameters() {
        return this.parameters;
    }
}

