/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objects;

import org.netxms.base.NXCPMessage;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.GenericObject;

public class Container
extends GenericObject {
    public static final int CF_AUTO_BIND = 1;
    public static final int CF_AUTO_UNBIND = 2;
    private int category;
    private int flags;
    private String autoBindFilter;

    public Container(NXCPMessage msg, NXCSession session) {
        super(msg, session);
        this.category = msg.getVariableAsInteger(75L);
        this.flags = msg.getVariableAsInteger(13L);
        this.autoBindFilter = msg.getVariableAsString(321L);
    }

    public int getCategory() {
        return this.category;
    }

    public boolean isAutoBindEnabled() {
        return (this.flags & 1) != 0;
    }

    public boolean isAutoUnbindEnabled() {
        return (this.flags & 2) != 0;
    }

    public String getAutoBindFilter() {
        return this.autoBindFilter;
    }

    @Override
    public String getObjectClassName() {
        return "Container";
    }

    public int getFlags() {
        return this.flags;
    }
}

