/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.osm.tools;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.GeoLocation;
import org.netxms.client.NXCSession;
import org.netxms.ui.eclipse.osm.Activator;
import org.netxms.ui.eclipse.osm.GeoLocationCache;
import org.netxms.ui.eclipse.osm.tools.Area;
import org.netxms.ui.eclipse.osm.tools.Tile;
import org.netxms.ui.eclipse.osm.tools.TileSet;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class MapLoader {
    public static final int CENTER = 0;
    public static final int TOP_LEFT = 1;
    public static final int BOTTOM_RIGHT = 2;
    private static String CACHE_MUTEX = "cache_mutex";
    private Display display;
    private Image missingTile = null;
    private Image loadingTile = null;
    private Image borderTile = null;

    public MapLoader(Display display) {
        this.display = display;
    }

    private static Point tileFromLocation(double lat, double lon, int zoom) {
        int x = (int)Math.floor((lon + 180.0) / 360.0 * (double)(1 << zoom));
        int y = (int)Math.floor((1.0 - Math.log(Math.tan(Math.toRadians(lat)) + 1.0 / Math.cos(Math.toRadians(lat))) / Math.PI) / 2.0 * (double)(1 << zoom));
        return new Point(x, y);
    }

    private static double longitudeFromTile(int x, int z) {
        return (double)x / Math.pow(2.0, z) * 360.0 - 180.0;
    }

    private static double latitudeFromTile(int y, int z) {
        double n = Math.PI - Math.PI * 2 * (double)y / Math.pow(2.0, z);
        return Math.toDegrees(Math.atan(Math.sinh(n)));
    }

    private Image getMissingTileImage() {
        if (this.missingTile == null) {
            this.missingTile = Activator.getImageDescriptor("icons/missing_tile.png").createImage();
        }
        return this.missingTile;
    }

    private Image getLoadingTileImage() {
        if (this.loadingTile == null) {
            this.loadingTile = Activator.getImageDescriptor("icons/loading_tile.png").createImage();
        }
        return this.loadingTile;
    }

    private Image getBorderTileImage() {
        if (this.borderTile == null) {
            this.borderTile = Activator.getImageDescriptor("icons/border_tile.png").createImage();
        }
        return this.borderTile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image loadTile(int zoom, int x, int y) {
        int maxTileNum = (1 << zoom) - 1;
        if (x < 0 || y < 0 || x > maxTileNum || y > maxTileNum) {
            return this.getBorderTileImage();
        }
        String tileServerURL = ((NXCSession)ConsoleSharedData.getSession()).getTileServerURL();
        URL url = null;
        try {
            url = new URL(String.valueOf(tileServerURL) + zoom + "/" + x + "/" + y + ".png");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
        ImageDescriptor id = ImageDescriptor.createFromURL((URL)url);
        Image image = id.createImage(false, (Device)this.display);
        if (image != null) {
            String string = CACHE_MUTEX;
            synchronized (string) {
                File imageFile = MapLoader.buildCacheFileName(zoom, x, y);
                imageFile.getParentFile().mkdirs();
                ImageLoader imageLoader = new ImageLoader();
                imageLoader.data = new ImageData[]{image.getImageData()};
                imageLoader.save(imageFile.getAbsolutePath(), 5);
            }
        }
        return image;
    }

    private static File buildCacheFileName(int zoom, int x, int y) {
        File targetDir;
        Location loc = Platform.getInstanceLocation();
        try {
            targetDir = new File(loc.getURL().toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            targetDir = new File(loc.getURL().getPath());
        }
        StringBuilder sb = new StringBuilder("OSM");
        sb.append(File.separatorChar);
        sb.append(zoom);
        sb.append(File.separatorChar);
        sb.append(x);
        sb.append(File.separatorChar);
        sb.append(y);
        sb.append(".png");
        return new File(targetDir, sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image loadTileFromCache(int zoom, int x, int y) {
        try {
            File imageFile = MapLoader.buildCacheFileName(zoom, x, y);
            String string = CACHE_MUTEX;
            synchronized (string) {
                if (imageFile.canRead()) {
                    return new Image((Device)this.display, imageFile.getAbsolutePath());
                }
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Tile getTile(int zoom, int x, int y, boolean cachedOnly) {
        int maxTileNum = (1 << zoom) - 1;
        if (x < 0 || y < 0 || x > maxTileNum || y > maxTileNum) {
            return new Tile(x, y, this.getBorderTileImage(), true, true);
        }
        Image tileImage = this.loadTileFromCache(zoom, x, y);
        if (tileImage == null) {
            if (cachedOnly) {
                return new Tile(x, y, this.getLoadingTileImage(), false, true);
            }
            tileImage = this.loadTile(zoom, x, y);
        }
        return tileImage != null ? new Tile(x, y, tileImage, true, false) : new Tile(x, y, this.getMissingTileImage(), true, true);
    }

    public static Rectangle calculateBoundingBox(Point mapSize, GeoLocation centerPoint, int zoom) {
        Area coverage = GeoLocationCache.calculateCoverage(mapSize, centerPoint, 0, zoom);
        Point topLeft = MapLoader.tileFromLocation(coverage.getxLow(), coverage.getyLow(), zoom);
        Point bottomRight = MapLoader.tileFromLocation(coverage.getxHigh(), coverage.getyHigh(), zoom);
        return new Rectangle(topLeft.x, topLeft.y, bottomRight.x, bottomRight.y);
    }

    public TileSet getAllTiles(Point mapSize, GeoLocation basePoint, int pointLocation, int zoom, boolean cachedOnly) {
        if (mapSize.x < 32 || mapSize.y < 32) {
            return null;
        }
        Area coverage = GeoLocationCache.calculateCoverage(mapSize, basePoint, pointLocation, zoom);
        Point bottomLeft = MapLoader.tileFromLocation(coverage.getxLow(), coverage.getyLow(), zoom);
        Point topRight = MapLoader.tileFromLocation(coverage.getxHigh(), coverage.getyHigh(), zoom);
        Tile[][] tiles = new Tile[bottomLeft.y - topRight.y + 1][topRight.x - bottomLeft.x + 1];
        int x = bottomLeft.x;
        int y = topRight.y;
        int l = (bottomLeft.y - topRight.y + 1) * (topRight.x - bottomLeft.x + 1);
        int i = 0;
        while (i < l) {
            tiles[y - topRight.y][x - bottomLeft.x] = this.getTile(zoom, x, y, cachedOnly);
            if (++x > topRight.x) {
                x = bottomLeft.x;
                ++y;
            }
            ++i;
        }
        double lat = MapLoader.latitudeFromTile(topRight.y, zoom);
        double lon = MapLoader.longitudeFromTile(bottomLeft.x, zoom);
        Point realTopLeft = GeoLocationCache.coordinateToDisplay(new GeoLocation(lat, lon), zoom);
        Point reqTopLeft = GeoLocationCache.coordinateToDisplay(new GeoLocation(coverage.getxHigh(), coverage.getyLow()), zoom);
        return new TileSet(tiles, realTopLeft.x - reqTopLeft.x, realTopLeft.y - reqTopLeft.y, zoom);
    }

    public void loadMissingTiles(TileSet tiles, Runnable completionHandler) {
        int i = 0;
        while (i < tiles.tiles.length) {
            int j = 0;
            while (j < tiles.tiles[i].length) {
                Tile tile = tiles.tiles[i][j];
                if (!tile.isLoaded() && (tile = this.getTile(tiles.zoom, tile.getX(), tile.getY(), false)) != null) {
                    tiles.tiles[i][j] = tile;
                    --tiles.missingTiles;
                }
                ++j;
            }
            ++i;
        }
        this.display.asyncExec(completionHandler);
    }

    protected boolean isInternalImage(Image image) {
        return image == this.missingTile || image == this.borderTile || image == this.loadingTile;
    }

    public void dispose() {
        if (this.loadingTile != null) {
            this.loadingTile.dispose();
        }
        if (this.missingTile != null) {
            this.missingTile.dispose();
        }
        if (this.borderTile != null) {
            this.borderTile.dispose();
        }
    }
}

