/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.widgets.internal;

import java.text.DateFormat;
import java.text.NumberFormat;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.datacollection.Threshold;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.datacollection.Activator;
import org.netxms.ui.eclipse.datacollection.ThresholdLabelProvider;

public class LastValuesLabelProvider
extends LabelProvider
implements ITableLabelProvider,
ITableColorProvider {
    private Image[] stateImages = new Image[3];
    private boolean useMultipliers = true;
    private ThresholdLabelProvider thresholdLabelProvider;

    public LastValuesLabelProvider() {
        this.stateImages[0] = Activator.getImageDescriptor("icons/active.gif").createImage();
        this.stateImages[1] = Activator.getImageDescriptor("icons/disabled.gif").createImage();
        this.stateImages[2] = Activator.getImageDescriptor("icons/unsupported.gif").createImage();
        this.thresholdLabelProvider = new ThresholdLabelProvider();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.stateImages[((DciValue)element).getStatus()];
            }
            case 4: {
                Threshold threshold = ((DciValue)element).getActiveThreshold();
                return threshold != null ? this.thresholdLabelProvider.getColumnImage(threshold, 1) : StatusDisplayInfo.getStatusImage((int)0);
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Long.toString(((DciValue)element).getId());
            }
            case 1: {
                return ((DciValue)element).getDescription();
            }
            case 2: {
                if (((DciValue)element).getDcObjectType() == 2) {
                    return "<< TABLE >>";
                }
                return this.useMultipliers ? this.getValue((DciValue)element) : ((DciValue)element).getValue();
            }
            case 3: {
                return DateFormat.getDateTimeInstance(3, 2).format(((DciValue)element).getTimestamp());
            }
            case 4: {
                return this.formatThreshold(((DciValue)element).getActiveThreshold());
            }
        }
        return null;
    }

    private String formatThreshold(Threshold threshold) {
        if (threshold == null) {
            return "OK";
        }
        return this.thresholdLabelProvider.getColumnText(threshold, 0);
    }

    private String getValue(DciValue element) {
        switch (element.getDataType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                try {
                    long i = Long.parseLong(element.getValue());
                    if (i >= 10000000000L || i <= -10000000000L) {
                        return String.valueOf(Long.toString(i / 1000000000L)) + " G";
                    }
                    if (i >= 10000000L || i <= -10000000L) {
                        return String.valueOf(Long.toString(i / 1000000L)) + " M";
                    }
                    if (i >= 10000L || i <= -10000L) {
                        return String.valueOf(Long.toString(i / 1000L)) + " K";
                    }
                }
                catch (NumberFormatException numberFormatException) {}
                return element.getValue();
            }
            case 5: {
                try {
                    double d = Double.parseDouble(element.getValue());
                    NumberFormat nf = NumberFormat.getNumberInstance();
                    nf.setMaximumFractionDigits(2);
                    if (d >= 1.0E10 || d <= -1.0E10) {
                        return String.valueOf(nf.format(d / 1.0E9)) + " G";
                    }
                    if (d >= 1.0E7 || d <= -1.0E7) {
                        return String.valueOf(nf.format(d / 1000000.0)) + " M";
                    }
                    if (d >= 10000.0 || d <= -10000.0) {
                        return String.valueOf(nf.format(d / 1000.0)) + " K";
                    }
                }
                catch (NumberFormatException numberFormatException) {}
                return element.getValue();
            }
        }
        return element.getValue();
    }

    public void dispose() {
        int i = 0;
        while (i < this.stateImages.length) {
            this.stateImages[i].dispose();
            ++i;
        }
        this.thresholdLabelProvider.dispose();
        super.dispose();
    }

    public boolean areMultipliersUsed() {
        return this.useMultipliers;
    }

    public void setUseMultipliers(boolean useMultipliers) {
        this.useMultipliers = useMultipliers;
    }

    public Color getForeground(Object element, int columnIndex) {
        return null;
    }

    public Color getBackground(Object element, int columnIndex) {
        return null;
    }
}

