/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.eventmanager.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.events.EventTemplate;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class EditEventTemplateDialog
extends Dialog {
    private EventTemplate object;
    private boolean isNew;
    private LabeledText id;
    private LabeledText name;
    private LabeledText message;
    private LabeledText description;
    private Combo severity;
    private Button optionLog;

    public EditEventTemplateDialog(Shell parentShell, EventTemplate object, boolean isNew) {
        super(parentShell);
        this.object = object;
        this.isNew = isNew;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 2;
        layout.horizontalSpacing = 8;
        dialogArea.setLayout((Layout)layout);
        this.id = new LabeledText(dialogArea, 0);
        this.id.setLabel("Event code");
        this.id.setText(Long.toString(this.object.getCode()));
        this.id.getTextControl().setEditable(false);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        this.severity = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)12, (String)"Severity", (Object)gd);
        this.severity.add(StatusDisplayInfo.getStatusText((int)0));
        this.severity.add(StatusDisplayInfo.getStatusText((int)1));
        this.severity.add(StatusDisplayInfo.getStatusText((int)2));
        this.severity.add(StatusDisplayInfo.getStatusText((int)3));
        this.severity.add(StatusDisplayInfo.getStatusText((int)4));
        this.severity.select(this.object.getSeverity());
        this.name = new LabeledText(dialogArea, 0);
        this.name.setLabel("Event name");
        this.name.setText(this.object.getName());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.name.setLayoutData((Object)gd);
        this.optionLog = new Button(dialogArea, 32);
        this.optionLog.setText("&Write to event log");
        this.optionLog.setSelection((this.object.getFlags() & 1) != 0);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalAlignment = 131072;
        gd.verticalAlignment = 1024;
        this.optionLog.setLayoutData((Object)gd);
        this.message = new LabeledText(dialogArea, 0);
        this.message.setLabel("Message");
        this.message.setText(this.object.getMessage());
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.widthHint = 450;
        this.message.setLayoutData((Object)gd);
        this.description = new LabeledText(dialogArea, 0, 2818);
        this.description.setLabel("Description");
        this.description.setText(this.object.getDescription());
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.heightHint = 200;
        gd.verticalAlignment = 4;
        this.description.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void okPressed() {
        this.object.setName(this.name.getText());
        this.object.setSeverity(this.severity.getSelectionIndex());
        this.object.setMessage(this.message.getText());
        this.object.setDescription(this.description.getText());
        this.object.setFlags(this.optionLog.getSelection() ? 1 : 0);
        super.okPressed();
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(this.isNew ? "Create Event Template" : "Edit Event Template");
        super.configureShell(newShell);
    }
}

